/*
Nicole Maestas
October 16, 2002
Reads in Health Insurance data from HRS 98 Flat File. Creates 
 cross-sectional dataset of age 65+ population in 1998.
Modification of Program by Julie Zissimopoulos
*/

options linesize=120 pagesize=60 compress=yes nocenter nodate nonumber
 mprint formdlim=' ' replace;

libname dirnm '/zeno/a/baoping/HRS';
libname flatv8 '/homer/d/HRSAHEAD/Sas8';

* G2686 and F2388: days in bed;
* G6421 and F6018: Total face value of all life insurance policies;

data h00f1a;
set flatv8.h00f1a (in=_in00 keep= hhidpn G482 BIRTHMO BIRTHYD BIRTHYF
BIRTHYR GIWMONTH GIWYEAR GWGTHH GWGTR G2686 G6238 G6240 G6242 G6251 G6254 
G6264 G6266 G6269 G6276 G6280 G6312 G6324 G6333 G6409 G6421 G6313);

in00=_in00;

*proc freq; 
*tables G6409 G6421/ missing;

data h98f1a; 
set flatv8.h98f1a (in=_in98 keep=hhidpn F461 F2388 F6015 F6018 F5939);

in98=_in98;

*proc freq; 
*tables F6015 F6018/ missing;

data dirnm.step100;
merge h98f1a h00f1a;
by hhidpn;

*BIRTHDATE;
*this code only processes data in the 2000 flat file. patty's notes
indicate that the birthmo and birthyr vars originate from tracker file
but she recoded missing birthdates with data from raw files. it is not
clear whether there is any reason to pull birthdates from the RAND HRS
files (cohort files are not complete and are currently in separately
files). cross check if pull in RAND HRS files for other demographics;

if 0<BIRTHMO<13 then bmonth=BIRTHMO;
else bmonth=.;
if 1880<BIRTHYR<1990 then byear=BIRTHYR;
else byear=.;

*fill in missing days and months. if month is missing, birthday is
 july 1, otherwise birthday is the 15th of reported birth month;
bday=.;
if  bmonth=. and not (byear=.) then bday=1;
if  bmonth=. and not (byear=.) then bmonth=7;
else if not (byear=.) then bday=15;
      
*create sas date variable;
if not (byear=.) then bdate=mdy(bmonth,bday,byear);

*INTERVIEW DATE, WAVE 5;
ivwdate=mdy(GIWMONTH,15,GIWYEAR);

*AGE at Wave 5 interview;
age_mo=intck("MONTH",bdate,ivwdate);
age_yr=int(age_mo/12);
age65=(age_yr>=65);

array dk1 G6238 G6240 G6242 G6251 G6254 
G6264 G6266 G6276 G6280 G6312 G6324 G6333;
/*do over dk1; if dk1=8 then dk1=.D; end;*/
do over dk1; if dk1=8 then dk1=.; end;

array na1 G6238 G6240 G6242 G6251 G6254 
G6264 G6266 G6276 G6280 G6312 G6324 G6333;
/*do over na1; if na1=9 then na1=.R; end;*/
do over na1; if na1=9 then na1=.; end;

array no G6238 G6240 G6242 G6251 G6254 
G6264 G6266 G6276 G6280 G6312 G6324 G6333;
do over no; if no=5 then no=0; end;

rename
F461=cohort98
F2388=r4beddays
F6015=r4anylife
F6018=r4lifeins
F5939=r4planltr

G2686=r5beddays
G6409=r5anylife
G6421=r5lifeins
G6313=r5planltr

G482=cohort00
G6238=mdcr 
G6240=mdcrb
G6242=mdcd_nw
G6251=champus
G6254=hmo_cdcr
G6264=semp_ins
G6266=empins
G6269=whosemp
G6276=mdgap
G6280=hmo_mdgp
G6312=mcrsup
G6324=othrins
G6333=hmo_othr
;

*select those age 65 or higher;
*if age_yr>=65;

proc contents;
proc means;