/*
Nicole Maestas
October 16, 2002
Reads in Health Insurance data from HRS 98 Flat File. Creates 
 cross-sectional dataset of age 65+ population in 1998.
Modification of Program by Julie Zissimopoulos
*/

options linesize=79 pagesize=60 compress=yes nocenter nodate nonumber
 mprint formdlim=' ' replace;

libname dir98 '/homer/b/HRSAHEAD/Hrs98.V1';
libname dir00 v6 '/homer/d/HRSAHEAD/Hrs00.ER1';
libname dirnm '/zeno/a/baoping/HRS';
libname flatv8 '/homer/d/HRSAHEAD/Sas8';

*risk vars from wave 5;
data h00e1a;
set flatv8.h00e1a(keep=hhidpn G5027 G5033 G5034
G5035 G5036 G6944 G6945 G6946); /*risk vars*/

data h98f1a; 
set flatv8.h98f1a(in=_in98 keep=hhidpn F461 BIRTHMO BIRTHYD BIRTHYF
BIRTHYR FIVIEWMO FIVIEWYR FWGTHH FWGTR F5866-F5872 F5874-F5879
F5881-F5883 F5885-F5891 F5893 F5894 F5896 F5898-F5903 F5905
F5906M1-F5906M6 F5907-F5912 F5914-F5921 F5923-F5927 F5932 F5933 F5937
F5938 F5940-F5942 F5944-F5948 F5950 F5951 F5953 F5954 F5956
F5957M1-F5957M6 F5958-F5968 F5970 F5971 F5975 F5976 F5980 F5981M1
F5981M2 F5983-F5985 F5988 F5989 F5990M1 F5990M2 F5991-F5993 F5995
F5996M1-F5996M5 F5997 F5999-F6004 F6006 F6007 F6009-F6011 F4560 F4614
F4615 F4616 F4617 F4618);

in98=_in98;

data h94f1a;
set flatv8.h94f1a(keep=hhidpn W9344 W9345 W9346 W9347 W9348);

data dirnm.step1;
merge h98f1a h00e1a h94f1a;
by hhidpn;
if in98;

*BIRTHDATE;
*this code only processes data in the 1998 flat file. patty's notes
indicate that the birthmo and birthyr vars originate from tracker file
but she recoded missing birthdates with data from raw files. it is not
clear whether there is any reason to pull birthdates from the RAND HRS
files (cohort files are not complete and are currently in separately
files). cross check if pull in RAND HRS files for other demographics;

if 0<BIRTHMO<13 then bmonth=BIRTHMO;
else bmonth=.;
if 1880<BIRTHYR<1990 then byear=BIRTHYR;
else byear=.;

*fill in missing days and months. if month is missing, birthday is
 july 1, otherwise birthday is the 15th of reported birth month;
bday=.;
if  bmonth=. and not (byear=.) then bday=1;
if  bmonth=. and not (byear=.) then bmonth=7;
else if not (byear=.) then bday=15;
      
*create sas date variable;
if not (byear=.) then bdate=mdy(bmonth,bday,byear);

*INTERVIEW DATE, WAVE 4;
if FIVIEWYR=1980 then FIVIEWYR=1998;
ivwdate=mdy(FIVIEWMO,15,FIVIEWYR);

*AGE at Wave 4 interview (3.5 pct interviewed in 1999);
age_mo=intck("MONTH",bdate,ivwdate);
age_yr=int(age_mo/12);
age65=(age_yr>=65);

/*
proc freq; 
tables bdate BIRTHMO bmonth BIRTHYR byear bday ivwdate age_mo age_yr
age65  / missing;
format bdate ivwdate worddate.;

*mins and maxes of weights match means reported in tracker file
codebook, but the means are off just a bit on account of different
number of observations;
proc means; var FWGTHH FWGTR;
*/


*CODE MISSING VALUES;

array dk1 F5866-F5869 F5871 F5872 F5874-F5877 F5878 F5881 F5886 F5887
F5891 F5893 F5899 F5903 F5905 F5907-F5912 F5915-F5927 F5933 F5938
F5940 F5944 F5945-F5951 F5956 F5958-F5968 F5971 F5972 F5976 F5980
F5981M1 F5981M2 F5983 F5984 F5985 F5988 F5989 F5990M1 F5990M2 F5995
F5997 F5999-F6002 F6004 F6009 F6010 F6011;
/*do over dk1; if dk1=8 then dk1=.D; end;*/
do over dk1; if dk1=8 then dk1=.; end;

array na1 F5866-F5869 F5871 F5872 F5874-F5877 F5878 F5881 F5886 F5887
F5891 F5893 F5899 F5903 F5905 F5907-F5912 F5918-F5927 F5933 F5938
F5940 F5944 F5945-F5951 F5956 F5958-F5968 F5971 F5972 F5976 F5980
F5981M1 F5981M2 F5983 F5984 F5985 F5988 F5989 F5990M1 F5990M2 F5995
F5997 F5999-F6002 F6004 F6009 F6010 F6011;
/*do over na1; if na1=9 then na1=.R; end;*/
do over na1; if na1=9 then na1=.; end;

array no F5866-F5869 F5871 F5872 F5874-F5877 F5878 F5881 F5886 F5887 F5891
F5893 F5903 F5905 F5907-F5912 F5918-F5927 F5933 F5938 F5944
F5945-F5951 F5956 F5958-F5968 F5971 F5972 F5976 F5980 F5983 F5984
F5985 F5988 F5989 F5995 F5997 F5999-F6002 F6004 F6009 F6010 F6011;
do over no; if no=5 then no=0; end;

array oth F5882 F5883 F5888 F5889 F5990M1 F5990M2 F5991 F6006 F6007
F5901 F5942 F5954 F5996M1-F5996M5; 
/*do over oth; if oth=97 then oth=.O; end;*/
do over oth; if oth=97 then oth=.; end;

array dk2 F5882 F5883 F5888 F5889 F5990M1 F5990M2 F5991 F6006 F6007
F5901 F5942 F5954 F5996M1-F5996M5; 
/*do over dk2; if dk2=98 then dk2=.D; end;*/
do over dk2; if dk2=98 then dk2=.; end;

array na2 F5882 F5883 F5888 F5889 F5990M1 F5990M2 F5991 F6006 F6007
F5901 F5942 F5954 F5996M1-F5996M5; 
/*do over na2; if na2=99 then na2=.R; end;*/
do over na2; if na2=99 then na2=.; end;

array dk3 F5885 F5900;
/*do over dk3; if dk3=9998 then dk3=.D; end;*/
do over dk3; if dk3=9998 then dk3=.; end;

array na3 F5885 F5900;
/*do over na3; if na3=9999 then na3=.R; end;*/
do over na3; if na3=9999 then na3=.; end;

array dk4 F5941 F5953;
/*do over dk4; if dk4=999998 then dk4=.D; end;*/
do over dk4; if dk4=999998 then dk4=.; end;

array na4 F5941 F5953;
/*do over na4; if na4=999999 then na4=.R; end;*/
do over na4; if na4=999999 then na4=.; end;

if F5909=2 then F5909=1; *yes with referral; 
if F5961=2 then F5961=1;

rename
F461=cohort
F5866=mdcr
F5867=mdcrb
F5868=mdcd_bf
F5869=mdcd_nw
F5871=nrs_amcd
F5872=nrsamcd2
F5875=nrs_bmcd
F5876=nrsbmcd2
F5877=nrs_elig
F5878=champus
F5881=hmo_cdcr
F5882=hmocr_yr
F5883=hmocr_mo
F5885=hmocr_am
F5886=hmocr_pr
F5887=hmo_mdcd
F5888=hmocd_yr
F5889=hmocd_mo
F5891=semp_ins
F5893=empins
F5896=whosemp
F5899=empin_py
F5900=empin_am
F5901=empin_pr
F5903=mdgap
F5905=mdgap_cv
F5906M1=mdgap_1
F5906M2=mdgap_2
F5906M3=mdgap_3
F5906M4=mdgap_4
F5906M5=mdgap_5
F5906M6=mdgap_6
F5907=hmo_mdgp
F5908=mdgp_lst
F5909=mdgp_cst
F5910=hmomgp_p
F5911=mdgp_vst
F5912=mdgp_drg
F5915=mdgp_ext
F5916=mdgp_cnd
F5918=chooplan
F5919=otherpln
F5920=altr_drs
F5921=altr_cst
F5924=ins_to65
F5926=ins_sp65
F5927=lvemp_65
F5933=lvemps65
F5938=mcrsup
F5940=msup_cst
F5941=msup_pay
F5942=msup_per
F5944=msup_drg
F5945=msup_dnt
F5947=msup_ext
F5948=msup_cnd
F5950=othrins
F5951=othr_hsp
F5953=othr_pay
F5954=othr_per
F5956=othr_cv
F5957M1=othr_1
F5957M2=othr_2
F5957M3=othr_3
F5957M4=othr_4
F5957M5=othr_5
F5957M6=othr_6
F5958=othr_sps
F5959=hmo_othr
F5960=othr_lst
F5961=othr_cst
F5962=hmooth_p
F5963=othr_dr
F5964=othr_drg
F5965=othr_dnt
F5967=othr_ext
F5968=othr_lmt
F5971=none_evr
F5975=none_exp
F5976=fear_jb
F5980=nohinsr
F5981M1=hashins1
F5981M2=hashins2
F5983=emp_ofrs
F5984=emp_ofrd
F5985=emp_futr
F5988=wdrw_hmo
F5989=vol_hmo
F5990M1=lv_hmo1
F5990M2=lv_hmo2
F5991=lvhmo_mo
F5992=lvhmo_yr
F5995=chng_hin
F5996M1=chghin1
F5996M2=chghin2
F5996M3=chghin3
F5996M4=chghin4
F5996M5=chghin5
F5997=chg_chos
F5999=ltc_hins
F6000=nrs_hins
F6001=ltc_rcvd
F6002=ltc_pymt
F6003=ltc_amt
F6004=ltc_per
F6006=ltc_mos
F6007=ltc_yrs
F6009=ltc_end
F6010=ltc_yend
F6011=hins_hpy
F4560=r4rndm
;


*select those age 65 or higher;
*if age_yr>=65;

proc freq; 
tables cohort hmo_cdcr mdcrb / missing;

proc contents;
proc means;



