/* 
Merge Rand HRS VerC with insurance variables from flat 
files
*/

options ls=120 ps=60 nocenter replace compress=no;

%let maxwv=5;

%let fmtlib=/homer/d/RANDHRS/VerC/Sas8/; *has formats.sas7bdat;
libname library  "&fmtlib"; 

libname hrsin "/homer/d/RANDHRS/VerC/Sas8"; *RAND HRS files;
libname ff "/homer/d/HRSAHEAD/Sas8"; *Raw flat files;
libname dirnm '/zeno/a/baoping/HRS';

%include "/homer/a/Retire/Pgmlib00a/Mac/wvlist.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/wvlabel.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/addsp.mac";

%let demv=rabdate rabyear rabmonth rabflag
	  raeduc raedyrs raedegrm raedegrf ragender ragendrf
	  raracem rahispan %wvlist(s,hhidpn)
	  %wvlist(s,agey_e bdate byear gender hhidpn)
	  %wvlist(r,proxy mstat mpart agey_e) r5iwend raovrlap inw1-inw5;

%let health=r4hibpe r4diabe r4cancre r4lunge r4hearte r4stroke
	  r4psyche r4arthre r4conde;

%let wealthincome=
R1IEARN
R1IPENA
R1ISSDI
R1ISRET
R1IUNWC
R1IGXFR
R1FWAGE
R1FBON
R1F2ND
R1FTRAD
R1FSSDI
R1FSS
R1FUNEM
R1FWCMP
R1FVET
R1FPEN
R1FANN
R1FSSI
S1IEARN
S1IPENA
S1ISSDI
S1ISRET
S1IUNWC
S1IGXFR
S1FWAGE
S1FBON
S1F2ND
S1FTRAD
S1FSSDI
S1FSS
S1FUNEM
S1FWCMP
S1FVET
S1FPEN
S1FANN
S1FSSI
H1ICAP
H1IOTHR
H1ITOT
H1FBUSIN
H1FRNTIN
H1FDIVIN
H1FTRSIN
H1FFOOD
H1FALMNY
H1FWELF
H1FRNTEX
H1FINSLU
H1FSSJ
H1FPENLU
H1FINHLU
H1FOTHIN
R1IFEARN
R1IFPENA
R1IFSSDI
R1IFSRET
R1IFUNWC
R1IFGXFR
S1IFEARN
S1IFPENA
S1IFSSDI
S1IFSRET
S1IFUNWC
S1IFGXFR
H1IFCAP
H1IFOTHR
H1IFTOT
R2IEARN
R2IPENA
R2ISSDI
R2ISRET
R2IUNWC
R2IGXFR
R2FWAGE
R2FBON
R2F2ND
R2FTRAD
R2FSSDI
R2FSS
R2FUNEM
R2FWCMP
R2FVET
R2FWELF
R2FPEN1
R2FPEN2
R2FPEN3
R2FANN1
R2FANN2
R2FANN3
R2FSSI
S2IEARN
S2IPENA
S2ISSDI
S2ISRET
S2IUNWC
S2IGXFR
S2FWAGE
S2FBON
S2F2ND
S2FTRAD
S2FSSDI
S2FSS
S2FUNEM
S2FWCMP
S2FVET
S2FWELF
S2FPEN1
S2FPEN2
S2FPEN3
S2FANN1
S2FANN2
S2FANN3
S2FSSI
H2ICAP
H2IOTHR
H2ITOT
H2FBUSIN
H2FRNTIN
H2FDIVIN
H2FTRSIN
H2FFOOD
H2FALMNY
H2FRNTEX
H2FSFEMP
H2FOTHI1
H2FOTHI2
H2FLUYR1
H2FLUYR2
H2FLUYR3
R2IFEARN
R2IFPENA
R2IFSSDI
R2IFSRET
R2IFUNWC
R2IFGXFR
S2IFEARN
S2IFPENA
S2IFSSDI
S2IFSRET
S2IFUNWC
S2IFGXFR
H2IFCAP
H2IFOTHR
H2IFTOT
R3IEARN
R3IPENA
R3ISSDI
R3ISRET
R3IUNWC
R3IGXFR
R3FWAGE
R3FBON
R3F2ND
R3FTRAD
R3FSSDI
R3FSS
R3FUNEM
R3FWCMP
R3FVET
R3FSEMP
R3FPEN1
R3FPEN2
R3FPEN3
R3FANN1
R3FANN2
R3FANN3
S3IEARN
S3IPENA
S3ISSDI
S3ISRET
S3IUNWC
S3IGXFR
S3FWAGE
S3FBON
S3F2ND
S3FTRAD
S3FSSDI
S3FSS
S3FUNEM
S3FWCMP
S3FVET
S3FSEMP
S3FPEN1
S3FPEN2
S3FPEN3
S3FANN1
S3FANN2
S3FANN3
H3ICAP
H3IOTHR
H3ITOT
H3FBUSIN
H3FRNTIN
H3FDIVIN
H3FTRSIN
H3FFOOD
H3FALMNY
H3FWELF
H3FSSI
H3FBNDIN
H3FCHKIN
H3FCDIN
H3FOTHI1
H3FOTHI2
H3FLUYR1
H3FLUYR2
H3FLUYR3
R3IFEARN
R3IFPENA
R3IFSSDI
R3IFSRET
R3IFUNWC
R3IFGXFR
S3IFEARN
S3IFPENA
S3IFSSDI
S3IFSRET
S3IFUNWC
S3IFGXFR
H3IFCAP
H3IFOTHR
H3IFTOT
R4IEARN
R4IPENA
R4ISSDI
R4ISRET
R4IUNWC
R4IGXFR
R4FWAGE
R4FBON
R4F2ND
R4FTRAD
R4FSSDI
R4FSS
R4FUNEM
R4FWCMP
R4FVET
R4FSEMP
R4FPEN1
R4FPEN2
R4FPEN3
R4FANN1
R4FANN2
R4FANN3
S4IEARN
S4IPENA
S4ISSDI
S4ISRET
S4IUNWC
S4IGXFR
S4FWAGE
S4FBON
S4F2ND
S4FTRAD
S4FSSDI
S4FSS
S4FUNEM
S4FWCMP
S4FVET
S4FSEMP
S4FPEN1
S4FPEN2
S4FPEN3
S4FANN1
S4FANN2
S4FANN3
H4ICAP
H4IOTHR
H4ITOT
H4FBUSIN
H4FRNTIN
H4FDIVIN
H4FTRSIN
H4FFOOD
H4FALMNY
H4FWELF
H4FSSI
H4FBNDIN
H4FCHKIN
H4FCDIN
H4FOTHI1
H4FOTHI2
H4FLUYR1
H4FLUYR2
H4FLUYR3
R4IFEARN
R4IFPENA
R4IFSSDI
R4IFSRET
R4IFUNWC
R4IFGXFR
S4IFEARN
S4IFPENA
S4IFSSDI
S4IFSRET
S4IFUNWC
S4IFGXFR
H4IFCAP
H4IFOTHR
H4IFTOT
R5IEARN
R5IPENA
R5ISSDI
R5ISRET
R5IUNWC
R5IGXFR
R5FWAGE
R5FBON
R5F2ND
R5FTRAD
R5FSSDI
R5FSS
R5FUNEM
R5FWCMP
R5FVET
R5FSEMP
R5FPEN1
R5FPEN2
R5FPEN3
R5FANN1
R5FANN2
R5FANN3
S5IEARN
S5IPENA
S5ISSDI
S5ISRET
S5IUNWC
S5IGXFR
S5FWAGE
S5FBON
S5F2ND
S5FTRAD
S5FSSDI
S5FSS
S5FUNEM
S5FWCMP
S5FVET
S5FSEMP
S5FPEN1
S5FPEN2
S5FPEN3
S5FANN1
S5FANN2
S5FANN3
H5ICAP
H5IOTHR
H5ITOT
H5FBUSIN
H5FRNTIN
H5FDIVIN
H5FTRSIN
H5FFOOD
H5FALMNY
H5FWELF
H5FSSI
H5FBNDIN
H5FCHKIN
H5FCDIN
H5FOTHI1
H5FOTHI2
H5FLUYR1
H5FLUYR2
H5FLUYR3
R5IFEARN
R5IFPENA
R5IFSSDI
R5IFSRET
R5IFUNWC
R5IFGXFR
S5IFEARN
S5IFPENA
S5IFSSDI
S5IFSRET
S5IFUNWC
S5IFGXFR
H5IFCAP
H5IFOTHR
H5IFTOT
H1AFCHCK
H1AFCD
H1AFSTCK
H1AFBOND
H1AFIRA
H1AFRLES
H1AFBSNS
H1AFOTHR
H1AFDEBT
H1AFHOUS
H1AHOUS
H1ASTCK
H1ACHCK
H1AIRA
H1ACD
H1ABSNS
H1ARLES
H1ABOND
H1AOTHR
H1ADEBT
H2AFRLES
H2AFTRAN
H2AFBSNS
H2AFIRA
H2AFSTCK
H2AFCHCK
H2AFCD
H2AFBOND
H2AFOTHR
H2AFDEBT
H2AFHOUS
H2AHOUS
H2ASTCK
H2ACHCK
H2AIRA
H2ACD
H2ATRAN
H2ABSNS
H2ARLES
H2ABOND
H2AOTHR
H2ADEBT
H3AFSTCK
H3AFRLES
H3AFBSNS
H3AFCHCK
H3AFCD
H3AFBOND
H3AFOTHR
H3AFTRAN
H3AFDEBT
H3AFHOUS
H3AHOUS
H3ASTCK
H3ACHCK
H3ACD
H3ATRAN
H3ABSNS
H3ARLES
H3ABOND
H3AOTHR
H3ADEBT
H4AFRLES
H4AFBSNS
H4AFSTCK
H4AFBOND
H4AFCHCK
H4AFCD
H4AFTRAN
H4AFOTHR
H4AFDEBT
H4ASTCK
H4ACHCK
H4ACD
H4ATRAN
H4ABSNS
H4ARLES
H4ABOND
H4AOTHR
H4ADEBT
H5AFRLES
H5AFBSNS
H5AFSTCK
H5AFBOND
H5AFCHCK
H5AFCD
H5AFTRAN
H5AFOTHR
H5AFDEBT
H5ASTCK
H5ACHCK
H5ACD
H5ATRAN
H5ABSNS
H5ARLES
H5ABOND
H5AOTHR
H5ADEBT
H1ATRAN
H3AIRA
H4AIRA
H5AIRA
H4AHOUS
H5AHOUS
H1AMORT
H2AMORT
H3AMORT
H4AMORT
H5AMORT
H1AHMLN
H2AHMLN
H3AHMLN
H4AHMLN
H5AHMLN
H1AFTRAN
H3AFIRA
H4AFIRA
H5AFIRA
H4AFHOUS
H5AFHOUS
H1AFMORT
H2AFMORT
H3AFMORT
H4AFMORT
H5AFMORT
H1AFHMLN
H2AFHMLN
H3AFHMLN
H4AFHMLN
H5AFHMLN
H1ATOTA
H2ATOTA
H3ATOTA
H4ATOTA
H5ATOTA
H1ATOTW
H2ATOTW
H3ATOTW
H4ATOTW
H5ATOTW
H1ATOTH
H2ATOTH
H3ATOTH
H4ATOTH
H5ATOTH
H1ATOTN
H2ATOTN
H3ATOTN
H4ATOTN
H5ATOTN
H1ATOTF
H2ATOTF
H3ATOTF
H4ATOTF
H5ATOTF
H2ATOTAC
H3ATOTAC
H4ATOTAC
H5ATOTAC
H2ATOTWC
H3ATOTWC
H4ATOTWC
H5ATOTWC
H2ATOTHC
H3ATOTHC
H4ATOTHC
H5ATOTHC
H2ATOTFC
H3ATOTFC
H4ATOTFC
H5ATOTFC
H2ATOTNC
H3ATOTNC
H4ATOTNC
H5ATOTNC;

data temp;
	merge dirnm.step2

	hrsin.rndhrs_c (keep=hhidpn &demv 
		%wvlist(r,shlt) r5hltc r4cesd r4cesdm %wvlist(r,smokev smoken) 
		%wvlist(r,adla) %wvlist(r,iadlza,begwv=3)
		r4liv75r r4liv85r r4proxy 
		&health 
		&wealthincome
		%wvlist(r,work62 work65 sayret retmon retyr rplnyr) r1rplnya 
		%wvlist(r,rplnya,begwv=3) %wvlist(s,work62 work65 sayret retmon retyr rplnyr)
		s1rplnya %wvlist(s,rplnya,begwv=3) 
		%wvlist(r,sayret lbrf work) %wvlist(s,lbrf work)
		r1risk);
	by hhidpn;
	if inw5=1;
*	if raovrlap=0;
run;

libname ssain  v6 "/homer/b/Retire/H00a";
%addsp(r4getsps r4hmo, temp, dirnm.h00);

proc contents;
proc means;
endsas;


