/* 
Merge Rand HRS VerC with insurance variables from flat 
files
*/

options ls=120 ps=60 nocenter replace compress=no;

%let maxwv=5;

%let fmtlib=/homer/d/RANDHRS/VerC/Sas8/; *has formats.sas7bdat;
libname library  "&fmtlib"; 

libname hrsin "/homer/d/RANDHRS/VerC/Sas8"; *RAND HRS files;
libname ff "/homer/d/HRSAHEAD/Sas8"; *Raw flat files;
libname dirnm '/zeno/a/baoping/HRS';

%include "/homer/a/Retire/Pgmlib00a/Mac/wvlist.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/wvlabel.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/addsp.mac";

%let newvar1=%wvlist(r, HIBPS DIABS CANCRS LUNGS HEARTS STROKS PSYCHS ARTHRS 
SHLTC SHLTCF ADLC GROSSC FINEC ADLF GROSSF FINEF 
HIBPE DIABE CANCRE LUNGE HEARTE STROKE PSYCHE ARTHRE
HIBPF DIABF CANCRF LUNGF HEARTF STROKF PSYCHF ARTHRF
BACK ADLWA ADLA IADLA IADLZA MOBILA LGMUSA GROSSA FINEA, begwv=4);

%let newvar2=%wvlist(s, HIBPS DIABS CANCRS LUNGS HEARTS STROKS PSYCHS ARTHRS 
SHLTC SHLTCF ADLC GROSSC FINEC ADLF GROSSF FINEF 
HIBPE DIABE CANCRE LUNGE HEARTE STROKE PSYCHE ARTHRE
HIBPF DIABF CANCRF LUNGF HEARTF STROKF PSYCHF ARTHRF
BACK ADLWA ADLA IADLA IADLZA MOBILA LGMUSA GROSSA FINEA, begwv=4);

%let expense=%wvlist(r, OOPMD OOPMDF TOTMD TOTMDF, begwv=4) 
		%wvlist(s, OOPMD OOPMDF TOTMD TOTMDF, begwv=4);

data temp;
merge dirnm.step200

	hrsin.rndhrs_c (keep=hhidpn r5mstat r5agey_e s5agey_e r5lbrf
		r4slfemp r5slfemp 
		h5astck h5abond h5achck h5acd h5aira h5arles h5absns h5itot h5atota
		h5atotf h5atotn
		h4astck h4abond h4achck h4acd h4aira h4arles h4absns h4itot h4atota
		h4atotf h4atotn 
		r4bmi s4bmi r5bmi s5bmi 
		r4conde r4condem s4conde s4condem r5conde r5condem s5conde s5condem 
		r4conds r4condsm r4condsp s4conds s4condsm s4condsp 
		r5conds r5condsm r5condsp s5conds s5condsm s5condsp
		r4liv85r r5liv10r s4liv85r s5liv10r r1finpln s1finpln 
		r4inher s4inher r5inher s5inher
		r4beqany s4beqany r5beqany s5beqany 
		h4hhres h5hhres h1child h4icap h4itot h5icap inw1-inw5
		&newvar1 &newvar2 &expense
		);
	by hhidpn;
run;

*libname ssain  v6 "/homer/b/Retire/H00a";
libname ssain  v6 "/zeno/a/baoping/HRS";

%addsp(r5getsps r5hmo, temp, dirnm.h00new);

proc contents;
proc means;
endsas;


