/*
Program by Nicole Maestas, Ph.D.
RAND
This Version: June 11, 2007
This file name: epdv.sas

This is a SAS macro that computes the expected present discounted
value of any benefit stream.

Place the epdv.sas and initialize.sas in the same directory and add
the following line to your SAS program. This line inputs the survival
probabilities.

 %include "/your directory/initialize.sas";

Invoking the macro requires four inputs specified in the following
order:

%macro epdv(retdate,cdate,bdate,sex,discount,ben,epdv=epdv,yr=1998);

First, in place of 'retdate' provide the name of a variable containing
the retirement date or alternatively the calendar date for which you
want the benefit computed. Second, in place of 'cdate' provide a
variable measuring the benefit claiming date. For respondents who
retire and claim at the same time, then this is the same as the
retirement date. For those who retire before claiming, then the macro
implicitly assumes zero benefits until claiming but discounts all the
way to the earlier retirement date. If the retirement date exceeds the
claiming date then the program sets the retirement date to the
claiming date. Third, the respondents birthdate is required to compute
survival probabilities. Fourth, a variable recording the sex of the
respondent, coded with 1 for males and 2 for females, is also required
for computing survival probabilities. Fifth, a discount rate must be
provided (for a 4 percent discount rate, simply enter '4', do not
enter .04 as the program will further divide this amount by 100!).
Fifth, enter the MONTHLY benefit or annuity amount (the program
converts this to an annual benefit amount). The output variable is
called epdv, unless you rename it (e.g. epdv=myepdv2006).  Finally,
the program uses the 1998 lifetable to compute survival
probabilities. If you wish to use a lifetable for a different year,
then change the value of the yr argument (e.g., yr=2000). Currently
initialize.sas has the lifetables for 1998-2003.

*/


%macro epdv(retdate,cdate,bdate,sex,discount,ben,epdv=epdv,yr=1998);

_claimage=int((&cdate-&bdate)/365.25);
_retage=int((&retdate-&bdate)/365.25);
if _retage>_claimage then _retage=_claimage;
if _claimage>99 then _claimage=99;

_ben=&ben*12;
_discount=&discount/100;

if &sex=1 then do;
  &epdv=_ben;
  do i=_claimage+1 to 100;
    &epdv=&epdv+(_ben/(1+_discount)**(i-_retage))*(put(i,lx&yr.m.)/put((i-1),lx&yr.m.));
  end;
end;

if &sex=2 then do;
  &epdv=_ben;
  do i=_claimage+1 to 100;
    &epdv=&epdv+(_ben/(1+_discount)**(i-_retage))*(put(i,lx&yr.w.)/put((i-1),lx&yr.w.));
  end;
end;

drop _claimage _retage _discount _ben;

%mend;