*******************************************************
* Main specificsion but with 2 Points of Support
* Uses State Regulatory Variables as Instruments 
* Uses wealth and income variables.			
* Full Model with MNL for insurance.			
* Probit for any risky assets.				
* No medicaid folks.				         
* Mean of discrete factor normalized to 0.		
* Using OLD version of Stata       
* Main specification will now be for the financial respondent, not random spouse
* Drop Business Owners
* Add Pension Wealth, Life expectancy, LTC Insurance, Home Ownership, Bequest Probability
* Alternative instrument--community rating in state
* Fixed error in definition of scalar rho13
****************************************************************************

global path "C:\Documents and Settings\maestas\My Documents\"
global workdir "$path\Medicare HMOs\Output\JAE Revision\"
global datadir "$path\Medicare HMOs\Data\"
global progdir "$path\Medicare HMOs\Programs\JAE Revision\"

cd "$workdir"

capture log close
log using ThreePart62_2POS_deciles_lowtert.log  
*log using ThreePart62_2POS_deciles_lowtert.log, replace
disp "Working directory is " "$workdir"
disp "Data directory is " "$datadir"
clear
set seed 136984
set linesize 120
set memory 200m
set matsize 800
set more off

global InputFromFile = 0
global InputFile     = "ThreePart6_all_results_pen_lx_ltc_home_beq5_altinst.dta"
global ParamFile	   = "ThreePart6_all_results_pen_lx_ltc_home_beq5_altinst.dta"
global OutSheet	   = "ThreePart6_all_pen_lx_ltc_home_beq5_altinst.txt"


		***********
		* LOAD LF *
		***********
		run "$progdir\LikeFunction2.do"
		program dir 

		*************
		* LOAD DATA *
		*************
		use "$datadir\Latest Data\hrs_cmsec_clean.dta"
		gen pop_county = pop2000/10000
		rename stpop2000 pop_state
		rename stemp52 emp_finance_state
		rename stestab52 estab_finance_state
		rename h5hhres hhsize
		gen age = r5agey_e
		gen agesq = age*age/1000
		gen finance_emp_per_capita = emp_finance_state/pop_state
		gen finance_estab_per_capita = estab_finance_state/pop_state
		tab r4shlt, gen(srhealth)
		gen fairpoor = r4shlt==4 | r4shlt==5 if r4shlt<.
		gen female = gender2
		centile h4inctot, centile(25 50 75)
		gen h4incquart1 = h4inctot<=r(c_1)
		gen h4incquart2 = h4inctot>r(c_1) & h4inctot<=r(c_2)
		gen h4incquart3 = h4inctot>r(c_2) & h4inctot<=r(c_3)
		gen h4incquart4 = h4inctot>r(c_3) & h4inctot<.

		***********************
		* INSURANCE HIERARCHY *
		***********************
		tab r5inscat r5inscatnew
		# delimit ;
		label define inslbl 	1 "1.A&B only"
						2 "2.HMO"
						3 "3.Emp Supp"
						4 "4.Medigap"
						5 "5.Medicaid";
		#delimit cr
		gen r5bencat = r5inscatnew
		label values r5bencat inslbl
		tab r5bencat [aw=r5wgtr]


		*****************
		* DEFINE SAMPLE *
		*****************
  		*gen draw = uniform()
 		*sort hhid draw
 		*by hhid: keep if _n==1
            sort hhid
		by hhid: gen numinhh=_N
		gen sample=r5finr==1
		replace sample=1 if r5finr==0 & numinhh==1 		
		keep if sample==1 & h5ownbus==0
		disp "Original Sample Size = " _N
		drop if r5bencat>=.
		keep if r5bencat<5
		keep if unitedmrate00F<.
		keep if pop2000<.
		keep if raeduc<.
		keep if r4shlt<.
		drop if r5wgtr==0
		disp "Final Sample Size = " _N


		***************************
		* 	CREATE INSTRUMENTS  *
		***************************
		*gen no_hmo = missing(premium)
		*gen price_hmo = premium
		*replace price_hmo = 0 if no_hmo
		gen price_mgap = unitedmrate00F
		gen firm_size = size_00

            *make dummy for states with mandatory community rating
		gen cmrate=(State=="AR" | State=="CT" | State=="ME" | State=="MA" | State=="MN" | State=="NY" | State=="WA")
		*add states that ban attained age plans
            gen cmrate_noaa=(cmrate==1 | State=="FL" | State=="GA" | State=="ID")


		*********************
		* 	LOAD THE ARF  *
		*********************
		tempfile hrs arf
		save `hrs'
		use "$datadir/ARF_premium2"
		rename StCty0 fipscnty
		sort fipscnty

  		***********************************
		* 	CREATE RESIDUALS USING ARF  *
		***********************************
		summ rpayexpen
		gen miss_payexp = missing(rpayexpen)
		replace rpayexpen=r(mean) if miss_payexp
		gen md_per_1000 = docpercap*1000
		gen bed_per_1000 = hosbedpercap*1000
		gen avg_exp = totprtab2000/1000
		#d ;
		global premreg "medihdincome99 povrate65up md_per_1000 bed_per_1000 avg_exp perpop85up
				  perpop65up size_00 rpayexpen miss_payexp drate84up perwhite0 perblack0 perothers0
				  perhisplati0 censpop0";
		#d cr
		
	    * Fitted county offers an HMO
		gen offer = ~(numplans_risk==0)
		logit offer $premreg
		predict pofferhmo

	    * Residual average Medigap Prices
		reg mrate00F $premreg
		predict resid_united, resid
		gen num = numinsurer00F
		gen num2 = num*num
		reg resid_united num num2
		predict mgap_fit	
		save `arf'

  		*************************
		*  MERGE BACK WITH HRS  *
		*************************
		use `hrs'
		sort fipscnty
		merge fipscnty using `arf'
            tab _merge
            keep if _merge==1 | _merge==3

		*********************************
		* 	DEFINE REGRESSORS         *
		********************************
		gen hmo_under65 = hmoprate98_nonmed
		replace hmopremium=0 if hmopremium==.
		gen mincap02 = mincpsur02/1000000
		gen premtax02 = maxpprm02
		replace r4beq100=r4beq100/100
		replace r5beqany=r5beqany/100
		
          gen r4beq100_rcd=r4beq100
          replace r4beq100_rcd=-1 if r4beq100==.
	    gen r4beq100miss=(r4beq100_rcd==-1)

		centile h4atota , centile(33 66)
		gen h4wtert1 = h4atota <=r(c_1)
		gen h4wtert2 = h4atota >r(c_1) & h4atota <=r(c_2)
		gen h4wtert3 = h4atota >r(c_2) & h4atota <.

		sum h4atota h4wtert*
		
		#delimit ;
		global varlist_exog "age agesq female educ2-educ4 rablack rahisp raother r5divorced r5widowed 
					   r5nevmar hhsize h4hibpe h4diabe h4cancre h4lunge h4hearte h4stroke 
					   h4psyche h4arthre h5majors fairpoor h4incquint2-h4incquint5 
                                 h5ashtotpenw r5liv10r_rcd r5livmiss 
					   h4hiltc h4ownhome r4beq100_rcd r4beq100miss";

		global varlist_arf  "avg_exp pop_county";
		global regress 	  "$varlist_exog $varlist_arf";
		global policy_hmo   "hmo_under65 cmrate_noaa";
		global policy_supp  "hmo_under65 cmrate_noaa";
		*global policy_hmo   "hmo_under65 unitedmrate00F";
		*global policy_supp  "hmo_under65 unitedmrate00F";

		#delimit cr

		*********************************
		* 	DEFINE INSURANCE          *
		*********************************
		gen supplem = r5bencat==3 | r5bencat==4
		gen hmo = r5bencat==2
		gen none = r5bencat==1
		tabstat supplem hmo none, by(r5bencat)
		gen fair_hmo = fairpoor*hmo
		gen fair_supp = fairpoor*supplem

		***************************
		* 	DEFINE DEP VARIABLE *
		***************************
		gen depvar = h5anyrisky2
	
		*********************
		* NORMALIZE WEIGHTS *
		*********************
		gen weight=r5wgtr
		qui summ weight
		gen weight_new = weight/r(mean)

* Note:  Create a file called Results which contains
* the following variables:
*		method - string identifying which estimation
*		m_sup - mean estimate of risky assets if everyone has supplemental insurance
*		m_hmo  - estimate of risky assets if everyone has HMO
*		m_non - estimate of risky assets if everyone has neither supplemental nor HMO

		***************************
		* 	RAW MEAN ESTIMATES  *
		***************************
		preserve
			gen str20 method = "Raw Means" in 1
			quietly summ depvar if supplem & ~hmo [aw=weight_new]
			gen m_sup = r(mean) in 1
			quietly summ depvar if hmo & ~supplem [aw=weight_new]
			gen m_hmo = r(mean) in 1
			quietly summ depvar if none [aw=weight_new]
			gen m_non = r(mean) in 1
			keep method m_*
			keep if _n==1
			save Results.dta, replace
		restore

		***********************
		* INSURANCE ESTIMATES *
		***********************
		probit supplem $regress $policy_supp
		matrix savesupp = e(b)
		mat colnames savesupp = SUPP: 
		probit hmo $regress $policy_hmo [aw=weight_new]
		matrix savehmo = e(b)
		mat colnames savehmo = HMO: 


*SAMPLE RESTRICTION--RUN MODEL ONLY FOR THOSE IN upper WEALTH tertile
keep if h4wtert1==1

		****************
		* NAIVE PROBIT *
		****************
		probit depvar supplem hmo $regress [aw=weight_new]
		matrix saverisky = e(b)
		mat colnames saverisky = RISKY: 

 		* Predictions
		preserve
			gen str20 method = "Naive Probit" in 1
		* Supplemental for everyone
      replace supplem = 1
			replace hmo = 0
			predict risky, p
			quietly summarize risky [aw=weight_new]
			gen m_sup = r(mean) in 1		
		* HMO for everyone
			drop risky
      		replace supplem = 0
			replace hmo = 1
			predict risky, p
			quietly summarize risky [aw=weight_new]
			gen m_hmo = r(mean) in 1
		* Neither
			drop risky
      replace supplem = 0
			replace hmo = 0
			predict risky, p
			quietly summarize risky [aw=weight_new]
			gen m_non = r(mean) in 1		
		* Add to results dataset
			keep if _n==1
			keep method m_*
			append using Results.dta
			save Results.dta, replace
			list
		restore

		***********************
		* GET STARTING VALUES *
		***********************
* Can also get estimates from a saved file
* 	a) bring in dataset with vector of parameter estimates (varname = estimate)
*		b) make vector into a matrix using the makemat command
*		c) save the transposed matrix as initmat
 if $InputFromFile {
		tempfile temp
		save `temp'
		use $InputFile
		mkmat estimate, matrix(init)
		matrix initnew = init'
		matrix initmat = initnew
	      local obs = _N
		forvalues i=1(1)`obs' {
			local eqi = eq[`i']
			local parmi = parm[`i']
			local namei = "`eqi'"+":"+"`parmi'"
			matname initmat "`namei'", col(`i') explicit
			}
		use `temp'
		}
else 	{
		matrix rho11mat = -0.284
		matrix rho12mat = 0.035
		matrix rho13mat = 10.135
		matrix d1mat = -0.179
		matrix colnames rho11mat= RHO11:_cons
		matrix colnames rho12mat= RHO12:_cons
		matrix colnames rho13mat= RHO13:_cons
		matrix colnames d1mat= D1:_cons


		mat initmat = saverisky, savesupp, savehmo, rho11mat, rho12mat, rho13mat, d1mat
  	}

		*********
		* DO ML *
		*********
	#delimit ;
	ml model lf DFLike
			 	(RISKY: depvar= supplem hmo $regress) 
				(SUPP: supplem = $regress $policy_supp)
				(HMO: hmo = $regress $policy_hmo) 
				(RHO11:)
				(RHO12:)
				(RHO13:)
				(D1:);
	#delimit cr
	ml init initmat
	ml maximize, difficult
	parmest, saving($ParamFile,replace) 

		******************************
		* COMPUTE CORRELATION MATRIX *
		******************************
* Get probabilties
	scalar p1 = exp([D1]_cons)/(1+exp([D1]_cons))
	scalar p2= 1-p1

* Get first points of support
	scalar rho11 = [RHO11]_cons
	scalar rho12 = [RHO12]_cons
	scalar rho13 = [RHO13]_cons

* Get second points of support
	scalar rho21 = -1*(rho11*p1)/p2
	scalar rho22 = -1*(rho12*p1)/p2
	scalar rho23 = -1*(rho13*p1)/p2

* Get variances
	scalar var1 = p1*rho11^2 + p2*rho21^2 +1
	scalar var2 = p1*rho12^2 + p2*rho22^2 +1
	scalar var3 = p1*rho13^2 + p2*rho23^2 +1

* Get covariances
	scalar cov12 = p1*rho11*rho12 + p2*rho21*rho22
	scalar cov13 = p1*rho11*rho13 + p2*rho21*rho23
	scalar cov23 = p1*rho13*rho12 + p2*rho23*rho22

* Get correlations
	scalar corr12 = cov12/(sqrt(var1)*sqrt(var2))
	scalar corr13 = cov13/(sqrt(var1)*sqrt(var3))
	scalar corr23 = cov23/(sqrt(var2)*sqrt(var3))

* Construct covariance matrix
	matrix V = (var1,cov12,cov13 \ cov12, var2, cov23 \ cov13, cov23, var3)
	matrix colnames V = RISKY SUPP HMO
	matrix rownames V = RISKY SUPP HMO
	matrix list V

* Construct correlation matrix
	matrix Corr = (1,corr12,corr13 \ corr12, 1, corr23 \ corr13, corr23, 1)
	matrix colnames Corr = RISKY SUPP HMO
	matrix rownames Corr = RISKY SUPP HMO
	matrix list Corr


****************************************************************
* Get standard errors by delta method for transformed parameters
****************************************************************

  nlcom rho21: -1*(_b[RHO11:_cons]*exp(_b[D1:_cons]))
  nlcom rho22: -1*(_b[RHO12:_cons]*exp(_b[D1:_cons]))
  nlcom rho23: -1*(_b[RHO13:_cons]*exp(_b[D1:_cons]))
  	
  nlcom p1: exp(_b[D1:_cons])/(1+exp(_b[D1:_cons]))
  nlcom p2: 1/(1+exp(_b[D1:_cons]))


		******************
		* DO PREDICTIONS *
		******************
* Probability of risky asset given status quo for insurance
  predict index1, eq(RISKY) xb
  gen prsky_chk = norm(index1+ rho11)*p1 + norm(index1+ rho21)*p2
	predictnl prsky=norm(predict(xb) + _b[RHO11:_cons])*exp(_b[D1:_cons])/(1+exp(_b[D1:_cons])) + norm(predict(xb) + (-1*_b[RHO11:_cons]*exp(_b[D1:_cons])))*(1/(1+exp(_b[D1:_cons]))), se(prsky_se) force
	summ depvar prsky* [aw=weight_new]
* Supplemental for everyone
  replace supplem = 1
	replace hmo = 0
	drop index1
	predict index1, eq(RISKY) xb
	gen prsky_sup_chk = norm(index1+ rho11)*p1 + norm(index1+ rho21)*p2
  predictnl prsky_sup=norm(predict(xb) + _b[RHO11:_cons])*exp(_b[D1:_cons])/(1+exp(_b[D1:_cons])) + norm(predict(xb) + (-1*_b[RHO11:_cons]*exp(_b[D1:_cons])))*(1/(1+exp(_b[D1:_cons]))), se(prsky_sup_se) force
	summ prsky_sup* [aw=weight_new]
	
* HMO for everyone
  replace supplem = 0
	replace hmo = 1
	drop index1
	predict index1, eq(RISKY) xb
 	gen prsky_hmo_chk = norm(index1+ rho11)*p1 + norm(index1+ rho21)*p2 
  predictnl prsky_hmo=norm(predict(xb) + _b[RHO11:_cons])*exp(_b[D1:_cons])/(1+exp(_b[D1:_cons])) + norm(predict(xb) + (-1*_b[RHO11:_cons]*exp(_b[D1:_cons])))*(1/(1+exp(_b[D1:_cons]))), se(prsky_hmo_se) force
	summ prsky_hmo* [aw=weight_new]

* Neither
 	replace supplem = 0
	replace hmo = 0
	drop index1
	predict index1, eq(RISKY) xb
	gen prsky_non_chk = norm(index1+ rho11)*p1 + norm(index1+ rho21)*p2
  predictnl prsky_non=norm(predict(xb) + _b[RHO11:_cons])*exp(_b[D1:_cons])/(1+exp(_b[D1:_cons])) + norm(predict(xb) + (-1*_b[RHO11:_cons]*exp(_b[D1:_cons])))*(1/(1+exp(_b[D1:_cons]))), se(prsky_non_se) force
	summ prsky_non* [aw=weight_new]

* Probability Differences
  gen d_sup_non=prsky_sup-prsky_non
  gen d_hmo_non=prsky_hmo-prsky_non
  gen d_sup_hmo=prsky_sup-prsky_hmo
  
  gen d_sup_non_se=sqrt((prsky_sup_se^2) + (prsky_non_se^2))
  gen d_hmo_non_se=sqrt((prsky_hmo_se^2) + (prsky_non_se^2))
  gen d_sup_hmo_se=sqrt((prsky_sup_se^2) + (prsky_hmo_se^2))
  
  summ d_* [aw=weight_new]


* Add to results database
	gen str20 method = "Discrete Factor"
	foreach X in sup hmo non {
		quietly summ prsky_`X' [aw=weight_new]
		quietly gen m_`X' = r(mean) in 1
	}
	keep if _n==1
	keep method m_*
	append using Results.dta
	save Results.dta, replace
	format m_* %10.4fc
	list method m_*
	outsheet using "$OutSheet" , comma replace
	log close
