log using ARF2000_101,text 
clear 
set memory 356m
global data "C:\Documents and Settings\qma\My Documents\Medicare HMOs\Data"
cd "$data"

*****Pull out ARF 2000 data (from ARF0203.ASC.GZ) 
infix StFIPS0 00122-00123 CtyFIPS0 00124-00126 mdsnonfed0 00512-00516 mdgenpra0 01448-01452 medspec0 01955-01959 cardiodi0 02238-02242 pulmonadi0 03188-03192 surgspec0 03302-03306 genrlsur0 03471-03475 orthopedicsur0 04041-04045 vascularmed0 06908-06912 hospital0 13382-13384 sthosp0 13424-13426 lthosp0 13508-13510 hospadm0 13708-13715 sthospadm0 13821-13829 hospbed0 14188-14194 sthospbed0 14286-14292 lthospbed0 14482-14488 hmopenetrate98 17022-17027 hmoindcompe98 17028-17030 inpatday0 17098-17104 inpatdaystlt0 17196-17202 medicareinday0 18083-18091 surgoper0 18286-18291 facmdinpdchrgst01 17410-17415 facmdinpdchrgst0 17416-17421 facmdinpdchrgst95 17422-17427 facmdinpdchrgst90 17428-17433 facmdinpdchrg01 17434-17439 facmdinpdchrg0 17440-17445 facmdinpdchrg95 17446-17451 facmdinpdchrg90 17452-17457 facmdinpdchrgst201 17458-17463 facmdinpdchrgst20 17464-17469 facmdinpdchrgst295 17470-17475 facmdinpdchrgst290 17476-17481 facmdinpdchrg201 17482-17487 facmdinpdchrg20 17488-17493 facmdinpdchrg295 17494-17499 facmdinpdchrg290 17500-17505 surgoutpa0 18394-18399 surg0 18430-18435 facexp0 18550-18558 payrolexp0 18655-18663 penetrmangdcare02 18814-18818 penetrmangdcare01 18819-18823 penetrmangdcare0 18824-18828 penetrmangdcare99 18829-18833 penetrmangdcare98 18834-18838 penetrmangdcare97 18839-18843 apayment02 18844-18849 apayment01 18850-18855 apayment0 18856-18861 apayment99 18862-18867 apayment98 18868-18873 apayment97 18874-18879 bpayment02 18880-18885 bpayment01 18886-18891 bpayment0 18892-18897 bpayment99 18898-18903 bpayment98 18904-18909 bpayment97 18910-18915 abpayment02 18916-18921 abpayment01 18922-18927 abpayment0 18928-18933 abpayment99 18934-18939 abpayment98 18940-18945 abpayment97 18946-18951 enrodisa01 19072-19081 enrodisa0 19082-19091 enrodisa99 19092-19101 censuspop0 19318-19325 pop99 19326-19333 pop98 19334-19341 male65740 20558-20563 fmle65740 20570-20575 male75840 20582-20587 fmle75840 20594-20599 male840 20606-20611 fmle840 20618-20623 maligneoplasm 26725-26729 cerebrovas 26775-26779 ischheart 26785-26789 chrorespi 26935-26939 death0 27221-27226 deathaverage 27263-27268 avgmortality65 28046-28050 avgmortality75 28096-28100 avgmortality85 28146-28150 medihdincome99 28490-28495 poverty65_99 29375-29381 perfamipoverty_99 29415-29418 elig02 18718-18725 elig01 18726-18733 beneficia0 18734-18741 beneficia99 18742-18749 beneficia98 18750-18757 beneficia97 18758-18765 enro02 18766-18773 enro01 18774-18781 enro0 18782-18789 enro99 18790-18797 enro98 18798-18805 enro97 18806-18813 male5_0 20294-20299 fmle5_0 20306-20311 male9_0 20318-20323 fmle9_0 20330-20335 male14_0 20342-20347 fmle14_0 20354-20359 male19_0 20366-20371 fmle19_0 20378-20383 male24_0 20390-20395 fmle24_0 20402-20407 male29_0 20414-20419 fmle29_0 20426-20431 male34_0 20438-20443 fmle34_0 20450-20455 male44_0 20462-20467 fmle44_0 20474-20479 male54_0 20486-20491 fmle54_0 20498-20503 male59_0 20510-20515 fmle59_0 20522-20527 male64_0 20534-20539 fmle64_0 20546-20551 hospout01 14967-14969 pop65_99 23274-23279 hospcardi01 14916-14918 suroper0 18358-18363 hmoenro98 16905-16913 using "c:/Documents and Settings/qma/My Documents/Medicare HMOs/Data/ARF0203.ASC" 

* get the accurate penetration rate in decimal from 02-97
gen p02=enro02/elig02
gen p01=enro01/elig01
gen p0=enro0/beneficia0
gen p99=enro99/beneficia99
gen p98=enro98/beneficia98
gen p97=enro97/beneficia97

****************************
* to solve the decimal problem
****************************
gen hmoprate98=hmopenetrate98/100000
gen hmoindex98=hmoindcompe98/100
gen penetr02=penetrmangdcare02/100
gen penetr01=penetrmangdcare01/100
gen penetr0=penetrmangdcare0/100
gen penetr99=penetrmangdcare99/100
gen penetr98=penetrmangdcare98/100
gen penetr97=penetrmangdcare97/100
gen apay02=apayment02/100
gen apay01=apayment01/100
gen apay0=apayment0/100
gen apay99=apayment99/100
gen apay98=apayment98/100 
gen apay97=apayment97/100
gen bpay02=bpayment02/100
gen bpay01=bpayment01/100
gen bpay0=bpayment0/100
gen bpay99=bpayment99/100
gen bpay98=bpayment98/100
gen bpay97=bpayment97/100
gen abpay02=abpayment02/100
gen abpay01=abpayment01/100
gen abpay0=abpayment0/100
gen abpay99=abpayment99/100
gen abpay98=abpayment98/100
gen abpay97=abpayment97/100
gen perfpoverty_99=perfamipoverty_99/10
drop perfamipoverty_99 hmopenetrate98 
drop hmoindcompe98 penetrmangdcare02 penetrmangdcare01 penetrmangdcare0 penetrmangdcare99 penetrmangdcare98 penetrmangdcare97
drop apayment02 apayment01 apayment0 apayment99 apayment98 apayment97 
drop bpayment02 bpayment01 bpayment0 bpayment99 bpayment98 bpayment97
drop abpayment02 abpayment01 abpayment0 abpayment99 abpayment98 abpayment97 
drop surgoutpa0

*****************************
*label variables
*****************************
lab var StFIPS0 "FIPS State Code 2000"
lab var CtyFIPS0 "FIPS County Code 2000" 
lab var mdsnonfed0 "Total Active M.D.s Non-Federal in 2000"
lab var mdgenpra0 "MD's Total Gen Pract, Total in 2000"
lab var medspec0 "Med Spec Tot, Total in 2000"
lab var cardiodi0 "Cardiovas Dis, Total 2000"
lab var pulmonadi0 "Pulmonary Dis, Total 2000"
lab var surgspec0 "Surg Specs Tot, Total 2000"
lab var genrlsur0 "Genrl Surg, Total 2000"
lab var orthopedicsur0 "Orthopedic Surg, Total 2000"
lab var vascularmed0 "Vascular Med, Total 2000"
lab var hospital0 "Total Number Hospitals 2000"
lab var sthosp0 "# Short Term General Hosps 2000"
lab var lthosp0 "# Long Term Hospitals 2000"
lab var hospadm0 "Hospital Admissions 2000"
lab var sthospadm0 "Short Term Gen Hosp Admissions 2000" 
lab var hospbed0 "Hospital Beds 2000"
lab var sthospbed0 "Short Term General Hosp Beds 2000"
lab var lthospbed0 "Long Term Hosp Beds 2000"
lab var hmoprate98 "HMO Penetration Rate in County, 1998"
lab var hmoindex98 "HMO Index of Competition, 1998"
lab var inpatday0 "Inpatient Days in ST Gen Hosp 2000" 
lab var inpatdaystlt0 "Inptn Days in STNG/LT Hosp 2000"
lab var medicareinday0 "Total Medicare Inpatient Days 2000" 
lab var surgoper0 "# Surgical Operations, Inpatnt 2000"
lab var facmdinpdchrgst01 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 2001"
lab var facmdinpdchrgst0 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 2000"
lab var facmdinpdchrgst95 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 1995"
lab var facmdinpdchrgst90 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 1990"
lab var facmdinpdchrg01 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 2001"
lab var facmdinpdchrg0 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 2000"
lab var facmdinpdchrg95 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 1995"
lab var facmdinpdchrg90 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 1990"
lab var facmdinpdchrgst201 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 2001"
lab var facmdinpdchrgst20 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 2000"
lab var facmdinpdchrgst295 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 1995"
lab var facmdinpdchrgst290 "# Tot Fac Medicare Inpat Dchrg: Short Term General Hospitals 1990"
lab var facmdinpdchrg201 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 2001"
lab var facmdinpdchrg20 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 2000"
lab var facmdinpdchrg295 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 1995"
lab var facmdinpdchrg290 "# Tot Fac Medicare Inpat Dchrg: ST Non-Gen + Long Term Hospitals 1990"
lab var suroper0 "# Surgical Operations, Outpatient: Short Term General Hospitals in 2000"
lab var surg0 "# Surgical Operations, Total: Short Term General Hospital 2000"
lab var facexp0 "Total Rep Facility Exp(1000's) In Thousands, ST Gen Hosps"
lab var payrolexp0 "Tot Rep Payroll Expense(1000's) in Thousands, ST Gen Hosps"
lab var penetr02 "% Medcre Mangd Care Penetratioin (.01) Enrollees/Eligibles 2002"
lab var penetr01 "% Medcre Mangd Care Penetratioin (.01) Enrollees/Eligibles 2001"
lab var penetr0 "% Medcre Mangd Care Penetratioin (.01) Enrollees/Eligibles 2000"
lab var penetr99 "% Medcre Mangd Care Penetratioin (.01) Enrollees/Eligibles 1999"
lab var penetr98 "% Medcre Mangd Care Penetratioin (.01) Enrollees/Eligibles 1998"
lab var penetr97 "% Medcre Mangd Care Penetratioin (.01) Enrollees/Eligibles 1997"
lab var apay02 "Medicare Pt A Aged Payment Rate 2002"
lab var apay01 "Medicare Pt A Aged Payment Rate 2001"
lab var apay0 "Medicare Pt A Aged Payment Rate 2000"
lab var apay99 "Medicare Pt A Aged Payment Rate 1999"
lab var apay98 "Medicare Pt A Aged Payment Rate 1998"
lab var apay97 "Medicare Pt A Aged Payment Rate 1997"
lab var bpay02 "Medicare Pt B Aged Payment Rate 2002"
lab var bpay01 "Medicare Pt B Aged Payment Rate 2001"
lab var bpay0 "Medicare Pt B Aged Payment Rate 2000"
lab var bpay99 "Medicare Pt B Aged Payment Rate 1999"
lab var bpay98 "Medicare Pt B Aged Payment Rate 1998"
lab var bpay97 "Medicare Pt B Aged Payment Rate 1997"
lab var abpay02 "Medicare Pt A&B Aged Payment Rate 2002"
lab var abpay01 "Medicare Pt A&B Aged Payment Rate 2001"
lab var abpay0 "Medicare Pt A&B Aged Payment Rate 2000"
lab var abpay99 "Medicare Pt A&B Aged Payment Rate 1999"
lab var abpay98 "Medicare Pt A&B Aged Payment Rate 1998"
lab var abpay97 "Medicare Pt A&B Aged Payment Rate 1997"
lab var enrodisa01 "Medicare Enrollment, Disabled Tot 2001"
lab var enrodisa0 "Medicare Enrollment, Disabled Tot 2000"
lab var enrodisa99 "Medicare Enrollment, Disabled Tot 1999"
lab var censuspop0 "Census Population, 2000"
lab var pop99 "Population Estimate, 1999"
lab var pop98 "Population Estimate, 1998"
lab var male65740 "Pop Male 65-74 in 2000, whole numbers"
lab var fmle65740 "Pop Fmle 65-74 in 2000, whole numbers"
lab var male75840 "Pop Male 75-84 in 2000, whole numbers"
lab var fmle75840 "Pop Fmle 75-84 in 2000, whole numbers"
lab var male840 "Pop Male > 84"
lab var fmle840 "Pop Fmle > 84"
lab var maligneoplasm "3-year Malignant Neoplasms, # of Deaths By Cause, 1998-2000"
lab var cerebrovas "3-year Cerebrovascular Disease, # of Deaths By Cause, 1998-2000"
lab var ischheart "3-year Ischemic Heart Disease, 1998-2000"
lab var chrorespi "3-year Chronic Lower Resp Dis, # of Deaths By Cause, 1998-2000"
lab var death0 "Total Deaths 2000, July 1, 2000-July 1, 2001"
lab var deathaverage "3-year Total Deaths, 1998-2000. 3 Yr Avg" 
lab var avgmortality65 "1998-2000, 3-year Mortality Age Cat. 9: 65-74 Years; 3 Yr Avg"
lab var avgmortality75 "1998-2000, 3-year Mortality Age Cat.10: 75-84 Years; 3 Yr Avg"
lab var avgmortality85 "1998-2000, 3-year Mortality Age Cat.11: 85 And Over; 3 Yr Avg"
lab var medihdincome99 "Median Household Income estimates, 1999"
lab var poverty65_99 "# Pers 65+ Below Poverty Level,1999"
lab var perfpoverty_99 "% Families Below Poverty Level (0.1)"
lab var elig02 "# of Eligible for Medcre Mengd Cre 2002"
lab var elig01 "# of Eligible for Medcre Mengd Cre 2001"
lab var beneficia0 "Number Medicare Beneficiaries 2000"
lab var beneficia99 "Number Medicare Beneficiaries 1999"
lab var beneficia98 "Number Medicare Beneficiaries 1998"
lab var beneficia97 "Number Medicare Beneficiaries 1997"
lab var enro02 "# Medicare Mangd Care Enrollees 2002"
lab var enro01 "# Medicare Mangd Care Enrollees 2001"
lab var enro0 "# Medicare Mangd Care Enrollees 2000"
lab var enro99 "# Medicare Mangd Care Enrollees 1999"
lab var enro98 "# Medicare Mangd Care Enrollees 1998"
lab var enro97 "# Medicare Mangd Care Enrollees 1997"
lab var p02 "penetration rate 2002 calculated from enrollee and eligibles"
lab var p01 "penetration rate 2001 calculated from enrollee and eligibles"
lab var p0 "penetration rate 2000 calculated from enrollee and eligibles"
lab var p99 "penetration rate 1999 calculated from enrollee and eligibles"
lab var p98 "penetration rate 1998 calculated from enrollee and eligibles"
lab var p97 "penetration rate 1997 calculated from enrollee and eligibles"
lab var male5_0 "Pop Male < 5 in 2000"
lab var male9_0 "Pop Male 5-9 in 2000"
lab var male14_0 "Pop Male 10-14 in 2000"
lab var male19_0 "Pop Male 15-19 in 2000"
lab var male24_0 "Pop Male 20-24 in 2000 "
lab var male29_0 "Pop Male 25-29 in 2000"
lab var male34_0 "Pop Male 30-34 in 2000"
lab var male44_0 "Pop Male 35-44 in 2000"
lab var male54_0 "Pop Male 45-54 in 2000"
lab var male59_0 "Pop Male 55-59 in 2000"
lab var male64_0 "Pop Male 60-64 in 2000"
lab var fmle5_0 "Pop Fmle < 5 in 2000"
lab var fmle9_0 "Pop Fmle 5-9 in 2000"
lab var fmle14_0 "Pop Fmle 10-14 in 2000"
lab var fmle19_0 "Pop Fmle 15-19 in 2000"
lab var fmle24_0 "Pop Fmle 20-24 in 2000 "
lab var fmle29_0 "Pop Fmle 25-29 in 2000"
lab var fmle34_0 "Pop Fmle 30-34 in 2000"
lab var fmle44_0 "Pop Fmle 35-44 in 2000"
lab var fmle54_0 "Pop Fmle 45-54 in 2000"
lab var fmle59_0 "Pop Fmle 55-59 in 2000"
lab var fmle64_0 "Pop Fmle 60-64 in 2000"
lab var hospout01 "# Hosp W/ Freestanding Outpat Ctr" 
lab var pop65_99 "# Population Estimate 65+"
lab var hospcardi01 "# Surgical Operations, Outpatient"
lab var hmoenro98 "HMO Enrollment in the County in 1998"
*****************
* generate five digit string variable: the state county FIPS code "StCty0"
*****************
tostring StFIPS0, generate(stfips0) format (%02.0f) force
tostring CtyFIPS0, generate(ctyfips0) format (%03.0f) force 
gen StCty0=stfips0+ctyfips0
drop StFIPS0 CtyFIPS0
label var StCty0 "state county FIPS code for 2000"
label var stfips0 "state FIPS code for 2000"
label var ctyfips "state FIPS code for 2000"

*******************
* construct mortality and poverty rates as follows
*******************
gen drate65up=(avgmortality65+avgmortality75+avgmortality85)/(male65740+fmle65740+male75840+fmle75840+male840+fmle840)
gen drate84up=avgmortality85/(male840+fmle840)
gen dratecancer=maligneoplasm/(pop65_99) 
gen dratestroke=cerebrovas/(pop65_99)
gen drateheart=ischheart/(pop65_99)
gen drateresp=chrorespi/(pop65_99)
gen povrate65up=poverty65_99/(pop65_99)
rename perfpoverty_99 povrate
lab var drate65up "constructed mortality rate for 65+ in 2000"
lab var drate84up "constructed mortality rate for 85+ in 2000"
lab var dratecancer "constructed mortality rate for Malignant Neoplasm, 2000"
lab var dratestroke "constructed mortality rate for Cerebrovascular Disease, 2000"
lab var drateheart "constructed mortality rate for Ischemic Heart Disease, 2000"
lab var drateresp "constructed mortality rate for Chronic Lower Resp Dis, 2000"
lab var povrate65up "% of 65+ below poverty level, 1999"

save ARF0203.dta,replace

*******************
* create subset of ARF data, used to merge onto HRS
*******************
keep stfips0 ctyfips0 StCty0 mdsnonfed0 medspec0 sthosp0 sthospbed0 medicareinday0 surg0 payrolexp0 facexp0 censuspop0 male65740 fmle65740 male75840 fmle75840 male840 fmle840 maligneoplasm cerebrovas ischheart chrorespi death0 deathaverage avgmortality65 avgmortality75 avgmortality85 medihdincome99 hospout01 pop65_99 hospcardi01 suroper0 drate65up drate84up dratecancer dratestroke drateheart drateresp povrate65up povrate hmoenro98
order StCty0 hmoenro98
save ARF0203subset.dta, replace

log close
