/**********************************************************************************/
/* Program creating a dataset at the municipality level				    */
/* Here, individual variables averaged at the municipality level are not centered */
/* It contains the fixed effects and explanatory variables for the third-stage    */
/* regressions. When it has run, the output dataset town_alpha.dta should be      */
/* exported to GAUSS                                                              */
/**********************************************************************************/



#delimit;

clear;

set matsize 500;
set mem 500m;

local path  "C:\dossiers\SpatialM\GMS_ANPE\publication_JAE_doc\";



/*******************************************************************************/
/* Creation of the dataset with local variables summarizing the information    */
/* of the dataset at the individual level							 */
/*******************************************************************************/

u "`path'panel_noncentered", clear;

gen mat1=1-mat2;
gen edu1=1-edu2-edu3-edu4;
gen nat1=1-nat2-nat3-nat4-nat5;
gen sex1=1-sex2;
gen enf0=1-enf1-enf2-enf3-enf4-enf5;

gen te=t*e; replace te=. if e==0;
gen ta=t*a; replace ta=. if a==0;
gen tc=t*c; replace tc=. if c==0;

gen nbcho=1;

sort depcom;

merge depcom using "`path'datacom.dta", keep(depcom pop90);
keep if _merge==1|_merge==3;

collapse (sum) nbcho (mean) te ta tc e a c age sex1 sex2 mat1 mat2 enf0 enf1 enf2 enf3 enf4 enf5 nat1 nat2 nat3 nat4 nat5 edu1 edu2 edu3 edu4 handi, by(depcom pop90);

rename depcom dc;
sort dc;
saveold "`path'town_alpha_noncentered.dta", replace;



/*********************************************************/
/* Adding local variables coming from the duration model */ 
/*********************************************************/

/* Adding averages by municipality */

use dc nbe nba ske6 sme6 smulte6 ska6 sma6 smulta6 ske24 sme24 smulte24 ska24 sma24 smulta24 using "`path'alpha", clear;
sort dc;
merge dc using "`path'town_alpha_noncentered.dta";
drop _merge;

/* Correctif pour les valeurs manquantes */

replace nbe=. if nbe==100000; replace nba=. if nba==100000;
replace ske6=. if ske6==100000; replace ske24=. if ske24==100000; 
replace ska6=. if ska6==100000; replace ska24=. if ska24==100000; 
replace sme6=. if sme6==100000; replace sme24=. if sme24==100000; 
replace sma6=. if sma6==100000; replace sma24=. if sma24==100000; 
replace smulte6=. if smulte6==100000; replace smulte24=. if smulte24==100000; 
replace smulta6=. if smulta6==100000; replace smulta24=. if smulta24==100000; 

rename dc depcom; 
sort depcom;

/* Adding census variables and accessibility variables at the municipality level */

merge depcom using "`path'datacom.dta";
drop _merge;

rename depcom dc;

/* Creating some variables and renaming some variables */

replace smulte6=1   if nbe==0 & nbcho>0; 
replace smulte24=1  if nbe==0 & nbcho>0; 

replace smulta6=1   if nba==0 & nbcho>0; 
replace smulta24=1  if nba==0 & nbcho>0; 

sort dc;



/***********/
/* Labels  */
/***********/

label var dc "Town code";

label variable enf0	"0 child";
label variable sex1	"Male";
label variable mat1	"Single";
label variable nat1	"French";
label variable edu1	"Secondary school diploma";

label var nbcho "Number of unemployed workers";

label var sme6  "S. 6 months, model (job)";
label var sme24 "S. 2 years, model (job)";

label var sma6  "S. 6 months, model (other)";
label var sma24 "S. 2 years, model (other)";

label var smulte6  "S. 6 months, model, reconstructed (job)";
label var smulte24 "S. 2 years, model, reconstructed (job)";

label var smulta6  "S. 6 months, model, reconstructed (other)";
label var smulta24 "S. 2 years, model, reconstructed (other)";

label var ske6  "S. 6 months, Kaplan (job)";
label var ske24 "S. 2 years, Kaplan (job)";

label var ska6  "S. 6 months, Kaplan (other)";
label var ska24 "S. 2 years, Kaplan (other)";

label variable te	"Unemployment duration if exit to job";
label variable ta	"Unemployment duration if exit to non-employment";
label variable tc	"Unemployment duration if right-censorship";

saveold "`path'town_alpha_noncentered", replace; /* Table to be exported to GAUSS */

