% QBOUNDS UNDER QMTS - LEVELS 

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.5,0.75,0.90,0.95]';
Q=length(alpha);
mSE=zeros(T,1);
mGE=zeros(T,1);
mS=zeros(T,1);
pSE=zeros(T,1);
pGE=zeros(T,1);
pS=zeros(T,1);
alphaLB_QMTS=zeros(T,Q); 
alphaUB_QMTS=zeros(T,Q);
LB_QMTS=zeros(T,Q);
UB_QMTS=zeros(T,Q);

for i = 1:T
for j = 1:Q
    
mSE(i) = length(s(s<=J(i)));
mGE(i) = length(s(s>=J(i)));
mS(i) = length(s(s<J(i)));
pSE(i) = mSE(i)/N;
pGE(i) = mGE(i)/N;
pS(i) = mS(i)/N;
alphaLB_QMTS(i,j) = (1-((1-alpha(j))/pGE(i)));
alphaUB_QMTS(i,j) = (alpha(j)/pSE(i));

if ((alpha(j) < 1) & (alpha(j) > pS(i))) LB_QMTS(i,j) = prctile( dlnyora( s==J(i) ) , (alphaLB_QMTS(i,j)*100) ); 
else LB_QMTS(i,j) = yMIN;
end

if ((alpha(j) <= pSE(i)) & (alpha(j) > 0)) UB_QMTS(i,j) = prctile(dlnyora(s==J(i)), (alphaUB_QMTS(i,j)*100)); 
else UB_QMTS(i,j) = yMAX;       
end

end
end





