% QBOUNDS UNDER QMIV - LEVELS 

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
N0=length(v(v==0));
N1=length(v(v==1));
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.5,0.75,0.90,0.95]';
Q=length(alpha);
m=zeros(T,1);
md=zeros(T,1);
m0=zeros(T,1);
m1=zeros(T,1);
p0=zeros(T,1);
p0d=zeros(T,1);
p1=zeros(T,1);
alphaLB_QMIV_B=zeros(T,Q); 
alphaUB_QMIV_B=zeros(T,Q);
LB_QMIV_B=zeros(T,Q);
UB_QMIV_B=zeros(T,Q);
LB_QMIV_A=zeros(T,Q);
UB_QMIV_A=zeros(T,Q);
LB_QMIV=zeros(T,Q);
UB_QMIV=zeros(T,Q);

for i = 1:T

m(i)  = length(s(s==J(i)));   
m0(i) = length(s(s==J(i) & v==0));
p0(i) = m0(i)/N0;
p0d(i) = 1 - p0(i);
m1(i) = length(s(s==J(i) & v==1));
p1(i) = m1(i)/N1;    
    
for j = 1:Q
    
alphaLB_QMIV_B(i,j) = (1-((1-alpha(j))/p0(i)));
alphaUB_QMIV_B(i,j) = (alpha(j)/p1(i));

if ((alpha(j) < 1) & (alpha(j) > p0d(i))) LB_QMIV(i,j) = prctile( dlnyora( s==J(i) & v==0 ) , (alphaLB_QMIV_B(i,j)*100) ); 
else LB_QMIV_B(i,j) = yMIN;
end

if ((alpha(j) <= p1(i)) & (alpha(j) > 0)) UB_QMIV_B(i,j) = prctile(dlnyora(s==J(i) & v==1), (alphaUB_QMIV_B(i,j)*100)); 
else UB_QMIV_B(i,j) = yMAX;       
end

end
end

for i = 1:T
    
md(i) = N - m(i);

y0s = dlnyora(s==J(i) & v==0);
y1s = dlnyora(s==J(i) & v==1);

y_UB = [y0s(unidrnd(m0(i),m0(i),1))' y1s(unidrnd(m1(i),m1(i),1))' repmat(yMAX,1,md(i))]';

y_LB = [y0s(unidrnd(m0(i),m0(i),1))' y1s(unidrnd(m1(i),m1(i),1))' repmat(yMIN,1,md(i))]';

for j = 1:Q

UB_QMIV_A(i,j) = prctile(y_UB ,(alpha(j)*100)); 
LB_QMIV_A(i,j) = prctile(y_LB ,(alpha(j)*100)); 
    
end

end

LB_QMIV = max(LB_QMIV_A , LB_QMIV_B);
UB_QMIV = min(UB_QMIV_A , UB_QMIV_B);
