% QBOUNDS UNDER MTR - LEVELS 

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.5,0.75,0.90,0.95]';
Q=length(alpha);
mSE=zeros(T,1);
mGE=zeros(T,1);
mG=zeros(T,1);
pSE=zeros(T,1);
pGE=zeros(T,1);
pG=zeros(T,1);
alphaLB_MTR=zeros(T,Q); 
alphaUB_MTR=zeros(T,Q);
LB_MTR=zeros(T,Q);
UB_MTR=zeros(T,Q);

for i = 1:T
for j = 1:Q
    
mSE(i) = length(s(s<=J(i)));
mGE(i) = length(s(s>=J(i)));
mG(i) = length(s(s>J(i)));
pSE(i) = mSE(i)/N;
pGE(i) = mGE(i)/N;
pG(i) = mG(i)/N;
alphaLB_MTR(i,j) = (1-((1-alpha(j))/pSE(i)));
alphaUB_MTR(i,j) = (alpha(j)/pGE(i));

if ((alpha(j) < 1) & (alpha(j) > pG(i))) LB_MTR(i,j) = prctile( dlnyora( s<=J(i) ) , (alphaLB_MTR(i,j)*100) ); 
else LB_MTR(i,j) = yMIN;
end

if ((alpha(j) <= pGE(i)) & (alpha(j) > 0)) UB_MTR(i,j) = prctile(dlnyora(s>=J(i)), (alphaUB_MTR(i,j)*100)); 
else UB_MTR(i,j) = yMAX;       
end

end
end





