% QBOUNDS UNDER EE - LEVELS 

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.50,0.75,0.90,0.95]';
Q=length(alpha);
m=zeros(T,1);
p=zeros(T,1);
alphaLB_EE=zeros(T,Q); 
alphaUB_EE=zeros(T,Q);
LB_EE=zeros(T,Q);
UB_EE=zeros(T,Q);

for i = 1:T
for j = 1:Q
    
m(i) = length(s(s==J(i)));
p(i) = m(i)/N;
alphaLB_EE(i,j) = (1-((1-alpha(j))/p(i)));
alphaUB_EE(i,j) = (alpha(j)/p(i));

if ( p(i) > ( 1 - alpha(j) ) ) LB_EE(i,j) = prctile( dlnyora( s==J(i) ) , (alphaLB_EE(i,j)*100) ); 
else LB_EE(i,j) = yMIN;
end

if (p(i) >= alpha(j)) UB_EE(i,j) = prctile(dlnyora(s==J(i)), (alphaUB_EE(i,j)*100)); 
else UB_EE(i,j) = yMAX;       
end

end
end


