% PERCENTILE BOOTSTRAP CI FOR QMTS ESTIMATES - levels and QTEs

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.50,0.75,0.90,0.95]';
Q=length(alpha);
m=zeros(T,1);
mSE=zeros(T,1);
mGE=zeros(T,1);
mS=zeros(T,1);
pSE=zeros(T,1);
pGE=zeros(T,1);
pS=zeros(T,1);
alphaLB_QMTS=zeros(T,Q); 
alphaUB_QMTS=zeros(T,Q);
beta=0.05;
M=3000;
QTELBstar_QMTS=zeros(6,Q,M);
QTEUBstar_QMTS=zeros(6,Q,M);
LBstar_QMTS=zeros(T,Q,M);
UBstar_QMTS=zeros(T,Q,M);
LBlower_QMTS=zeros(T,Q); 
LBupper_QMTS=zeros(T,Q); 
UBlower_QMTS=zeros(T,Q);
UBupper_QMTS=zeros(T,Q);
QTELBlower_QMTS=zeros(6,Q);
QTEUBupper_QMTS=zeros(6,Q);
cutoff = floor((beta/2)*M);

for i = 1:T

m(i) = length(s(s==J(i)));
mSE(i) = length(s(s<=J(i)));
mGE(i) = length(s(s>=J(i)));
mS(i) = length(s(s<J(i)));
pSE(i) = mSE(i)/N;
pGE(i) = mGE(i)/N;
pS(i) = mS(i)/N;
y = dlnyora(s==J(i));

for j = 1:Q
    
alphaLB_QMTS(i,j) = (1-((1-alpha(j))/pGE(i)));
alphaUB_QMTS(i,j) = (alpha(j)/pSE(i));

for h = 1:M

if ((alpha(j) < 1) & (alpha(j) > pS(i))) LBstar_QMTS(i,j,h) = prctile( y( unidrnd(m(i),m(i),1) ) , (alphaLB_QMTS(i,j)*100)); 
else LBstar_QMTS(i,j,h) = yMIN;
end

if ((alpha(j) <= pSE(i)) & (alpha(j) > 0)) UBstar_QMTS(i,j,h) = prctile( y( unidrnd(m(i),m(i),1) ) , (alphaUB_QMTS(i,j)*100)); 
else UBstar_QMTS(i,j,h) = yMAX;       
end

end

end

end

for j = 1:Q
    
QTELBstar_QMTS(1,j,1:M)=sort(LBstar_QMTS(2,j,1:M)-UBstar_QMTS(1,j,1:M));
QTELBstar_QMTS(2,j,1:M)=sort(LBstar_QMTS(3,j,1:M)-UBstar_QMTS(2,j,1:M));
QTELBstar_QMTS(3,j,1:M)=sort(LBstar_QMTS(4,j,1:M)-UBstar_QMTS(3,j,1:M));
QTELBstar_QMTS(4,j,1:M)=sort(LBstar_QMTS(2,j,1:M)-UBstar_QMTS(1,j,1:M));
QTELBstar_QMTS(5,j,1:M)=sort(LBstar_QMTS(3,j,1:M)-UBstar_QMTS(1,j,1:M));
QTELBstar_QMTS(6,j,1:M)=sort(LBstar_QMTS(4,j,1:M)-UBstar_QMTS(1,j,1:M));

QTEUBstar_QMTS(1,j,1:M)=sort(UBstar_QMTS(2,j,1:M)-LBstar_QMTS(1,j,1:M));
QTEUBstar_QMTS(2,j,1:M)=sort(UBstar_QMTS(3,j,1:M)-LBstar_QMTS(2,j,1:M));
QTEUBstar_QMTS(3,j,1:M)=sort(UBstar_QMTS(4,j,1:M)-LBstar_QMTS(3,j,1:M));
QTEUBstar_QMTS(4,j,1:M)=sort(UBstar_QMTS(2,j,1:M)-LBstar_QMTS(1,j,1:M));
QTEUBstar_QMTS(5,j,1:M)=sort(UBstar_QMTS(3,j,1:M)-LBstar_QMTS(1,j,1:M));
QTEUBstar_QMTS(6,j,1:M)=sort(UBstar_QMTS(4,j,1:M)-LBstar_QMTS(1,j,1:M));

QTELBlower_QMTS(1,j)=QTELBstar_QMTS(1,j,cutoff);
QTELBlower_QMTS(2,j)=QTELBstar_QMTS(2,j,cutoff);
QTELBlower_QMTS(3,j)=QTELBstar_QMTS(3,j,cutoff);
QTELBlower_QMTS(4,j)=QTELBstar_QMTS(4,j,cutoff);
QTELBlower_QMTS(5,j)=QTELBstar_QMTS(5,j,cutoff);
QTELBlower_QMTS(6,j)=QTELBstar_QMTS(6,j,cutoff);

QTEUBupper_QMTS(1,j)=QTEUBstar_QMTS(1,j,M+1-cutoff);
QTEUBupper_QMTS(2,j)=QTEUBstar_QMTS(2,j,M+1-cutoff);
QTEUBupper_QMTS(3,j)=QTEUBstar_QMTS(3,j,M+1-cutoff);
QTEUBupper_QMTS(4,j)=QTEUBstar_QMTS(4,j,M+1-cutoff);
QTEUBupper_QMTS(5,j)=QTEUBstar_QMTS(5,j,M+1-cutoff);
QTEUBupper_QMTS(6,j)=QTEUBstar_QMTS(6,j,M+1-cutoff);

end

for i = 1:T
    
for j = 1:Q

LBstar_QMTS(i,j,1:M) = sort(LBstar_QMTS(i,j,1:M)); 
UBstar_QMTS(i,j,1:M) = sort(UBstar_QMTS(i,j,1:M));
LBlower_QMTS(i,j) = LBstar_QMTS(i,j,cutoff); 
%LBupper_QMTS(i,j) = LBstar_QMTS(i,j,M+1-cutoff); 
%UBlower_QMTS(i,j) = UBstar_QMTS(i,j,cutoff);
UBupper_QMTS(i,j) = UBstar_QMTS(i,j,M+1-cutoff);

end 

end
