% PERCENTILE BOOTSTRAP CI FOR QMIV ESTIMATES - levels

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
N0=length(v(v==0));
N1=length(v(v==1));
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.50,0.75,0.90,0.95]';
Q=length(alpha);
m=zeros(T,1);
md=zeros(T,1);
m0=zeros(T,1);
m1=zeros(T,1);
p0=zeros(T,1);
p0d=zeros(T,1);
p1=zeros(T,1);
alphaLB_QMIV_B=zeros(T,Q); 
alphaUB_QMIV_B=zeros(T,Q);
beta=0.05;
M=3000;
cutoff = floor((beta/2)*M);

LBlowerB_QMIV=zeros(T,Q); 
UBupperB_QMIV=zeros(T,Q);
LBlowerA_QMIV=zeros(T,Q); 
UBupperA_QMIV=zeros(T,Q);
LBlower_QMIV=zeros(T,Q); 
UBupper_QMIV=zeros(T,Q);

LBstarB_QMIV=zeros(T,Q,M);

for i = 1:T

m(i) = length(s(s==J(i)));
m0(i) = length(s(s==J(i) & v==0));
m1(i) = length(s(s==J(i) & v==1));
p0(i) = m0(i)/N0;
p0d(i) = 1 - p0(i);
p1(i) = m1(i)/N1;

end

for i = 1:T

y0B = dlnyora(s==J(i) & v==0);

for j = 1:Q
    
alphaLB_QMIV_B(i,j) = (1-((1-alpha(j))/p0(i)));

for h = 1:M

if ((alpha(j) < 1) & (alpha(j) > p0d(i))) LBstarB_QMIV(i,j,h) = prctile( y0B( unidrnd(m0(i),m0(i),1) ) , (alphaLB_QMIV_B(i,j)*100)); 
else LBstarB_QMIV(i,j,h) = yMIN;
end

end

end

end

for i = 1:T
    
for j = 1:Q

LBstarB_QMIV(i,j,1:M) = sort(LBstarB_QMIV(i,j,1:M)); 
LBlowerB_QMIV(i,j) = LBstarB_QMIV(i,j,cutoff); 

end 

end

clear y0B LBstarB_QMIV;



UBstarB_QMIV=zeros(T,Q,M);

for i = 1:T

y1B = dlnyora(s==J(i) & v==1);

for j = 1:Q
    
alphaUB_QMIV_B(i,j) = (alpha(j)/p1(i));

for h = 1:M

if ((alpha(j) <= p1(i)) & (alpha(j) > 0)) UBstarB_QMIV(i,j,h) = prctile( y1B( unidrnd(m1(i),m1(i),1) ) , (alphaUB_QMIV_B(i,j)*100)); 
else UBstarB_QMIV(i,j,h) = yMAX;       
end

end

end

end

for i = 1:T
    
for j = 1:Q
 
UBstarB_QMIV(i,j,1:M) = sort(UBstarB_QMIV(i,j,1:M)); 
UBupperB_QMIV(i,j) = UBstarB_QMIV(i,j,M+1-cutoff);

end 

end

clear y1B UBstarB_QMIV;



LBstarA_QMIV=zeros(T,Q,M);

for i = 1:T
    
md(i) = N - m(i);

y0A = dlnyora(s==J(i) & v==0);
y1A = dlnyora(s==J(i) & v==1);

y_LB = [y0A(unidrnd(m0(i),m0(i),M))' y1A(unidrnd(m1(i),m1(i),M))' repmat(yMIN,M,md(i))]';

for j = 1:Q

LBstarA_QMIV(i,j,1:M) = sort(prctile(y_LB , (alpha(j)*100))); 
LBlowerA_QMIV(i,j) = LBstarA_QMIV(i,j,cutoff);
    
end

end

clear y0A y1A y_LB LBstarA_QMIV;



UBstarA_QMIV=zeros(T,Q,M);

for i = 1:T
    
y0A = dlnyora(s==J(i) & v==0);
y1A = dlnyora(s==J(i) & v==1);

y_UB = [y0A(unidrnd(m0(i),m0(i),M))' y1A(unidrnd(m1(i),m1(i),M))' repmat(yMAX,M,md(i))]';

for j = 1:Q

UBstarA_QMIV(i,j,1:M) = sort(prctile(y_UB , (alpha(j)*100)));
UBupperA_QMIV(i,j) = UBstarA_QMIV(i,j,M+1-cutoff);
    
end

end

clear y0A y1A y_UB UBstarA_QMIV;



for i = 1:T
    
for j = 1:Q

LBlower_QMIV(i,j) = max(LBlowerA_QMIV(i,j) , LBlowerB_QMIV(i,j)); 
UBupper_QMIV(i,j) = min(UBupperA_QMIV(i,j) , UBupperB_QMIV(i,j));

end 

end
