% PERCENTILE BOOTSTRAP CI FOR QMTS ESTIMATES

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
m=zeros(T,1);
mSE=zeros(T,1);
mGE=zeros(T,1);
mS=zeros(T,1);
pSE=zeros(T,1);
pGE=zeros(T,1);
pS=zeros(T,1);
beta=0.05;
M=3000;
LBstar_MTS=zeros(T,M);
UBstar_MTS=zeros(T,M);
ATELBstar_MTS=zeros(6,M);
ATEUBstar_MTS=zeros(6,M);
LBlower_MTS=zeros(T,1); 
%LBupper_MTS=zeros(T,1); 
%UBlower_MTS=zeros(T,1);
UBupper_MTS=zeros(T,1);
ATELBlower_MTS=zeros(6,1);
ATEUBupper_MTS=zeros(6,1);
cutoff = floor((beta/2)*M);

for i = 1:T

m(i) = length(s(s==J(i)));
mSE(i) = length(s(s<=J(i)));
mGE(i) = length(s(s>=J(i)));
pSE(i) = mSE(i)/N;
pGE(i) = mGE(i)/N;
y = dlnyora(s==J(i));

for h = 1:M

LBstar_MTS(i,h) = mean( y( unidrnd(m(i),m(i),1) ))*pGE(i) + yMIN*(1-pGE(i)); 
UBstar_MTS(i,h) = mean( y( unidrnd(m(i),m(i),1) ))*pSE(i) + yMAX*(1-pSE(i)); 

end

end

ATELBstar_MTS(1,1:M)=sort(LBstar_MTS(2,1:M)-UBstar_MTS(1,1:M));
ATELBstar_MTS(2,1:M)=sort(LBstar_MTS(3,1:M)-UBstar_MTS(2,1:M));
ATELBstar_MTS(3,1:M)=sort(LBstar_MTS(4,1:M)-UBstar_MTS(3,1:M));
ATELBstar_MTS(4,1:M)=sort(LBstar_MTS(2,1:M)-UBstar_MTS(1,1:M));
ATELBstar_MTS(5,1:M)=sort(LBstar_MTS(3,1:M)-UBstar_MTS(1,1:M));
ATELBstar_MTS(6,1:M)=sort(LBstar_MTS(4,1:M)-UBstar_MTS(1,1:M));

ATEUBstar_MTS(1,1:M)=sort(UBstar_MTS(2,1:M)-LBstar_MTS(1,1:M));
ATEUBstar_MTS(2,1:M)=sort(UBstar_MTS(3,1:M)-LBstar_MTS(2,1:M));
ATEUBstar_MTS(3,1:M)=sort(UBstar_MTS(4,1:M)-LBstar_MTS(3,1:M));
ATEUBstar_MTS(4,1:M)=sort(UBstar_MTS(2,1:M)-LBstar_MTS(1,1:M));
ATEUBstar_MTS(5,1:M)=sort(UBstar_MTS(3,1:M)-LBstar_MTS(1,1:M));
ATEUBstar_MTS(6,1:M)=sort(UBstar_MTS(4,1:M)-LBstar_MTS(1,1:M));

for i=1:T

LBstar_MTS(i,1:M) = sort(LBstar_MTS(i,1:M)); 
UBstar_MTS(i,1:M) = sort(UBstar_MTS(i,1:M));
LBlower_MTS(i) = LBstar_MTS(i,cutoff); 
%LBupper_MTS(i) = LBstar_MTS(i,M+1-cutoff); 
%UBlower_MTS(i) = UBstar_MTS(i,cutoff);
UBupper_MTS(i) = UBstar_MTS(i,M+1-cutoff);

end

ATELBlower_MTS(1)=ATELBstar_MTS(1,cutoff);
ATELBlower_MTS(2)=ATELBstar_MTS(2,cutoff);
ATELBlower_MTS(3)=ATELBstar_MTS(3,cutoff);
ATELBlower_MTS(4)=ATELBstar_MTS(4,cutoff);
ATELBlower_MTS(5)=ATELBstar_MTS(5,cutoff);
ATELBlower_MTS(6)=ATELBstar_MTS(6,cutoff);

ATEUBupper_MTS(1)=ATEUBstar_MTS(1,M+1-cutoff);
ATEUBupper_MTS(2)=ATEUBstar_MTS(2,M+1-cutoff);
ATEUBupper_MTS(3)=ATEUBstar_MTS(3,M+1-cutoff);
ATEUBupper_MTS(4)=ATEUBstar_MTS(4,M+1-cutoff);
ATEUBupper_MTS(5)=ATEUBstar_MTS(5,M+1-cutoff);
ATEUBupper_MTS(6)=ATEUBstar_MTS(6,M+1-cutoff);




