% PERCENTILE BOOTSTRAP CI FOR MTR ESTIMATES

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
mSE=zeros(T,1);
mGE=zeros(T,1);
pSE=zeros(T,1);
pGE=zeros(T,1);
beta=0.05;
M=3000;
LBstar_MTR=zeros(T,M);
UBstar_MTR=zeros(T,M);
ATELBstar_MTR=zeros(6,M);
ATEUBstar_MTR=zeros(6,M);
LBlower_MTR=zeros(T,1); 
%LBupper_MTR=zeros(T,1); 
%UBlower_MTR=zeros(T,1);
UBupper_MTR=zeros(T,1);
ATELBlower_MTR=zeros(6,1);
ATEUBupper_MTR=zeros(6,1);
cutoff = floor((beta/2)*M);

for i = 1:T

mSE(i) = length(s(s<=J(i)));
mGE(i) = length(s(s>=J(i)));
pSE(i) = mSE(i)/N;
pGE(i) = mGE(i)/N;
yGE = dlnyora(s>=J(i));
ySE = dlnyora(s<=J(i));

for h = 1:M

LBstar_MTR(i,h) = mean( ySE( unidrnd(mSE(i),mSE(i),1) ))*pSE(i) + yMIN*(1-pSE(i)); 
UBstar_MTR(i,h) = mean( yGE( unidrnd(mGE(i),mGE(i),1) ))*pGE(i) + yMAX*(1-pGE(i)); 

end

end

ATELBstar_MTR(1,1:M)=sort(LBstar_MTR(2,1:M)-UBstar_MTR(1,1:M));
ATELBstar_MTR(2,1:M)=sort(LBstar_MTR(3,1:M)-UBstar_MTR(2,1:M));
ATELBstar_MTR(3,1:M)=sort(LBstar_MTR(4,1:M)-UBstar_MTR(3,1:M));
ATELBstar_MTR(4,1:M)=sort(LBstar_MTR(2,1:M)-UBstar_MTR(1,1:M));
ATELBstar_MTR(5,1:M)=sort(LBstar_MTR(3,1:M)-UBstar_MTR(1,1:M));
ATELBstar_MTR(6,1:M)=sort(LBstar_MTR(4,1:M)-UBstar_MTR(1,1:M));

ATEUBstar_MTR(1,1:M)=sort(UBstar_MTR(2,1:M)-LBstar_MTR(1,1:M));
ATEUBstar_MTR(2,1:M)=sort(UBstar_MTR(3,1:M)-LBstar_MTR(2,1:M));
ATEUBstar_MTR(3,1:M)=sort(UBstar_MTR(4,1:M)-LBstar_MTR(3,1:M));
ATEUBstar_MTR(4,1:M)=sort(UBstar_MTR(2,1:M)-LBstar_MTR(1,1:M));
ATEUBstar_MTR(5,1:M)=sort(UBstar_MTR(3,1:M)-LBstar_MTR(1,1:M));
ATEUBstar_MTR(6,1:M)=sort(UBstar_MTR(4,1:M)-LBstar_MTR(1,1:M));

for i=1:T
    
LBstar_MTR(i,1:M) = sort(LBstar_MTR(i,1:M)); 
UBstar_MTR(i,1:M) = sort(UBstar_MTR(i,1:M));
LBlower_MTR(i) = LBstar_MTR(i,cutoff); 
%LBupper_MTR(i) = LBstar_MTR(i,M+1-cutoff); 
%UBlower_MTR(i) = UBstar_MTR(i,cutoff);
UBupper_MTR(i) = UBstar_MTR(i,M+1-cutoff);

end 

ATELBlower_MTR(1)=ATELBstar_MTR(1,cutoff);
ATELBlower_MTR(2)=ATELBstar_MTR(2,cutoff);
ATELBlower_MTR(3)=ATELBstar_MTR(3,cutoff);
ATELBlower_MTR(4)=ATELBstar_MTR(4,cutoff);
ATELBlower_MTR(5)=ATELBstar_MTR(5,cutoff);
ATELBlower_MTR(6)=ATELBstar_MTR(6,cutoff);

ATEUBupper_MTR(1)=ATEUBstar_MTR(1,M+1-cutoff);
ATEUBupper_MTR(2)=ATEUBstar_MTR(2,M+1-cutoff);
ATEUBupper_MTR(3)=ATEUBstar_MTR(3,M+1-cutoff);
ATEUBupper_MTR(4)=ATEUBstar_MTR(4,M+1-cutoff);
ATEUBupper_MTR(5)=ATEUBstar_MTR(5,M+1-cutoff);
ATEUBupper_MTR(6)=ATEUBstar_MTR(6,M+1-cutoff);


