% PERCENTILE BOOTSTRAP CI FOR MTR&QMTS ESTIMATES

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
M=3000;
m=zeros(T,1);
mSE=zeros(T,1);
mGE=zeros(T,1);
mm=zeros(T,M);
p=zeros(T,1);
pSE=zeros(T,1);
pGE=zeros(T,1);
beta=0.05;
LBstar_MTRS=zeros(T,M);
UBstar_MTRS=zeros(T,M);
ATELBstar_MTRS=zeros(6,M);
ATEUBstar_MTRS=zeros(6,M);
LBlower_MTRS=zeros(T,1); 
%LBupper_MTRS=zeros(T,1); 
%UBlower_MTRS=zeros(T,1);
UBupper_MTRS=zeros(T,1);
ATELBlower_MTRS=zeros(6,1);
ATEUBupper_MTRS=zeros(6,1);
cutoff = floor((beta/2)*M);

for i = 1:T

m(i) = length(s(s==J(i)));
mSE(i) = length(s(s<=J(i)));
mGE(i) = length(s(s>=J(i)));
p(i) = m(i)/N;
pSE(i) = mSE(i)/N;
pGE(i) = mGE(i)/N;

end

yLB1 = dlnyora(s==J(1));
LBstar_MTRS(1,1:M) = mean(yLB1(unidrnd(m(1),m(1),M)))*pGE(1);
clear yLB1; 

for i = 2:T
    
y = dlnyora(s==J(i));    
mm(i,1:M) = mean(y(unidrnd(m(i),m(i),M)))*p(i);

end

for i = 2:T

yLB = dlnyora(s==J(i));

for h = 1:M

LBstar_MTRS(i,h) = mean(yLB(unidrnd(m(i),m(i),1)))*pGE(i) + sum(mm(1:i-1,h));
 
end

end 

for i = 1:(T-1)

yUB = dlnyora(s==J(i));

for h = 1:M

UBstar_MTRS(i,h) = mean(yUB(unidrnd(m(i),m(i),1)))*pSE(i) + sum(mm(i+1:T,h)); 

end

end

clear yUB;

yUBT = dlnyora(s==J(T));
UBstar_MTRS(T,1:M) = mean(yUBT(unidrnd(m(T),m(T),M)))*pSE(T);

ATELBstar_MTRS(1,1:M)=sort(LBstar_MTRS(2,1:M)-UBstar_MTRS(1,1:M));
ATELBstar_MTRS(2,1:M)=sort(LBstar_MTRS(3,1:M)-UBstar_MTRS(2,1:M));
ATELBstar_MTRS(3,1:M)=sort(LBstar_MTRS(4,1:M)-UBstar_MTRS(3,1:M));
ATELBstar_MTRS(4,1:M)=sort(LBstar_MTRS(2,1:M)-UBstar_MTRS(1,1:M));
ATELBstar_MTRS(5,1:M)=sort(LBstar_MTRS(3,1:M)-UBstar_MTRS(1,1:M));
ATELBstar_MTRS(6,1:M)=sort(LBstar_MTRS(4,1:M)-UBstar_MTRS(1,1:M));

ATEUBstar_MTRS(1,1:M)=sort(UBstar_MTRS(2,1:M)-LBstar_MTRS(1,1:M));
ATEUBstar_MTRS(2,1:M)=sort(UBstar_MTRS(3,1:M)-LBstar_MTRS(2,1:M));
ATEUBstar_MTRS(3,1:M)=sort(UBstar_MTRS(4,1:M)-LBstar_MTRS(3,1:M));
ATEUBstar_MTRS(4,1:M)=sort(UBstar_MTRS(2,1:M)-LBstar_MTRS(1,1:M));
ATEUBstar_MTRS(5,1:M)=sort(UBstar_MTRS(3,1:M)-LBstar_MTRS(1,1:M));
ATEUBstar_MTRS(6,1:M)=sort(UBstar_MTRS(4,1:M)-LBstar_MTRS(1,1:M));

for i = 1:T
    
LBstar_MTRS(i,1:M) = sort(LBstar_MTRS(i,1:M)); 
LBlower_MTRS(i) = LBstar_MTRS(i,cutoff); 
%LBupper_MTRS(i) = LBstar_MTRS(i,M+1-cutoff); 
UBstar_MTRS(i,1:M) = sort(UBstar_MTRS(i,1:M));
%UBlower_MTRS(i) = UBstar_MTRS(i,cutoff);
UBupper_MTRS(i) = UBstar_MTRS(i,M+1-cutoff);

end

ATELBlower_MTRS(1)=ATELBstar_MTRS(1,cutoff);
ATELBlower_MTRS(2)=ATELBstar_MTRS(2,cutoff);
ATELBlower_MTRS(3)=ATELBstar_MTRS(3,cutoff);
ATELBlower_MTRS(4)=ATELBstar_MTRS(4,cutoff);
ATELBlower_MTRS(5)=ATELBstar_MTRS(5,cutoff);
ATELBlower_MTRS(6)=ATELBstar_MTRS(6,cutoff);

ATEUBupper_MTRS(1)=ATEUBstar_MTRS(1,M+1-cutoff);
ATEUBupper_MTRS(2)=ATEUBstar_MTRS(2,M+1-cutoff);
ATEUBupper_MTRS(3)=ATEUBstar_MTRS(3,M+1-cutoff);
ATEUBupper_MTRS(4)=ATEUBstar_MTRS(4,M+1-cutoff);
ATEUBupper_MTRS(5)=ATEUBstar_MTRS(5,M+1-cutoff);
ATEUBupper_MTRS(6)=ATEUBstar_MTRS(6,M+1-cutoff);

