% BOOTSTRAP for MTR&QMTS and MTR&QMTS&QMIV - LEVELS

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
N0=length(v(v==0));
N1=length(v(v==1));
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.5,0.75,0.90,0.95]';
Q=length(alpha);
m0=zeros(T,1);
m1=zeros(T,1);
mSE0=zeros(T,1);
mSE0_C=zeros(T,1);
mSE1=zeros(T,1);
mGE0=zeros(T,1);
mGE1=zeros(T,1);
mGE1_C=zeros(T,1);
mS0=zeros(T,1);
mS1=zeros(T,1);
mS1_C=zeros(T,1);
mG0=zeros(T,1);
mG0_C=zeros(T,1);
mG1=zeros(T,1);
beta=0.05;
M=3000;
cutoff=floor((beta/2)*M);

for i = 1:T
    
m0(i) = length(s(s==J(i) & v==0));
m1(i) = length(s(s==J(i) & v==1));
mSE0(i) = length(s(s<=J(i) & v==0));
mSE1(i) = length(s(s<=J(i) & v==1));
mGE0(i) = length(s(s>=J(i) & v==0));
mGE1(i) = length(s(s>=J(i) & v==1));
mS0(i) = length(s(s<J(i) & v==0));
mS1(i) = length(s(s<J(i) & v==1));
mG0(i) = length(s(s>J(i) & v==0));
mG1(i) = length(s(s>J(i) & v==1));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

LBstar_MTRQMTS=zeros(T,M);
LBlower_MTRQMTS=zeros(T,Q);

ySE0_T = dlnyora(s<=J(T) & v==0);
ySE1_T = dlnyora(s<=J(T) & v==1);
y_LBA_T = [ySE0_T(unidrnd(mSE0(T),mSE0(T),M))' ySE1_T(unidrnd(mSE1(T),mSE1(T),M))']';

for j = 1:Q

LBstar_MTRQMTS(T,:) = sort(prctile(y_LBA_T ,(alpha(j)*100)));
LBlower_MTRQMTS(T,j) = LBstar_MTRQMTS(T,cutoff);

end

clear ySE0_T ySE1_T y_LBA_T;

for i = 2:T
    
ySE0 = dlnyora(s<=J(i-1) & v==0);
ySE1 = dlnyora(s<=J(i-1) & v==1);
yE0 = dlnyora(s==J(i-1) & v==0);
yE1 = dlnyora(s==J(i-1) & v==1);
y_LBA = [ySE0(unidrnd(mSE0(i-1),mSE0(i-1),M))' yE0(unidrnd(m0(i-1),mG0(i-1),M))' ySE1(unidrnd(mSE1(i-1),mSE1(i-1),M))' yE1(unidrnd(m1(i-1),mG1(i-1),M))']';

for j = 1:Q

LBstar_MTRQMTS(i-1,:) = sort(prctile(y_LBA ,(alpha(j)*100))); 
LBlower_MTRQMTS(i-1,j) = LBstar_MTRQMTS(i-1,cutoff);

end

end

clear ySE0 ySE1 yE0 yE1 y_LBA LBstar_MTRQMTS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

UBstar_MTRQMTS=zeros(T,M);
UBupper_MTRQMTS=zeros(T,Q);

yGE0_1 = dlnyora(s>=J(1) & v==0);
yGE1_1 = dlnyora(s>=J(1) & v==1);
y_UBA_1 = [yGE0_1(unidrnd(mGE0(1),mGE0(1),M))' yGE1_1(unidrnd(mGE1(1),mGE1(1),M))']';

for j = 1:Q

UBstar_MTRQMTS(1,:) = sort(prctile(y_UBA_1 ,(alpha(j)*100)));
UBupper_MTRQMTS(1,j) = UBstar_MTRQMTS(1,M+1-cutoff);

end

clear yGE0_1 yGE1_1 y_UBA_1;

for i = 2:T
    
yGE0 = dlnyora(s>=J(i) & v==0);
yGE1 = dlnyora(s>=J(i) & v==1);
yE0 = dlnyora(s==J(i) & v==0);
yE1 = dlnyora(s==J(i) & v==1);
y_UBA = [yGE0(unidrnd(mGE0(i),mGE0(i),M))' yE0(unidrnd(m0(i),mS0(i),M))' yGE1(unidrnd(mGE1(i),mGE1(i),M))' yE1(unidrnd(m1(i),mS1(i),M))']';

for j = 1:Q

UBstar_MTRQMTS(i,:) = sort(prctile(y_UBA ,(alpha(j)*100))); 
UBupper_MTRQMTS(i,j) = UBstar_MTRQMTS(i,M+1-cutoff);

end

end

clear yGE0 yGE1 yE0 yE1 y_UBA UBstar_MTRQMTS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i = 1:T
    
mSE0_C(i) = round(mSE0(i)*(N/N0));
mGE1_C(i) = round(mGE1(i)*(N/N1));
mS1_C(i) = N - mGE1_C(i);
mG0_C(i) = N - mSE0_C(i);

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

LBstar_MTRQSIV_B=zeros(T,M);
LBlower_MTRQSIV_B=zeros(T,Q);

ySE0_T = dlnyora(s<=J(T) & v==0);
y_LBA_T = ySE0_T(unidrnd(mSE0(T),mSE0_C(T),M));

for j = 1:Q

LBstar_MTRQSIV_B(T,:) = sort(prctile(y_LBA_T ,(alpha(j)*100)));
LBlower_MTRQSIV_B(T,j) = LBstar_MTRQSIV_B(T,cutoff);

end

clear ySE0_T y_LBA_T; 

for i = 2:T
    
ySE0 = dlnyora(s<=J(i-1) & v==0);
yE0 = dlnyora(s==J(i-1) & v==0);
y_LBA = [ySE0(unidrnd(mSE0(i-1),mSE0_C(i-1),M))' yE0(unidrnd(m0(i-1),mG0_C(i-1),M))']';

for j = 1:Q

LBstar_MTRQSIV_B(i-1,:) = sort(prctile(y_LBA ,(alpha(j)*100))); 
LBlower_MTRQSIV_B(i-1,j) = LBstar_MTRQSIV_B(i-1,cutoff);

end

end

clear ySE0 yE0 y_LBA LBstar_MTRQSIV_B;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

UBstar_MTRQSIV_B=zeros(T,M);
UBupper_MTRQSIV_B=zeros(T,Q);

yGE1_1 = dlnyora(s>=J(1) & v==1);
y_UBA_1 = yGE1_1(unidrnd(mGE1(1),mGE1_C(1),M));

for j = 1:Q

UBstar_MTRQSIV_B(1,:) = sort(prctile(y_UBA_1 ,(alpha(j)*100)));
UBupper_MTRQSIV_B(1,j) = UBstar_MTRQSIV_B(1,M+1-cutoff);

end

clear yGE1_1 y_UBA_1;

for i = 2:T
    
yGE1 = dlnyora(s>=J(i) & v==1);
yE1 = dlnyora(s==J(i) & v==1);
y_UBA = [yGE1(unidrnd(mGE1(i),mGE1_C(i),M))' yE1(unidrnd(m1(i),mS1_C(i),M))']';

for j = 1:Q

UBstar_MTRQSIV_B(i,:) = sort(prctile(y_UBA ,(alpha(j)*100)));
UBupper_MTRQSIV_B(i,j) = UBstar_MTRQSIV_B(i,M+1-cutoff); 
    
end

end

clear yGE1 yE1 y_UBA UBstar_MTRQSIV_B;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

LBlower_MTRQSIV = max(LBlower_MTRQMTS , LBlower_MTRQSIV_B);
UBupper_MTRQSIV = min(UBupper_MTRQMTS , UBupper_MTRQSIV_B);

