% PERCENTILE BOOTSTRAP CI FOR MTR ESTIMATES - QTEs

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.50,0.75,0.90,0.95]';
Q=length(alpha);
mSE=zeros(T,1);
mGE=zeros(T,1);
mG=zeros(T,1);
pSE=zeros(T,1);
pGE=zeros(T,1);
pG=zeros(T,1);
alphaLB_MTR=zeros(T,Q); 
alphaUB_MTR=zeros(T,Q);
M=3000;
QTELBstar_MTR=zeros(6,Q,M);
QTEUBstar_MTR=zeros(6,Q,M);
beta=0.05;
LBstar_MTR=zeros(T,Q,M);
UBstar_MTR=zeros(T,Q,M);
LBlower_MTR=zeros(T,Q); 
%LBupper_MTR=zeros(T,Q); 
%UBlower_MTR=zeros(T,Q);
UBupper_MTR=zeros(T,Q);
QTELBlower_MTR=zeros(6,Q);
QTEUBupper_MTR=zeros(6,Q);
cutoff = floor((beta/2)*M);

for i = 1:T

mSE(i) = length(s(s<=J(i)));
mGE(i) = length(s(s>=J(i)));
mG(i) = length(s(s>J(i)));
pSE(i) = mSE(i)/N;
pGE(i) = mGE(i)/N;
pG(i) = mG(i)/N;
yGE = dlnyora(s>=J(i));
ySE = dlnyora(s<=J(i));

for j = 1:Q
    
alphaLB_MTR(i,j) = (1-((1-alpha(j))/pSE(i)));
alphaUB_MTR(i,j) = (alpha(j)/pGE(i));

for h = 1:M

if ((alpha(j) < 1) & (alpha(j) > pG(i))) LBstar_MTR(i,j,h) = prctile( ySE( unidrnd(mSE(i),mSE(i),1) ) , (alphaLB_MTR(i,j)*100)); 
else LBstar_MTR(i,j,h) = yMIN;
end

if ((alpha(j) <= pGE(i)) & (alpha(j) > 0)) UBstar_MTR(i,j,h) = prctile( yGE( unidrnd(mGE(i),mGE(i),1) ) , (alphaUB_MTR(i,j)*100)); 
else UBstar_MTR(i,j,h) = yMAX;       
end

end

end

end

for j = 1:Q
    
QTELBstar_MTR(1,j,1:M)=sort(LBstar_MTR(2,j,1:M)-UBstar_MTR(1,j,1:M));
QTELBstar_MTR(2,j,1:M)=sort(LBstar_MTR(3,j,1:M)-UBstar_MTR(2,j,1:M));
QTELBstar_MTR(3,j,1:M)=sort(LBstar_MTR(4,j,1:M)-UBstar_MTR(3,j,1:M));
QTELBstar_MTR(4,j,1:M)=sort(LBstar_MTR(2,j,1:M)-UBstar_MTR(1,j,1:M));
QTELBstar_MTR(5,j,1:M)=sort(LBstar_MTR(3,j,1:M)-UBstar_MTR(1,j,1:M));
QTELBstar_MTR(6,j,1:M)=sort(LBstar_MTR(4,j,1:M)-UBstar_MTR(1,j,1:M));

QTEUBstar_MTR(1,j,1:M)=sort(UBstar_MTR(2,j,1:M)-LBstar_MTR(1,j,1:M));
QTEUBstar_MTR(2,j,1:M)=sort(UBstar_MTR(3,j,1:M)-LBstar_MTR(2,j,1:M));
QTEUBstar_MTR(3,j,1:M)=sort(UBstar_MTR(4,j,1:M)-LBstar_MTR(3,j,1:M));
QTEUBstar_MTR(4,j,1:M)=sort(UBstar_MTR(2,j,1:M)-LBstar_MTR(1,j,1:M));
QTEUBstar_MTR(5,j,1:M)=sort(UBstar_MTR(3,j,1:M)-LBstar_MTR(1,j,1:M));
QTEUBstar_MTR(6,j,1:M)=sort(UBstar_MTR(4,j,1:M)-LBstar_MTR(1,j,1:M));

QTELBlower_MTR(1,j)=QTELBstar_MTR(1,j,cutoff);
QTELBlower_MTR(2,j)=QTELBstar_MTR(2,j,cutoff);
QTELBlower_MTR(3,j)=QTELBstar_MTR(3,j,cutoff);
QTELBlower_MTR(4,j)=QTELBstar_MTR(4,j,cutoff);
QTELBlower_MTR(5,j)=QTELBstar_MTR(5,j,cutoff);
QTELBlower_MTR(6,j)=QTELBstar_MTR(6,j,cutoff);

QTEUBupper_MTR(1,j)=QTEUBstar_MTR(1,j,M+1-cutoff);
QTEUBupper_MTR(2,j)=QTEUBstar_MTR(2,j,M+1-cutoff);
QTEUBupper_MTR(3,j)=QTEUBstar_MTR(3,j,M+1-cutoff);
QTEUBupper_MTR(4,j)=QTEUBstar_MTR(4,j,M+1-cutoff);
QTEUBupper_MTR(5,j)=QTEUBstar_MTR(5,j,M+1-cutoff);
QTEUBupper_MTR(6,j)=QTEUBstar_MTR(6,j,M+1-cutoff);

end

for i = 1:T
    
for j = 1:Q

LBstar_MTR(i,j,1:M) = sort(LBstar_MTR(i,j,1:M)); 
UBstar_MTR(i,j,1:M) = sort(UBstar_MTR(i,j,1:M));
LBlower_MTR(i,j) = LBstar_MTR(i,j,cutoff); 
%LBupper_MTR(i,j) = LBstar_MTR(i,j,M+1-cutoff); 
%UBlower_MTR(i,j) = UBstar_MTR(i,j,cutoff);
UBupper_MTR(i,j) = UBstar_MTR(i,j,M+1-cutoff);

end 

end
