%(1 - beta) PERCENTILE BOOTSTRAP CI FOR EE ESTIMATES - QTEs

%import dati_qboundsedu

dlnyora=data(:,1);
s=data(:,2);
v=data(:,3);
clear data colheaders textdata;
yMIN=min(dlnyora); 
yMAX=max(dlnyora);
N=length(s);
J=[1,2,3,4]';
T=length(J);
alpha=[0.05,0.10,0.25,0.50,0.75,0.90,0.95]';
Q=length(alpha);
m=zeros(T,1);
p=zeros(T,1);
alphaLB_EE=zeros(T,Q); 
alphaUB_EE=zeros(T,Q);
beta=0.05;
M=3000;
LBstar_EE=zeros(T,Q,M);
UBstar_EE=zeros(T,Q,M);
QTELBstar_EE=zeros(6,Q,M);
QTEUBstar_EE=zeros(6,Q,M);
LBlower_EE=zeros(T,Q); 
%LBupper_EE=zeros(T,Q); 
%UBlower_EE=zeros(T,Q);
UBupper_EE=zeros(T,Q);
QTELBlower_EE=zeros(6,Q);
QTEUBupper_EE=zeros(6,Q);
cutoff = floor((beta/2)*M);

for i = 1:T
    
m(i) = length(s(s==J(i)));
p(i) = m(i)/N;
y = dlnyora(s==J(i));

for j = 1:Q
    
alphaLB_EE(i,j) = (1-((1-alpha(j))/p(i)));
alphaUB_EE(i,j) = (alpha(j)/p(i));

for h = 1:M

if (p(i) > (1-alpha(j))) LBstar_EE(i,j,h) = prctile(y(unidrnd(m(i),m(i),1)), (alphaLB_EE(i,j)*100)); 
else LBstarEE(i,j,h) = yMIN;
end

if (p(i) >= alpha(j)) UBstar_EE(i,j,h) = prctile(y(unidrnd(m(i),m(i),1)), (alphaUB_EE(i,j)*100)); 
else UBstarEE(i,j,h) = yMAX;       
end

end

end

end

for j = 1:Q
    
QTELBstar_EE(1,j,1:M)=sort(LBstar_EE(2,j,1:M)-UBstar_EE(1,j,1:M));
QTELBstar_EE(2,j,1:M)=sort(LBstar_EE(3,j,1:M)-UBstar_EE(2,j,1:M));
QTELBstar_EE(3,j,1:M)=sort(LBstar_EE(4,j,1:M)-UBstar_EE(3,j,1:M));
QTELBstar_EE(4,j,1:M)=sort(LBstar_EE(2,j,1:M)-UBstar_EE(1,j,1:M));
QTELBstar_EE(5,j,1:M)=sort(LBstar_EE(3,j,1:M)-UBstar_EE(1,j,1:M));
QTELBstar_EE(6,j,1:M)=sort(LBstar_EE(4,j,1:M)-UBstar_EE(1,j,1:M));

QTEUBstar_EE(1,j,1:M)=sort(UBstar_EE(2,j,1:M)-LBstar_EE(1,j,1:M));
QTEUBstar_EE(2,j,1:M)=sort(UBstar_EE(3,j,1:M)-LBstar_EE(2,j,1:M));
QTEUBstar_EE(3,j,1:M)=sort(UBstar_EE(4,j,1:M)-LBstar_EE(3,j,1:M));
QTEUBstar_EE(4,j,1:M)=sort(UBstar_EE(2,j,1:M)-LBstar_EE(1,j,1:M));
QTEUBstar_EE(5,j,1:M)=sort(UBstar_EE(3,j,1:M)-LBstar_EE(1,j,1:M));
QTEUBstar_EE(6,j,1:M)=sort(UBstar_EE(4,j,1:M)-LBstar_EE(1,j,1:M));

QTELBlower_EE(1,j)=QTELBstar_EE(1,j,cutoff);
QTELBlower_EE(2,j)=QTELBstar_EE(2,j,cutoff);
QTELBlower_EE(3,j)=QTELBstar_EE(3,j,cutoff);
QTELBlower_EE(4,j)=QTELBstar_EE(4,j,cutoff);
QTELBlower_EE(5,j)=QTELBstar_EE(5,j,cutoff);
QTELBlower_EE(6,j)=QTELBstar_EE(6,j,cutoff);

QTEUBupper_EE(1,j)=QTEUBstar_EE(1,j,M+1-cutoff);
QTEUBupper_EE(2,j)=QTEUBstar_EE(2,j,M+1-cutoff);
QTEUBupper_EE(3,j)=QTEUBstar_EE(3,j,M+1-cutoff);
QTEUBupper_EE(4,j)=QTEUBstar_EE(4,j,M+1-cutoff);
QTEUBupper_EE(5,j)=QTEUBstar_EE(5,j,M+1-cutoff);
QTEUBupper_EE(6,j)=QTEUBstar_EE(6,j,M+1-cutoff);

end

for i = 1:T
    
for j = 1:Q
    
LBstar_EE(i,j,1:M) = sort(LBstar_EE(i,j,1:M)); 
UBstar_EE(i,j,1:M) = sort(UBstar_EE(i,j,1:M));
LBlower_EE(i,j) = LBstar_EE(i,j,cutoff); 
%LBupper_EE(i,j) = LBstar_EE(i,j,M+1-cutoff); 
%UBlower_EE(i,j) = UBstar_EE(i,j,cutoff);
UBupper_EE(i,j) = UBstar_EE(i,j,M+1-cutoff);

end 

end

%``adjust'' by MIN and MAX

QTELBlower_EE(1,1:3)=QTELBlower_EE(1,1:3)+yMIN;
QTELBlower_EE(2,1:3)=QTELBlower_EE(2,1:3)+yMIN;
QTELBlower_EE(3,1:3)=QTELBlower_EE(3,1:3)+yMIN;
QTELBlower_EE(4,1:3)=QTELBlower_EE(4,1:3)+yMIN;
QTELBlower_EE(5,1:3)=QTELBlower_EE(5,1:3)+yMIN;
QTELBlower_EE(6,1:3)=QTELBlower_EE(6,1:3)+yMIN;
QTELBlower_EE(1,5:7)=QTELBlower_EE(1,5:7)-yMAX;
QTELBlower_EE(2,5:7)=QTELBlower_EE(2,5:7)-yMAX;
QTELBlower_EE(3,5:7)=QTELBlower_EE(3,5:7)-yMAX;
QTELBlower_EE(4,5:7)=QTELBlower_EE(4,5:7)-yMAX;
QTELBlower_EE(5,5:7)=QTELBlower_EE(5,5:7)-yMAX;
QTELBlower_EE(6,5:7)=QTELBlower_EE(6,5:7)-yMAX;

QTEUBupper_EE(1,1:3)=QTEUBupper_EE(1,1:3)-yMIN;
QTEUBupper_EE(2,1:3)=QTEUBupper_EE(2,1:3)-yMIN;
QTEUBupper_EE(3,1:3)=QTEUBupper_EE(3,1:3)-yMIN;
QTEUBupper_EE(4,1:3)=QTEUBupper_EE(4,1:3)-yMIN;
QTEUBupper_EE(5,1:3)=QTEUBupper_EE(5,1:3)-yMIN;
QTEUBupper_EE(6,1:3)=QTEUBupper_EE(6,1:3)-yMIN;
QTEUBupper_EE(1,5:7)=QTEUBupper_EE(1,5:7)+yMAX;
QTEUBupper_EE(2,5:7)=QTEUBupper_EE(2,5:7)+yMAX;
QTEUBupper_EE(3,5:7)=QTEUBupper_EE(3,5:7)+yMAX;
QTEUBupper_EE(4,5:7)=QTEUBupper_EE(4,5:7)+yMAX;
QTEUBupper_EE(5,5:7)=QTEUBupper_EE(5,5:7)+yMAX;
QTEUBupper_EE(6,5:7)=QTEUBupper_EE(6,5:7)+yMAX;
