open xal=aldat;
xx=readr(xal,28);
@               @
@  data updates @
@               @
xx[.,8]=xx[.,8]*ln(10);
xx[27,11]=2.48;
xx[28,11]=1.90;
xx[.,11]=xx[.,11]/100;
xx[28,7] = 2.0531;
xx[28,8] = ln(0.6252);
@                                                  @
@  extend price and exchange rate to 1992 and 1993 @
@                                                  @
xx = xx|zeros(2,12);
xx[29:30,7] = (1.9862|1.9802);
xx[29:30,8] = ln(0.6056|0.6599);
px = xx[.,7]-0.85*xx[.,8];
@                   @
@  define variables @
@                   @
y1 = xx[.,7]~xx[.,3]+xx[.,4]~xx[.,1:2]~xx[.,5];
y2 = xx[.,10]~xlag(xx[.,6],1)~xx[.,11]~xx[.,8];
let y1nam = price stox prod cons nimps;
let y2nam = cip cnstr rr lexr;
x1 = xlag(y1~y2,1)~xx[.,12];
x2 = xlag(y2,1)~xx[.,12];
let x1nam = price1 stox1 prod1 cons1 nimps1 cip1 cnstr1 rr1 lexr1 constant;
let x2nam = cip1 cnstr1 rr1 lexr1 constant;
y1 = trimr(y1,2,0);
x1 = trimr(x1,2,0);
y2 = trimr(y2,2,0);
x2 = trimr(x2,2,0);
nobs = rows(y1)-2;
@                       @
@  OLS estimates of VAR @
@                       @
{b1,u1} = ols(trimr(x1,0,2),trimr(y1,0,2));
{b2,u2} = ols(trimr(x2,0,2),trimr(y2,0,2));
b = b1~(zeros(rows(b1)-rows(b2),cols(b2))|b2);
uu = (u1~u2)'*(u1~u2);
llh = nobs*sumc(diag(uu));
@                   @
@  forecast section @
@                   @
uf = zeros(nobs,5);                     @ forecast errors @
ub = zeros(5,1);                        @ forecast bias   @
usd = zeros(5,1);                       @ forecast s.d.   @
iper = 1;
xf = trimr(y1~y2,0,2)~ones(nobs,1);
do until iper==6;
  yf = forc(xf,iper);
  xf = yf~ones(nobs,1);
  iper = iper+1;
endo;
urmse = sqrt(ub^2+usd^2);
print "Forecast statistics";
print "        Bias            s.d.            r.m.s.e"
ub~usd~urmse;
@               @
@  lag function @
@               @
proc xlag(x,m);
  local xm,xxm;
  xm=zeros(m,cols(x));
  xxm=trimr((xm|x),0,m);
  retp(xxm);
endp;
@                @
@  lead function @
@                @
proc xlead(x,m);
  local nobs,xm,xxm;
  nobs=rows(x);
  xm=zeros(m,cols(x));
  xxm=trimr((x|xm),m,0);
  retp(xxm);
endp;
@               @
@  OLS function @
@               @
proc(2) = ols(x,y);
  local b,cxx,cxxi,cxy,u;
  cxx = x'*x;
  cxy = x'*y;
  cxxi = invpd(cxx);
  b = cxxi*cxy;
  u = y-x*b;
  retp(b,u);
endp;
@                   @
@  forecast routine @
@                   @
proc forc(x,n);
  local per,yf;
  yf = x*b;
  per = yf[.,1]-0.85*yf[.,9];                  @ dollar price @
  uf[.,n] = trimr(xlead(px,n),2,2)-per;
  ub[n] = meanc(trimr(uf[.,n],0,n));
  usd[n] = stdc(trimr(uf[.,n],0,n));
  retp(yf);
endp;
@               @
@  program ends @
@               @
end;
