library optmum;
clear cns,prod,stox;
output file = alsim.out reset;
print trimr(date,0,1)';
@                                                            @
@  1 prodn   2 cons   3 pstox   4 mstox    5 nimps   6 cnstr @
@  7 lrpx    8 lexr   9 trend  10 cip      11 rr    12 const @
@                                                            @
open xal=aldat;
xx=readr(xal,28);
@               @
@  data updates @
@               @
xx[.,8]=xx[.,8]*ln(10);
xx[27,11]=2.48;
xx[28,11]=1.90;
xx[.,11]=xx[.,11]/100;
xx[28,7] = 2.0531;
xx[28,8] = ln(0.6252);
@                                                  @
@  extend price and exchange rate to 1992 and 1993 @
@                                                  @
xx = xx|zeros(2,12);
xx[29:30,7] = (1.9862|1.9802);
xx[29:30,8] = ln(0.6056|0.6599);
px = xx[.,7]-0.85.*xx[.,8];      @ dollar price @
nf = rows(xx)-4;
mf = 5;
@                        @
@  equation coefficients @
@                        @
bc =  (-.093661|1.915867|.527584|-.128765)~
      (-.073235|1.903472|.538338|-.135284);
bq =  (-.241112|-.485736|-.336723|.135929)~
      (-.193869|-.495490|-.348087|.117674);
eta = (.048673|.289234);
bs = (0.22730*ones(1,2)+0.0277*eta'|eta');
bp = (-.023063|-2.3700|0|0|0|0|1)~
     (1.4001|-2.7540|-1.1764|0|0|0|.53049)~
     (3.6134|-1.8063|-2.0654|-.31642|-1.4991|.053384|0);
bt = (0|1|0)~(2.9724|.31409|-.51428);
bx1 = (1|1|0.7881|1);
bx0 = (0.017241|0.15858|0.0055|-0.0005);
bx2 = -0.43465;
bx3 = 0;  @  0.0144; @
ber = (-.087919|1.26626|-.29805-.26626);
eps = 0.00001;
@                                                 @
@  constant forecasts, exchange rate adjusted     @
@  and no change and AR(2) price model            @
@                                                 @
mpx = meanc(trimr(px,2,2));
mp = meanc(trimr(xx[.,7],2,2));
im = 1;
do until im==6;
  resf = zeros(nf,mf);
  f = 1;
  do until f==nf+1;
    xadj = zeros(mf,1);
    pf = zeros(mf,1);
    i = 1;
    do until i==mf+1;
      if i==1;
        if im==3;
          pf[i] = px[f+1];
        elseif im>3;
          pf[i] = (1~xx[f+1,7]~xx[f,7])*bt[.,im-3];
        endif;
        if im==2 or im>3;
          xadj[i] = (1~xx[f+1,8]~xx[f,8])*ber;
        endif;
      elseif i==2;
        if im==3;
          pf[i] = pf[i-1];
        elseif im>3;
          pf[i] = (1~pf[1]~xx[f+1,7])*bt[.,im-3];
        endif;
        if im==2 or im>3;
          xadj[i] = (1~xadj[1]~xx[f+1,8])*ber;
        endif;
      else;
        if im==3;
          pf[i] = pf[i-1];
        elseif im>3;
          pf[i] = (1~pf[i-1]~pf[i-2])*bt[.,im-3];
        endif;
        if im==2 or im>3;
          xadj[i] = (1~xadj[i-1]~xadj[i-2])*ber;
        endif;
      endif;
      i=i+1;
    endo;
    nc = minc(nf-f+2|mf);
    if im==1;
      resf[f,1:nc] = px[f+2:f+nc+1]' - mpx.*ones(1,nc);
    elseif im==2;
      resf[f,1:nc] = px[f+2:f+nc+1]' - (mp.*ones(1,nc)-0.85.*xadj[1:nc]');
    elseif im==3;
      resf[f,1:nc] = px[f+2:f+nc+1]' - pf[1:nc]';
    else;
      resf[f,1:nc] = px[f+2:f+nc+1]' - (pf[1:nc]-0.85.*xadj[1:nc])';
    endif;
    f = f+1;
  endo;
  print;
  if im<3;
    print "Constant forecasts";;
  elseif im==3 or im==4;
    print "No change forecasts";;
  else;
    print "AR(2) price model";;
  endif;
  if im==2 or im>3;
    print ", exchange rate adjusted";
  endif;
  print;
  call rprnt(resf);
  im = im+1;
endo;
@ @
resf = zeros(nf,mf);       @ forecast residuals @
x = zeros(nf+mf+2,5);
y = zeros(nf+mf+2,4);
@ @
im = 1;
do until im==6;
  if im<5;
    ii = 1;
  else;
    ii = 2;
  endif;
  f = 1;
  do until f==nf+1;
@                              @
@  initialize lagged values    @
@                              @
@  cip cnstr1 rr nimps lexr    @
@  prod cons price stox        @
@                              @
    x[1:f+1,.] = xx[1:f+1,10]~(xx[1,6]|xx[1:f,6])~xx[1:f+1,11]~xx[1:f+1,5]~
      xx[1:f+1,8];
    y[1:f+1,.] = xx[1:f+1,1]~xx[1:f+1,2]~xx[1:f+1,7]~(xx[1:f+1,3]+xx[1:f+1,4]);
@                               @
@  generate exogenous variables @
@                               @
    i = f;
    do until i==nf+mf+1;
      x[i+2,1:4] = bx0' + x[i+1,1:4].*bx1';
      x[i+2,2] = x[i+2,2]+bx2*x[i,2];
      if i>21;
        x[i+2,4] = x[i+2,4]+bx3;
      endif;
      x[i+2,5] = (1~x[i+1,5]~x[i,5])*ber;
      i = i+1;
    endo;
    if im<4;
@                  @
@ Non-RE model     @
@                  @
      cns = zeros(mf,1);
      prod = zeros(mf,1);
      p = zeros(mf,1);
      stox = zeros(mf,1);
      i = 1;
      do until i==mf+1;
@              @
@  consumption @
@              @
        if i==1;
          xc = 1~x[i+f+1,1:2]~y[i+f,3];
        else;
          xc = 1~x[i+f+1,1:2]~p[i-1];
        endif;
        cns[i] = xc*bc[.,ii];
        if i==1;
          pp = y[i+f,3];
        else;
          pp = p[i-1];
        endif;
        iter = 1;
        do until iter==100;
@              @
@  production  @
@              @
          if i==1;
            ql = y[i+f,1];
            xq = 1~y[i+f,1]-cns[i]+x[i+f+1,4]~y[i+f,4]~pp;
          else;
            ql = prod[i-1];
            xq = 1~prod[i-1]-cns[i]+x[i+f+1,4]~stox[i-1]~pp;
          endif;
          prod[i] = ql+xq*bq[.,ii];
@              @
@  price       @
@              @
          if im<3;
            if i==1;
              xp = 1~prod[i]-cns[i]+x[i+f+1,4]~y[i+f,4]~0~0~0~y[i+f,3];
            else;
              xp = 1~prod[i]-cns[i]+x[i+f+1,4]~stox[i-1]~0~0~0~p[i-1];
            endif;
          else;
            if i==1;
              xp = 1~y[i+f,1]-cns[i]+x[i+f+1,4]~y[i+f,4]~x[i+f+1,1:2]
                ~x[i+f,2]~0;
            else;
              xp = 1~prod[i-1]-cns[i]+x[i+f+1,4]~stox[i-1]~x[i+f+1,1:2]
                ~x[i+f,2]~0;
            endif;
          endif;
          ppl = pp;
          pp = xp*bp[.,im];
          if abs(pp-ppl)<eps;
            goto conv;
          endif;
          iter = iter+1;
        endo;
        print "Convergence failure, observation ";;
        print f;;
        print "   step";;
        print i;
conv:   p[i] = pp;
@               @
@  stocks       @
@               @
        if i==1;
          stox[i] = prod[i]+y[i+f,4]+x[i+f+1,4]-cns[i];
        else;
          stox[i] = prod[i]+stox[i-1]+x[i+f+1,4]-cns[i];
        endif;
        i = i+1;
      endo;
@                        @
@  dollar price          @
@                        @
      per = p-0.85.*x[f+2:f+mf+1,5];
    else;
@                  @
@ RE model         @
@ initialize price @
@                  @
      p0 = meanc(trimr(xx[.,7],2,2)).*ones(mf,1);
@                  @
@  optimization    @
@                  @
      {p,fval,pg,rc} = optmum(&fct,p0);
      if rc>0;
        print "optimization error ";;rc;
      endif;
    endif;
@                        @
@  store results         @
@                        @
    y[f+2:f+mf+1,.] = prod~cns~per~stox;
    nc = minc(nf-f+2|mf);
    resf[f,1:nc] = (px[f+2:f+nc+1]-per[1:nc])';
    f = f+1;
  endo;
@                @
@  print results @
@                @
  print;
  if im<4;
    print "Non-RE model" ;;
    print im;
  else;
    print "RE model,    eta = ";;
    print eta[ii];
  endif;
  print;
  call rprnt(resf);
  im = im+1;
endo;
closeall;
end;
@                       @
@  minimization routine @
@                       @
proc fct(p);
  local ql,res,xc,xq,xs;
@              @
@  consumption @
@              @
  xc = ones(mf,1)~x[f+2:f+mf+1,1:2]~(y[f+1,3]|trimr(p,0,1));
  cns = xc*bc[.,ii];
@              @
@  stocks      @
@              @
  xs = ones(mf,1)~((trimr(p,1,0)|p[mf])-p-x[f+2:f+mf+1,3]);
  stox = xs*bs[.,ii];
@              @
@  production  @
@              @
  prod = zeros(mf,1);
  xq = ones(mf,2)~(y[f+1,4]|trimr(stox,0,1))~p;
  i = 1;
  do until i==mf+1;
    if i==1;
      ql = y[f+1,1];
    else;
      ql = prod[i-1];
    endif;
    xq[i,2] = ql-cns[i]+x[f+i+1,4];
    prod[i] = ql+xq[i,.]*bq[.,ii];
    i = i+1;
  endo;
@                        @
@  dollar price          @
@                        @
  per = p-0.85.*x[f+2:f+mf+1,5];
@                        @
@  optimization residual @
@                        @
  res = (y[f+1,4]|trimr(stox,0,1))+prod+x[f+2:f+mf+1,4] - cns-stox;
  retp(res'*res);
endp;
@                             @
@  print residual statisitics @
@                             @
proc(0) = rprnt(x);
  local i,rstat,z;
  z = x[rows(x)-1,2]|x[rows(x),1:2]';
  rstat = zeros(mf,4);
  rstat[.,1] = seqa(1,1,mf);
  i = 1;
  do until i==mf+1;
    rstat[i,2] = meanc(trimr(x[.,i],0,i));
    rstat[i,3] = stdc(trimr(x[.,i],0,i));
    i = i+1;
  endo;
  rstat[.,4] = sqrt(rstat[.,2]^2 + rstat[.,3]^2);    @ rmse @
  print "Forecast residual statistics ";
  print "          steps               bias             sd             rmse";
  rstat;
  print;
  print "Post sample residuals, 1990/1992, 1991/1992, 1991/1993";
  z';
  retp;
endp;

