library optmum;
open xal=aldat;
output file = al.out reset;
clear _opfhess,a0,aa0,aa,b,b0,czzi,eta,f0,f1,f2,phi,sec,seq,sep,ses,theta,w,wi,
  gmma,psbar,xx,xcbar,imax,wwd,wwwi,czzi,v,u,dv,s,ss,sa;
xx=readr(xal,28);
xx[27,11]=2.48;
xx[28,11]=1.90;
xx[.,8]=xx[.,8]*ln(10);
xx[.,11]=xx[.,11]/100;
_opgtol=1.0E-04;
print trimr(date,0,1)';
let dnam = cons dprod lrpxx stox;
icn=0;
ise = 2;
@               @
@  lag function @
@               @
proc xlag(x,m);
  local xm,xxm;
  xm=zeros(m,1);
  xxm=trimr((xm|x),0,m);
  retp(xxm);
endp;
@                @
@  lead function @
@                @
proc xlead(x,m);
  local nobs,xm,xxm;
  nobs=rows(x);
  xm=ones(m,1)*x[nobs,.];
  xxm=trimr((x|xm),m,0);
  retp(xxm);
endp;
@                          @
@  abbreviated OLS routine @
@                          @
proc (14) = lsest(depvar,indvars);
    local cov,cxx,cxxi,cxy,cyy,dta,mn,nobs,nvar,nvar1,old,vc,
         b,df,dwstat,fstat,pvf,pvt,rbsq,rsq,sse,stderr,stdest,t,tv,u;
    dta=indvars~depvar;
    nobs=rows(dta);
    nvar1=cols(dta);
    nvar=nvar1-1;
    mn=meanc(dta);
    cov=moment(dta,0);
    cyy = cov[nvar1,nvar1];
    cxy = cov[1:nvar,nvar1];
    cxx = cov[1:nvar,1:nvar];
    cxxi=invpd(cxx);
    b = cxxi*cxy;
    df = nobs-nvar;
    sse = cyy-b'*cxy;
    vc = (sse/df)*cxxi;
    stderr = sqrt(diag(vc));
    t = b./stderr;
    tv = cyy-nobs*mn[nvar1]^2;
    rsq = (tv - sse)/tv;
    rbsq = 1-(1-rsq)*((nobs-1)/df);
    fstat = (rsq/(1-rsq))*(df/(nvar-1));
    pvf = cdffc(fstat,nvar-1,df);
    pvt = 2*cdftc(abs(t),df);
    stdest = sqrt(sse/df);
    old = ndpcntrl(0,0);
    call ndpcntrl(1,1);
    u = dta[.,nvar1]-dta[.,1:nvar]*b;
    ndpclex;
    dwstat = sumc((trimr(u,1,0)-trimr(u,0,1))^2)/sse;
    retp(b,df,dwstat,fstat,pvf,pvt,rbsq,rsq,sse,stderr,stdest,t,tv,u);
endp;
@                                    @
@  instrumental variables estimation @
@                                    @
proc (14) = ivest(depvar,indvars,zz);
    local cov,cxz,cxzzx,cxzzxi,cxzzy,cyy,czy,czz,dta,ezz,
        mn,nobs,nvar,nvar1,nvar2,nvar3,nvarz,old,vc,zz,zu,
        b,ddf,df,dwstat,pvt,rbsq,rsq,sse,sargan,stderr,stdest,t,tv,u;
    dta=indvars~zz~depvar;
    nobs=rows(dta);
    nvar=cols(indvars);
    nvar1=nvar+1;
    nvarz=cols(zz);
    nvar2=nvar+nvarz;
    nvar3=cols(dta);
    ddf=nvarz-nvar;
    if ddf<0;
        print "Equation unidentified";
        retp(b,ddf,df,dwstat,pvt,rbsq,rsq,sse,sargan,stderr,stdest,t,tv,u);
    endif;
    mn=meanc(dta);
    cov=moment(dta,0);
    cyy = cov[nvar3,nvar3];
    czz=cov[nvar1:nvar2,nvar1:nvar2];
    cxz=cov[1:nvar,nvar1:nvar2];
    czy=cov[nvar1:nvar2,nvar3];
    czzi=invpd(czz);
    cxzzx=cxz*czzi*cxz';
    cxzzy=cxz*czzi*czy;
    cxzzxi=invpd(cxzzx);
    b=cxzzxi*cxzzy;
    old = ndpcntrl(0,0);
    call ndpcntrl(1,1);
    u = depvar-indvars*b;
    ndpclex;
    sse=u'*u;
    dwstat = sumc((trimr(u,1,0)-trimr(u,0,1))^2)/sse;
    df = nobs-nvar;
    vc = (sse/df)*cxzzxi;
    stderr = sqrt(diag(vc));
    t = b./stderr;
    tv = cyy-nobs*mn[nvar3]^2;
    rsq = (tv - sse)/tv;
    rbsq = 1-(1-rsq)*((nobs-1)/df);
    pvt = 2*cdftc(abs(t),df);
    stdest = sqrt(sse/df);
    zu=dta[.,nvar1:nvar2]'*u;
    sargan=(zu'*czzi*zu)*df/sse;
    retp(b,ddf,df,dwstat,pvt,rbsq,rsq,sse,sargan,stderr,stdest,t,tv,u);
endp;
@                     @
@  systems estimation @
@                     @
proc (15) = sysest(y,x,zz,nx,w,vnam,emode);
   local b,bs,cov,cxz,cxzzx,cxzzy,cyy,czy,czz,dta,nxx,j1,j2,jy,vc,f,bg,kb,
      nobs,nvar,nvar1,nvar2,nvar3,nvar4,ny,nz,sxzzxi,sxzzy,sxzzx,wwi,bh,
      df,dwstat,pvt,rbsq,rsq,sse,stdest,ts,tv,ww,i1,i2,iy,niy,nmax,vnam1,rc,
      eta,lamda,ha,ja,ka,j,aa,kh,hk,hki,seta,ap11,ap12,thap12,dthdb,dphdb,
      irb,srho,wd,wdi,xk,cvvi,dbda;
   nobs=rows(x);
   nvar=cols(x);
   nvar1=nvar+1;
   nz=cols(zz);
   nvar2=nvar+nz;
   nvar3=nvar2+1;
   ny=cols(y);
   nvar4=nvar2+ny;
   nmax=maxc(nx);
   nxx=sumc(nx);
   dta=x~zz~y;
   cov=moment(dta,0);
   czz=cov[nvar1:nvar2,nvar1:nvar2];                   @ Z'Z              @
   cyy=cov[nvar3:nvar4,nvar3:nvar4];                   @ Y'Y              @
   czzi = invpd(czz);                                  @ (Z'Z)-1          @
   df=nobs-nx;
   if emode>4 and ise>0;                               @  stack X         @
     xk = zeros(ny*nobs,nvar);
     iy = 1;
     j1 = 1;
     do until iy==ny+1;
       i1 = (iy-1)*nobs+1;
       i2 = iy*nobs;
       j2 = j1+nx[iy]-1;
       xk[i1:i2,j1:j2] = x[.,j1:j2];
       j1 = j2+1;
       iy = iy+1;
     endo;
   endif;
   if emode==4;
     wdi = diag(wi);
     cxz=cov[1:nvar,nvar1:nvar2];                      @ X'Z              @
     czy=cov[nvar1:nvar2,nvar3:nvar4];                 @ Z'y              @
     cxzzy=(cxz*czzi*czy)*diagrv(eye(4),wdi);          @ X'Z(Z'WZ)-1Z'Y   @
     sxzzxi = zeros(nxx,nxx);
     sxzzy = zeros(nxx,1);
     iy=1;
     i1=1;
     do while iy < ny+1;
       i2 = i1+nx[iy]-1;
       sxzzx = wdi[iy].*(cxz[i1:i2,.]*czzi*cxz[i1:i2,.]');
                                                      @ X'Z(Z'WZ)-1Z'X   @
       sxzzxi[i1:i2,i1:i2] = invpd(sxzzx);
       sxzzy[i1:i2] = cxzzy[i1:i2,iy];
       iy=iy+1;
       i1=i2+1;
     endo;
     bs = zeros(nmax,ny);
     b=sxzzxi*sxzzy;
     s=diag(sxzzxi);
     b0=b;
   elseif emode==5;
     if imax==0;
       {b,f0,bg,rc} = optmum(&fct,a0);
     else;
       {b,f1,bg,rc} = optmum(&fct,a0);
     endif;
     if rc>0;
       print "optimization error  ";;rc;
     endif;
     a0=b;
     if imax == 1;
       df[3:4] = (nobs+2)*ones(2,1)-nx[3:4];
       bs=(b[1:4]|zeros(nmax-4,1))~(b[5:8]|zeros(nmax-4,1))
         ~b[9:14]~zeros(nmax,1);
       bs[1,4]=b[15];
       bs[2:6,4]=b[6]*bs[2:6,3];
       bs[2,4]=bs[2,4]+1;
       if ise ==0;
         kb=eye(15)|zeros(5,15);
         kb[16,10]=b[6];
         kb[17,11]=b[6];
         kb[18,12]=b[6];
         kb[19,13]=b[6];
         kb[20,14]=b[6];
         kb[16:20,6]=b[10:14];
         s=diag(kb*_opfhess*kb');
       else;
         dbda = gradp(&gct5,b);
         v = xk*dbda;
         cvvi = invpd(v'*v);
         dv = diag(v*cvvi*v');
         sa = ivse(v,w,zz);
         s = diag(dbda*sa*dbda');
       endif;
     else;
       bs=(b[1:4]|zeros(nmax-4,1))~(b[5:8]|zeros(nmax-4,1))
         ~b[9:14]~b[15:20];
       if ise==0;
         s = diag(_opfhess);
       else;
         sa = ivse(xk,w,zz);
         s = diag(sa);
       endif;
     endif;
     vc=0;
   elseif emode==6;
     {b,f2,bg,rc} = optmum(&fct,a0);
     a0 = b;
     if rc>0;
       print "optimization error  ";;rc;
     endif;
     df[1:2] = (nobs+1)*ones(2,1) - nx[1:2];
     df[3:4] = (nobs+3)*ones(2,1) - nx[3:4];
     bs=(b[1:4]|zeros(nmax-4,1))~(b[5:8]|zeros(nmax-4,1))~zeros(nmax,2);
     bs[1,3]=b[9];
     bs[1,4]=b[10];
     eta=b[11];
     lamda=1/b[6];
     ha = (1~-lamda)|(eta~1);
     ja = (0~0)|(eta~0);
     ka = zeros(2,5);
     ka[1,1] = -lamda;
     ka[2,5] = -eta;
     j=1;
     do until j==26;
       aa = ainv(aa0,ha,ja,ka,theta,phi);
       aa0=aa;
       j=j+1;
     endo;
     bs[2:6,3:4]=aa';
     if ise==0;
       kb=(eye(9)|zeros(11,9))~zeros(20,2);
       kb[15,10]=1;
       ap11 = eta*(1-aa[1,.]*phi[.,1]);
       ap12 = 1-eta*aa[1,.]*phi[.,2];
       thap12 = theta' + aa[1,.]*phi[.,1] + aa[2,.]*phi[.,2];
       kh = ap11 + b[6]*ap12;
       hk = kh*eye(5) - thap12.*eta;
       hki = inv(hk);
       kb[10:14,11] = -hki*((zeros(4,1)|1)+aa[1,.]'.*ap11);
       kb[16:20,11] = kb[10:14,11].*b[6];
       dthdb = zeros(5,5);
       dthdb[1,2] = -1;
       dthdb[1,3] = - bs[4,1]*(1+gmma[2,2]);
       dthdb[2,2] = -1;
       dphdb = zeros(5,2);
       dphdb[1,1] = - (bs[2,2]-bs[2,1]);
       dphdb[1,2] = - 1;
       dphdb[2,1] = 1 + bs[3,2];
       kb[10:14,6] = hki*((dthdb'+(aa[1,.]*dphdb[.,1])*eye(5))*aa[1,.]'
          - aa[2,.]'.*(lamda*ap12-eta*aa[1,.]*dphdb[.,2])
          + (bs[2,2]*ap12/(bs[2,2]^2)|zeros(4,1)));
       kb[16:20,6] = kb[10:14,6].*b[6] + aa[1,.]';
       dthdb = zeros(5,5);
       dthdb[1,3] = (1-bs[2,2])*(1+gmma[2,2]);
       kb[10:14,3] = hki*dthdb*aa[1,.]'.*eta;
       kb[16:20,3] = kb[10:14,3].*b[6];
       dphdb = zeros(5,2);
       dphdb[1,1] = - (1-bs[2,2]);
       dphdb[2,1] = bs[3,2];
       kb[10:14,2] = hki*(aa[1,.]'.*(aa[1,.]*dphdb[.,1])
         +aa[2,.]'.*(aa[1,.]*dphdb[.,2])).*eta;
       kb[16:20,2] = kb[10:14,2].*b[6];
       dphdb = zeros(5,2);
       dphdb[2,1] = bs[2,2] - bs[2,1];
       kb[10:14,7] = hki*(aa[2,.]'.*(aa[1,.]*dphdb[.,2])).*eta;
       kb[16:20,7] = kb[10:14,7].*b[6];
       dphdb = zeros(5,2);
       dphdb[2,2] = 1;
       kb[10:14,8] = hki*(aa[2,.]'.*(aa[1,.]*dphdb[.,2])).*eta;
       kb[16:20,8] = kb[10:14,8].*b[6];
       s=diag(kb*_opfhess[1:11,1:11]*kb');
     else;
       dbda = gradp(&gct6,b);
       v = xk*dbda;
       cvvi = invpd(v'*v);
       dv = diag(v*cvvi*v');
       sa = ivse(v,w,zz);
       s = diag(dbda*sa*dbda');
     endif;
     if ise==0;
       seta = _opfhess[11,11];
     else;
       seta = sa[11,11];
     endif;
     bs[6,1] = eta;
     vc=0;
   endif;
   ss = ones(nmax,ny);
   vnam1 = zeros(nmax,ny);
   if emode==4;
     u = zeros(nobs,ny);
   endif;
   iy=1;
   i1=1;
   do while iy < ny+1;
     niy=nx[iy];
     i2=i1+niy-1;
     ss[1:niy,iy] = s[i1:i2];
     if emode==4;
       bs[1:niy,iy] = b[i1:i2];
       u[.,iy] = y[.,iy] - x[.,i1:i2]*trimr(bs[.,iy],0,nmax-niy);
     endif;
     vnam1[1:niy,iy] = vnam[i1:i2];
     iy=iy+1;
     i1=i2+1;
   endo;
   if emode==6;
     vnam1[6,1] = "eta";
     ss[6,1]=seta;
   endif;
   sse=diag(u'*u);
   stdest = sqrt(sse./df);
   ss=sqrt(ss);
   ts=bs./ss;
   pvt = zeros(nmax,ny);
   iy = 1;
   do while iy < ny+1;
     pvt[.,iy] = 2*cdftc(abs(ts[.,iy]),df[iy]);
     iy=iy+1;
   endo;
   tv = diag(cyy)-nobs*(meanc(y))^2;
   rsq = (tv - sse)./tv;
   rbsq = 1-(1-rsq).*((nobs-1)/df);
   dwstat = sumc((trimr(u,1,0)-trimr(u,0,1))^2)./sse;
   ww=moment(u,0)/nobs;
   if emode < 5;
     sxzzx = zeros(nxx,nxx);
     wwi=invpd(ww);
     iy=1;
     i1=1;
     do while iy < ny+1;
       i2 = i1+nx[iy]-1;
       jy=1;
       j1=1;
       do while jy<ny+1;
         j2 = j1+nx[jy]-1;
         sxzzx[i1:i2,j1:j2] = (cxz[i1:i2,.]*czzi*cxz[j1:j2,.]').*wwi[iy,jy];
         if jy<iy;
           sxzzx[j1:j2,i1:i2] = sxzzx[i1:i2,j1:j2]';
         endif;
         jy=jy+1;
         j1=j2+1;
       endo;
       iy=iy+1;
       i1=i2+1;
     endo;
     vc = invpd(sxzzx);
   endif;
   retp(bs,df,dwstat,pvt,rbsq,rsq,sse,ss,stdest,ts,tv,u,ww,vc,vnam1);
endp;
@                            @
@  estimation output routine @
@                            @
proc(5) = lsiv(depvar,indvars,zz,nx,dnam,vnam,znam,emode);
  local b,ddf,df,dfu,dta,dwstat,emode,fmt,fstat,iy,k,mask,nobs,old,omat,
      nvar,nvar1,ny,pvf,pvs,pvt,rbsq,rsq,sargan,sse,std,stderr,
      stdest,str,t,tv,u,vc,vnam1,wc,ww,nxm,nxi;
  nobs=rows(depvar);
  nvar=cols(indvars);
  nvar1=nvar+1;
  vc=0;
  vnam1=vnam;
  if emode == 1;
    {b,df,dwstat,fstat,pvf,pvt,rbsq,rsq,sse,stderr,stdest,t,tv,u} =
      lsest(depvar,indvars);
  elseif emode == 2;
    {b,ddf,df,dwstat,pvt,rbsq,rsq,sse,sargan,stderr,stdest,t,tv,u} =
      ivest(depvar,indvars,zz);
  elseif emode == 4 or emode == 5 or emode == 6;
   {b,df,dwstat,pvt,rbsq,rsq,sse,stderr,stdest,t,tv,u,ww,vc,vnam1} =
     sysest(depvar,indvars,zz,nx,w,vnam,emode);
  else;
    print "Incorrect estimation mode";
    print;print;print;
    retp;
  endif;
  ny = cols(depvar);
  nxm = maxc(nx);
  iy = 1;
  mask = 0~1~1~1~1;
  let fmt[5,3] = "-*.*s" 9 8 "*.*lf" 12 6 "*.*lf" 12 6 "*.*lf" 12 6 ""\
    "*.*lf" 10 3 ;
  do while iy < ny+1;
    if __output;
      print ftos(icn,"Regression:   %*.*lf",20,0);;
      if emode == 1;
        print "      OLS";
      elseif emode == 2;
        print "      IV";
      elseif emode ==4;
        print "      SYS";
      else;
        print "      NLSYS";
      endif;
      print ftos(nobs,"Observations: %*.*lf",20,0);;
      print ftos(dnam[iy],"      Dependent variable:%*.*s",20,8);
      print ftos(tv[iy],"Total SS:     %*.*lf",20,5);;
      print ftos(df[iy],"      Degrees of freedom:%*.*lf",20,0);
      print ftos(rsq[iy],"R-squared:    %*.*lf",20,5);;
      print ftos(rbsq[iy],"      Rbar-squared:      %*.*lf",20,5);
      print ftos(sse[iy],"Residual SS:  %*.*lf",20,5);;
      print ftos(stdest[iy],"      Std error of est:  %*.*lf",20,5);
      if emode == 1;
        str = ftos(nvar,"F(%*.*lf,",1,0) $+ ftos(df,"%*.*lf):       ",1,0);
        str = strsect(str,1,15) $+ ftos(fstat,"%*.*lf",19,5);
        print str;;
        print ftos(pvf,"      Probability of F:  %*.*lf",20,5);
      endif;
      if nx == 0;
        nxi=0;
      else;
        nxi=nxm-nx[iy];
      endif;
      print ftos(dwstat[iy],"Durbin-Watson:%*.*lf",20,5);
      print;
      print "                         Standard                 Prob";
      print "Variable     Estimate      Error      t-value     >|t|";
      print "-------------------------------------------------------";
      omat = trimr(vnam1[.,iy]~b[.,iy]~stderr[.,iy]~t[.,iy]~pvt[.,iy],0,nxi);
      call printfm(omat,mask,fmt);
      if emode == 6 and iy == 3;
        print;
        omat = vnam1[6,1]~b[6,1]~stderr[6,1]~t[6,1]~pvt[6,1];
        call printfm(omat,mask,fmt);
        print;
      endif;
      if emode > 1;
        print;
        print "Instrument set:  ";;
        print $znam';
      endif;
      if emode == 2;
        if ddf>0;
          pvs=cdfchic(sargan,ddf);
          str = ftos(ddf,"Instrument validity chi2(%*.*lf",1,0) $+
            ftos(sargan,"): %*.*lf",12,5) $+
            ftos(pvs,"     P-value: %*.*lf",12,5);
          print str;
        endif;
      endif;
    endif;
    if __output and emode == 4 and iy == ny;
      print;
      print "Residual variance-covariance matrix";
      print ww;
      wc=corrvc(ww);
      print;
      print "Residual correlation matrix";
      print wc;
    endif;
    iy = iy+1;
    if __output;
      print;print;print;
    endif;
  endo;
  retp(b,stdest,vc,df,u);
endp;
                                     @                           @
proc (0) = wald1(bb,vc,df,nx,vnam);  @  equation (30) Wald tests @
                                     @                           @
  local bigr,dfm,fmt,mask,nr,nvar,nx31,nx32,nx41,nx42,omat,pvt,pvw,
    res,rvr,rvri,smallr,sr,str,t,wald,nb22,bb3,nxm;
  nr=5;
  nvar=sumc(nx);
  nxm=maxc(nx);
  bigr=zeros(5,nvar);
  smallr= 0|1|zeros(nxm-2,1);
  res = trimr(bb[.,4] - bb[2,2].*bb[.,3] - smallr,1,nxm-nr-1);
  nx31 = nx[1]+nx[2]+2;
  nx32 = nx[1]+nx[2]+nr+1;
  bigr[.,nx31:nx32] = - bb[2,2]*eye(nr);
  nx41 = nx[1]+nx[2]+nx[3]+2;
  nx42 = nx[1]+nx[2]+nx[3]+nr+1;
  bigr[.,nx41:nx42] = eye(nr);
  nb22 = nx[1]+2;
  bigr[.,nb22] = - bb[2:nr+1,3];
  rvr = bigr*vc*bigr';
  sr = sqrt(diag(rvr));
  t = res./sr;
  dfm = minc(df);
  pvt = 2*cdftc(abs(t),dfm);
  rvri=invpd(rvr);
  wald = res'*rvri*res;
  pvw=cdfchic(wald,nr);
  if __output;
    print;
    print "Equation (30) retrictions ";;
    print;
    print "                         Standard                 Prob";
    print "Variable     Estimate      Error      t-value     >|t|";
    print "-------------------------------------------------------";
    omat = trimr(vnam,1,0)~res~sr~t~pvt;
    mask = 0~1~1~1~1;
    let fmt[5,3] = "-*.*s" 9 8 "*.*lf" 12 6 "*.*lf" 12 6 "*.*lf" 12 6 ""\
      "*.*lf" 10 3 ;
    call printfm(omat,mask,fmt);
    print;
    str = ftos(nr,"Wald test chi2(%*.*lf",1,0) $+
      ftos(wald,"): %*.*lf",12,5) $+ ftos(pvw,"     P-value: %*.*lf",12,5);
    print str;
    print;print;print;
  endif;
  retp;
endp;
@                           @
@  Equation (32) Wald tests @
@                           @
proc (1) = wald2(bb,theta,phi,gmma,vc,nx,df,vnam);
  local bbg,bbphi,bbpp,bphi,bphj,bt1,bt2,dfm,eta,etab,fmt,mask,pvteta,enam,
    nr,nxx,nx3,nx4,omat,pvt,pvw,r,res,reta,rvr,rvri,seta,sr,str,t,teta,wald;
  nr=4;
  nxx = sumc(nx);
  res = zeros(4,1);
  bphi = bb[2,3]*phi[1,1] + bb[3,3]*phi[2,1] -1;
  bphj = bb[2,3]*phi[1,2] + bb[3,3]*phi[2,2];
  bbphi = bphi*bb[2,3];
  bt1 = bb[2,3]*theta[1,2] + bb[3,3]*theta[2,2];
  bt2 = bb[2,3]*theta[1,3] + bb[3,3]*theta[2,3] +bb[4,3] + bb[5,3];
  bbg = bb[6,3]*(1+gmma[2,3])-1;
  bbpp = bphi+bb[2,3]*phi[1,1];
  res[1] = bb[3,4]/bb[2,4] - bb[3,3]/bb[2,3] - bt1/bbphi;
  res[2] = bb[4,4]/bb[2,4] - bb[4,3]/bb[2,3] - bt2/bbphi;
  res[3] = bb[5,4]/bb[2,4] - bb[5,3]/bb[2,3] + bb[4,3]*gmma[2,2]/bbphi;
  res[4] = bb[6,4]/bb[2,4] - bb[6,3]/bb[2,3] - bbg/bbphi;
  r = zeros(nxx,nr);
  reta = zeros(nxx,1);
  nx3 = nx[1]+nx[2];
  nx4 = nx3+nx[3];
  r[nx3+2,1] = (bb[2,3]*bt1*phi[1,1] + bb[3,3]*bphi*(bphi+theta[2,2]))
    /(bbphi^2);
  r[nx3+3,1] = (bt1*phi[1,2] - bphi*(bphi+theta[2,2]))/(bbphi*bphi);
  r[nx4+2,1] = - bb[3,4]/(bb[2,4]^2);
  r[nx4+3,1] = 1/bb[2,4];
  r[nx3+2,2] = (bt2*bb[2,3]*phi[1,1] + (bt2-bb[2,3]*theta[1,3])*bphi
   + bbphi*bphi)/(bbphi^2);
  r[nx3+3,2] = - (bt2*phi[1,2] + theta[2,3]*bphi)/(bbphi*bphi);
  r[nx3+4,2] = - (bphi+1)/bbphi;
  r[nx3+5,2] = - 1/bbphi;
  r[nx4+2,2] = - bb[4,4]/(bb[2,4]^2);
  r[nx4+4,2] = 1/bb[2,4];
  r[nx3+2,3] = (bb[5,3]*bphi^2 - bb[4,3]*gmma[2,2]*bbpp)/(bbphi^2);
  r[nx3+3,3] = - bb[4,3]*gmma[2,2]*phi[1,2]/(bphi*bbphi);
  r[nx3+4,3] = gmma[2,2]/bbphi;
  r[nx3+5,3] = -1/bb[2,3];
  r[nx4+2,3] = - bb[5,4]/(bb[2,4]^2);
  r[nx4+5,3] = 1/bb[2,4];
  r[nx3+2,4] = (bb[6,3]*bphi^2 +bbg*bbpp)/(bbphi^2);
  r[nx3+3,4] = bbg*phi[1,2]/(bphi*bbphi);
  r[nx3+6,4] = - (bphi+gmma[2,3]+1)/bbphi;
  r[nx4+2,4] = - bb[6,4]/(bb[2,4]^2);
  r[nx4+6,4] = 1/bb[2,4];
  eta = bb[2,4]/(bb[2,3]*bphi+bb[2,4]*bphj);
  etab = (eta^2)/bb[2,4];
  reta[nx3+2] = - etab*((1/bphi)+(1/bbphi)+(1/(bb[2,4]*phi[1,2])));
  reta[nx3+3] = - etab*((1/(bb[2,3]*phi[1,2]))+(1/(bb[2,4]*phi[2,2])));
  reta[nx4+2] = eta/bb[2,4] - etab/bphj;
  rvr = r'*vc*r;
  sr = sqrt(diag(rvr));
  t = res./sr;
  dfm = minc(df);
  pvt = 2*cdftc(abs(t),dfm);
  rvri=invpd(rvr);
  wald = res'*rvri*res;
  pvw=cdfchic(wald,nr);
  seta = sqrt(reta'*vc*reta);
  teta = eta/seta;
  pvteta = 2*cdftc(abs(teta),dfm);
  let enam = eta;
  if __output;
    print;
    print "Equation (32) retrictions";
    print;
    print "                         Standard                 Prob";
    print "Variable     Estimate      Error      t-value     >|t|";
    print "-------------------------------------------------------";
    omat = trimr(vnam,2,0)~res~sr~t~pvt;
    mask = 0~1~1~1~1;
    let fmt[5,3] = "-*.*s" 9 8 "*.*lf" 12 6 "*.*lf" 12 6 "*.*lf" 12 6 ""\
      "*.*lf" 10 3 ;
    call printfm(omat,mask,fmt);
    print;
    str = ftos(nr,"Wald test chi2(%*.*lf",1,0) $+
      ftos(wald,"): %*.*lf",12,5) $+ ftos(pvw,"     P-value: %*.*lf",12,5);
    print str;
    print;
    print "Implied value of eta";
    omat = enam~eta~seta~teta~pvteta;
    call printfm(omat,mask,fmt);
    print;print;print;
  endif;
  retp(eta);
endp;
@ @
@ nonlinear equation solution @
@ @
proc(1) = ainv(aa0,ha,ja,ka,theta,phi);
  aa = inv(ha-ja*aa0*phi)*(ka+ja*aa0*theta);
  retp(aa);
endp;
@ @
@  z transformations @
@ @
proc z1z2(b);
  local nobs,qq,z;
  nobs = rows(xx);
  z = zeros(nobs,2);
  qq = xx[.,1]-b[2,2]*(xx[.,7]-psbar[1]*xx[.,12]);
  z[.,1] = qq - xx[.,2]+xx[.,5] +
     xlag(xx[.,3],1)+xlag(xx[.,4],1) - (psbar[2]+psbar[3])*xx[.,12];
  z[.,2] = qq + xx[.,5] - (b[1,1]+b[2,1]*xcbar[2]+b[4,1]*xcbar[4])*xx[.,12]
     - b[3,1]*xx[.,10];
  retp(z);
endp;
@                       @
@  main program resumes @
@                       @
@  consumption equation @
@                       @
nobs = rows(xx)-2;
print;print;print;
icn=icn+1;
yc=trimr(xx[.,2],2,0);
xc=trimr((xx[.,12]~xlag(xx[.,7],1)~xx[.,10]~xlag(xx[.,6],1)),2,0);
let cnam= constant lrpx1 cip cnstr1;
{bc,sec,vc,df,uc} = lsiv(yc,xc,0,0,dnam[1],cnam,0,1);
xcbar=meanc(xc);
@                      @
@  production equation @
@                      @
icn=icn+1;
stox=xx[.,3]+xx[.,4];
d1=(zeros(22,1)|ones(6,1));
dlexr=xx[.,8]-xlag(xx[.,8],1);
dlexr[27] = -0.0076;
dlexr[28] = -0.0318;
qcm=xlag(xx[.,1],1)-xx[.,2]+xlag(xx[.,5],1)+0.014395*d1;
dprod = xx[.,1] - xlag(xx[.,1],1);
yq=trimr(dprod,2,0);
xq=trimr((xx[.,12]~xx[.,7]~qcm~xlag(stox,1)),2,0);
let qnam = constant lrpx qcm stox1;
call lsiv(yq,xq,0,0,dnam[2],qnam,0,1);
@                @
@  iv estimation @
@                @
icn=icn+1;
zz=trimr((xlag(xx[.,1],1)~xx[.,10]~xlag((xx[.,5]+0.014395*d1),1)
   ~xlag(xx[.,6],1)~xlag(xx[.,6],2)~xlag(stox,1)
   ~xlag(xx[.,7],1)~dlexr~xlag(xx[.,11],1)~xx[.,12]),2,0);
let znam= prod1 cip E1nimps cnstr1 cnstr2 stox1 lrpx1 dlexr rr1 constant;
{bq,seq,vc,df,uq} = lsiv(yq,xq,zz,0,dnam[2],qnam,znam,2);
@                                       @
@  ip,  construction and rr regressions @
@                                       @
icn=icn+1;
gmma = zeros(2,3);
yip = trimr(xx[.,10]-xlag(xx[.,6],1),2,0);
d3 = zeros(21,1)|ones(5,1);
xip = ones(26,1)~d3;
let ipnam = cip;
let d3nam = constant d3;
{gmma[.,1],s,vc,df,ug1} = lsiv(yip,xip,0,0,ipnam,d3nam,0,1);
icn=icn+1;
ycn = trimr(xx[.,6]-xlag(xx[.,6],1),2,0);
xcn = trimr(xx[.,12]~xlag(xx[.,6],2),2,0);
let cnnam = cnstr;
let xcnnam = constant cnstr2;
{gmma[.,2],s,vc,df,ug2} = lsiv(ycn,xcn,0,0,cnnam,xcnnam,0,1);
icn=icn+1;
yrr = trimr(xx[.,11]-xlag(xx[.,11],1),2,0);
xrr = trimr(xx[.,12]~xlag(xx[.,11],1),2,0);
let rnam = rr;
let xrnam = constant rr1;
{gmma[.,3],s,vc,df,ug3} = lsiv(yrr,xrr,0,0,rnam,xrnam,0,1);
@                    @
@  set theta and phi @
@                    @
theta = zeros(5,5);
phi = zeros(5,2);
theta[1,2] = 1-bq[2];
theta[1,3] = theta[1,2]*bc[4]*(1+gmma[2,2]);
theta[2,2] = 1-bq[2];
theta[3,3] = 1;
theta[3,4] = gmma[2,2];
theta[4,3] = 1;
theta[5,5] = 1+gmma[2,3];
phi[1,1] = theta[1,2]*(bq[2]-bc[2]);
phi[1,2] = theta[1,2];
phi[2,1] = theta[2,2]*bq[2] - bc[2]*bq[3];
phi[2,2] = bq[4];
@                            @
@  price and stock equations @
@                            @
pss=trimr((xx[.,7]~xx[.,3]~xx[.,4]),2,0);
psbar=meanc(pss);
nxm=6;
b4 = (bc|zeros(nxm-4,1))~(bq|zeros(nxm-4,1))~zeros(nxm,2);
z = z1z2(b4);
lrpxx=xx[.,7]-0.85*dlexr;
yp=trimr(lrpxx,2,0);
xp=trimr(xx[.,12]~z[.,1]~z[.,2]~xlag(xx[.,6],1)~xlag(xx[.,6],2)~xx[.,11],2,0);
let pnam = constant z1 z2 cnstr1 cnstr2 rr;
ys=trimr(stox,2,0);
xs=trimr((xx[.,12]~z[.,1]~z[.,2]~xlag(xx[.,6],1)~xlag(xx[.,6],2)~xx[.,11]),2,0);
let snam = constant z1 z2 cnstr1 cnstr2 rr;
icn=icn+1;
call lsiv(yp,xp,0,0,dnam[3],pnam,0,1);
icn=icn+1;
{bp,sep,vc,df,up} = lsiv(yp,xp,zz,0,dnam[3],pnam,znam,2);
icn=icn+1;
call lsiv(ys,xs,0,0,dnam[4],snam,0,1);
icn=icn+1;
{bs,ses,vc,df,us} = lsiv(ys,xs,zz,0,dnam[4],snam,znam,2);
b4[.,3:4]=bp~bs;
z = z1z2(b4);
xp[.,2:3]=trimr(z,2,0);
xs[.,2:3]=trimr(z,2,0);
theta[1,2] = 1-bq[2]/2;
theta[1,3] = theta[1,2]*bc[4]*(1+gmma[2,2]);
phi[1,1] = theta[1,2]*(bq[2]-bc[2]);
phi[1,2] = theta[1,2];
@                    @
@  4 equation system @
@                    @
icn=icn+1;
y4 = yc~yq~yp~ys;
x4=xc~xq~xp~xs;
@                        @
@  Error variance matrix @
@                        @
w = zeros(4,4);
rho = (up'*us)/sqrt((up'*up)*(us'*us));
cps = rho*sep*ses;
wd = sec^2|seq^2|sep^2|ses^2;
w = diagrv(w,wd);
w[3,4] = cps;
w[4,3] = cps;
wd0 = wd|cps;
wi = invpd(w);                                           @ W-1 @
@ @
s4nam = cnam|qnam|pnam|snam;
nx=cols(xc)|cols(xq)|cols(xp)|cols(xs);
{b4,s4,vc4,df4,u} = lsiv(y4,x4,zz,nx,dnam,s4nam,znam,4);
call wald1(b4,vc4,df4[3],nx,pnam);
eta = wald2(b4,theta,phi,gmma,vc4,nx,df4[3],pnam);
@                         @
@ nonlinear least squares @
@ restricted model        @
@                         @
ha = (1~-1/b4[2,2])|(eta~1);
ja = (0~0)|(eta~0);
ka = zeros(2,5);
ka[1,1] = -1/b4[2,2];
ka[2,5] = -eta;
aa0 = trimr(b4[.,3:4],1,rows(b4)-6)';
j = 1;
do until j==26;
  aa = ainv(aa0,ha,ja,ka,theta,phi);
  aa0=aa;
  j=j+1;
endo;
a0=zeros(11,1);
a0[1:9]=b0[1:9];
a0[10]=b0[15];
a0[11]=eta;
icn=icn+1;
imax=2;
jit = 1;
do until jit==26;
  {b4,s4,vc4,df4,u} = lsiv(y4,x4,zz,nx,dnam,s4nam,znam,6);
  wd = diag(u'u);
  cps = u[.,3]'*u[.,4];
  rho = cps/sqrt(wd[3]*wd[4]);
  print "Iteration ";;
  print jit;;
  print "        rho = ";;
  print rho;
  print;
  icn = icn+1;
  wd = wd./df4;
  cps = cps/df4[3];
  if maxc(abs((wd|cps)-wd0)) < .001*maxc(wd0);
    goto wconv;
  endif;
  wd0 = wd|cps;
  w = diagrv(w,wd);
  w[3,4] = cps;
  w[4,3] = cps;
  wi = invpd(w);
  jit = jit+1;
endo;
print;
print "Iteration convergence failure ";
print;
wconv:
call sclm(u,s4,zz);
zz2 = zz^2;
call hetlm(u,s4,zz2,0);
y4h2 = (y4-u)^2;
call hetlm(u,s4,y4h2,1);
@                      @
@  derestricted models @
@                      @
icn=icn+1;
imax=0;
a0=b0;
{b4,s4,vc4,df4,u} = lsiv(y4,x4,zz,nx,dnam,s4nam,znam,5);
a0=b0[1:15];
icn=icn+1;
imax=1;
call lsiv(y4,x4,zz,nx,dnam,s4nam,znam,5);
icn=icn+1;
call sclm(u,s4,zz);
call hetlm(u,s4,zz2,0);
y4h2 = (y4-u)^2;
call hetlm(u,s4,y4h2,1);
l1 = 2*(f1-f0);
pvl1 = cdfchic(l1,5);
print "Likelihood ratio against unrestricted model X2(5) = ";;
print l1;
print "    Probability value ";;
print pvl1;
print;
l20 = 2*(f2-f0);
l21 = 2*(f2-f1);
pvl20 = cdfchic(l20,9);
pvl21 = cdfchic(l21,4);
print "Likelihood ratio against unrestricted model X2(9) = ";;
print l20;
print "    Probability value ";;
print pvl20;
print;
print "Likelihood ratio against partially restricted model X2(4) = ";;
print l21;
print "    Probability value ";;
print pvl21;
print;
@ @
closeall;
end;
@ @
@ minimization function @
@ @
proc fct(a);
  local aa,b,eta,ha,j,ja,ka,lamda,nobs,nx1,nx2,nxm,val,z,zu,
    ij,iwd,j1,j2;
  nobs=rows(y4);
  nxm=maxc(nx);
  if imax == 0;
    b=(a[1:4]|zeros(nxm-4,1))~(a[5:8]|zeros(nxm-4,1))~a[9:14]~a[15:20];
    iwd=21;
  elseif imax == 1;
    b=(a[1:4]|zeros(nxm-4,1))~(a[5:8]|zeros(nxm-4,1))~a[9:14]~zeros(nxm,1);
    b[1,4]=a[15];
    b[2:6,4]=a[6]*b[2:6,3];
    b[2,4]=b[2,4]+1;
    iwd = 16;
  else;
    b=(a[1:4]|zeros(nxm-4,1))~(a[5:8]|zeros(nxm-4,1))~zeros(nxm,2);
    b[1,3]=a[9];
    b[1,4]=a[10];
    eta=a[11];
    lamda=1/a[6];
    ha = (1~-lamda)|(eta~1);
    ja = (0~0)|(eta~0);
    ka = zeros(2,5);
    ka[1,1] = -lamda;
    ka[2,5] = -eta;
    theta[1,2] = 1-a[6];
    theta[1,3] = theta[1,2]*a[4]*(1+gmma[2,2]);
    theta[2,2] = 1-a[6];
    phi[1,1] = theta[1,2]*(a[6]-a[2]);
    phi[1,2] = theta[1,2];
    phi[2,1] = theta[2,2]*a[6] - a[2]*a[7];
    phi[2,2] = a[8];
    j=1;
    do until j==26;
      aa = ainv(aa0,ha,ja,ka,theta,phi);
      aa0=aa;
      j=j+1;
    endo;
    b[2:6,3:4]=aa';
    z = trimr(z1z2(b),2,0);
    x4[.,10:11] = z;
    x4[.,16:17] = z;
    iwd=12;
  endif;
  u = zeros(nobs,4);
  j=1;
  nx1=1;
  do while j<=4;
    nx2=nx1+nx[j]-1;
    u[.,j]=y4[.,j]-x4[.,nx1:nx2]*trimr(b[.,j],0,nxm-nx[j]);
    j=j+1;
    nx1=nx2+1;
  endo;
  zu=zz'*u;
  val = sumc(diag((zu'*czzi*zu).*diag(wi)))
    + 2*(zu[.,3]'*czzi*zu[.,4])*wi[3,4];
  retp(val);
endp;
@                             @
@  LM heteroscedasticity test @
@                             @
proc(0) = hetlm(u,s,z,mode);
  local chlm,fmt,hlm,j,kz,mask,nobs,omat,r,zj,zr,zz,zzi;
  nobs = rows(u);
  r = (u^2)./(s^2)'-ones(nobs,4);
  if mode==0;
    zr = z'*r;
    zz = z'*z;
    zzi = invpd(zz);
    hlm = diag(zr'*zzi*zr)./2;
    kz = ones(4,1).*(cols(z)-1);
  else;
    hlm = zeros(4,1);
    j = 1;
    do until j==5;
      zj = ones(nobs,1)~z[.,j];
      zr = zj'*r[.,j];
      zz = zj'*zj;
      zzi = invpd(zz);
      hlm[j] =zr'*zzi*zr/2;
      j = j+1;
    endo;
    kz = ones(4,1);
  endif;
  chlm = cdfchic(hlm,kz);
  print;
  print "LM heteroscesticity tests ";
  print;
  print "Variable          chi2(";;
  print kz[1];;
  print ")           P-value";
  omat = dnam~hlm~chlm;
  mask = 0~1~1;
  let fmt[3,3] = "-*.*s" 9 8 "*.*lf" 25 4 "*.*lf" 18 5;
  call printfm(omat,mask,fmt);
  print;
endp;
@                                 @
@  LM test for serial correlation @
@                                 @
proc(0) = sclm(u,s,z);
  local clm,j,rj,rj1,rrj,lm,xj,xx,xxi,omat,mask,fmt;
  lm = zeros(4,1);
  j = 1;
  do until j==5;
    rj = u[.,j];
    rj1 = xlag(rj,1);
    xj = rj1~z;
    rrj = rj'*rj1;
    xx = xj'*xj;
    xxi = invpd(xx);
    lm[j] = (rrj^2)*xxi[1,1]/(s[j]^2);
    j = j+1;
  endo;
  clm = cdfchic(lm,ones(4,1));
  print;
  print "LM serial correlation tests ";
  print;
  print "Variable                  chi2(1)           P-value";
  omat = dnam~lm~clm;
  mask = 0~1~1;
  let fmt[3,3] = "-*.*s" 9 8 "*.*lf" 25 4 "*.*lf" 18 5;
  call printfm(omat,mask,fmt);
  print;
endp;
@                                               @
@  gradient function for fully restricted model @
@                                               @
proc gct6(a);
  local aa,b,eta,ha,ja,ka,lamda;
  b = zeros(20,1);
  b[1:9] = a[1:9];
  b[15] = a[10];
  eta = a[11];
  lamda = 1/a[6];
  ha = (1~-lamda)|(eta~1);
  ja = (0~0)|(eta~0);
  ka = zeros(2,5);
  ka[1,1] = -lamda;
  ka[2,5] = -eta;
  theta[1,2] = 1-a[6];
  theta[1,3] = theta[1,2]*a[4]*(1+gmma[2,2]);
  theta[2,2] = 1-a[6];
  phi[1,1] = theta[1,2]*(a[6]-a[2]);
  phi[1,2] = theta[1,2];
  phi[2,1] = theta[2,2]*a[6] - a[2]*a[7];
  phi[2,2] = a[8];
  j=1;
  do until j==26;
    aa = ainv(aa0,ha,ja,ka,theta,phi);
    aa0=aa;
    j=j+1;
  endo;
  b[10:14] = aa[1,.]';
  b[16:20] = aa[2,.]';
  retp(b);
endp;
@                                                   @
@  gradient function for partially restricted model @
@                                                   @
proc gct5(a);
  local b;
  b = zeros(20,1);
  b[1:15] = a[1:15];
  b[16:20] = a[10:14].*a[6];
  b[16] = b[16]+1;
  retp(b);
endp;
@                                              @
@  standard errors for Guass-Newton regression @
@                                              @
proc ivse(v,w,z);
  local cvz,czuuz,czwz,czwzi,i1,i2,j1,j2,j3,j4,nobs,ny,nz,s,svzzv,svzzvi,zk,
    scf,h;
  nobs = rows(z);
  ny = cols(w);
  nz = cols(z);
  zk = eye(ny).*.z;
  cvz = v'*zk;
  czwz = w.*.(z'*z);                            @ Z'W-1Z           @
  czwzi = invpd(czwz);                          @ (Z'W-1Z)-1       @
  svzzv = cvz*czwzi*cvz';
  svzzvi = invpd(svzzv);                        @ V'Z(Z'W-1Z)-1Z'V @
  if ise==2;
    czuuz = zeros(ny*nz,ny*nz);
    h = u;
    j1 = 1;
    do until j1==ny+1;
      i1 = (j1-1)*nobs+1;
      i2 = j1*nobs;
      scf = ones(nobs,1)./(ones(nobs,1)-dv[i1:i2]);
      h[.,j1] = u[.,j1].*scf;
      j1 = j1+1;
    endo;
    i1 = 1;
    do until i1==ny+1;
      j1 = (i1-1)*nz+1;
      j2 = i1*nz;
      i2 = 1;
      do until i2==ny+1;
        j3 = (i2-1)*nz+1;
        j4 = i2*nz;
        czuuz[j1:j2,j3:j4] = z'*diagrv(eye(nobs),diag(h[.,i1]*h[.,i2]'))*z;
        i2 = i2+1;
      endo;                                    @ Z'UU'Z            @
      i1 = i1+1;
    endo;
    s = svzzvi*cvz*czwzi*czuuz*czwzi*cvz'*svzzvi;
                                                @ robust s.e.s     @
  else;
    s = svzzvi;
  endif;
  retp(s);
endp;

