% fig6_9.m
%
% Program for:
% Marc Giannoni "Robust Optimal Monetary Policy in a Forward-Looking Model 
% with Parameter and Shock Uncertainty" in Journal of Applied Econometrics.
%
% Program generates figures 6-9.
% Plot of various statistics for baseline rule and robust rule, as function
% of structural parameters, evaluated at baseline parameters
%
% Function needed: opl2f.m
% Last revision: December 2005.
 
% *****************************************************************
% [0] Plot of following statistic
% *****************************************************************

st = 'EL';

% Statistics:
% figure 6: EL
% figure 7: Vpi
% figure 8: Vx
% figure 9: Vi

% *****************************************************************
% [1] Input b, r, k, s
% *****************************************************************

% Parameters in baseline model:
b  = .99;       % beta
s0 = .1571;     % sigma
a  = .66;       % alpha
g  = .6314; 	% gamma
k0 = .0238; 	% kappa
w0  = .4729; 	% omega
t  = (1-a*b)*(1-a)*(w0+s0)/(a*k0*w0) - 1/w0;	% theta
lx = k0/t;      % LAMBDA, RW(97,98)
li = .236405;
r0 = 0.35;      % rho
nu0 = 0.5;      % nu

clear a g t


% 95% intervals for sigma and kappa (Amato and Laubach)
ses = .0328;  % estimated standard error for sigma
sek = .0035;  % estimated standard error for kappa
sew = .0946;  % estimated standard error for omega (20%)

sl = max(s0-2*ses, 0);	% lower bound for s
sh = s0+2*ses;		% upper bound for s
kl = max(k0-2*sek, 0);	% lower bound for k
kh = k0+2*sek;		% upper bound for k
wl = max(w0-2*sew, 0);	% lower bound for w
wh = w0+2*sew;		% upper bound for w
rdl = 0;				% lower bound for rho
rdh = 0.8;				% upper bound for rho
rel = 0;				% lower bound for rho
reh = 0.8;				% upper bound for rho
rml = 0;				% lower bound for rho
rmh = 0.8;				% upper bound for rho
rl = 0;
rh = 0.8;
nul = 0;
nuh = 1;

%disp(' ')
%disp('Parameters of candidate minmax equilibrium')
sm = sl; %input('s (sl, s0, sh) = ');
km = kh; %input('k (kl, k0, kh) = ');
wm = wl; %input('w (wl, w0, wh) = ');
rdm = rh;
rem = rh;
rmm = rh;
num = 1;

% Coefficients of optimal baseline rule
psipi0 = k0/(li*s0);
psiDx0 = lx/(li*s0);
psii0  = 1+k0/(b*s0)+1/b;

% Coefficients of robust policy rule
psipiu = km/(li*sm);
psiDxu = lx/(li*sm);
psiiu  = 1+km/(b*sm)+1/b;

output=0;


k_ser = [kl:(kh-kl)/25:kh]; 
s_ser = [sl:(sh-sl)/25:sh]; 
w_ser = [wl:(wh-wl)/25:wh]; 
rd_ser = [rl:(rh-rl)/25:rh]; 
re_ser = [rl:(rh-rl)/25:rh]; 
rm_ser = [rl:(rh-rl)/25:rh]; 
nu_ser = [0:1/25:1]; 

% Initializing matrices of statistics

matr = ['s00 '; 'su0 ';'s0m ';'sum ';'k00 '; 'ku0 ';'k0m ';'kum '; ...
        'w00 '; 'wu0 ';'w0m ';'wum ';'nu00'; 'nuu0';'nu0m';'nuum'; ...
        'rd00'; 'rdu0';'rd0m';'rdum';'re00'; 'reu0';'re0m';'reum'; ...
        'rm00'; 'rmu0';'rm0m';'rmum'];

for i = 1:size(matr,1)
	eval(['Vi' matr(i,:), '= zeros(1, size(k_ser,2));'])
	eval(['Vpi' matr(i,:), '= zeros(1, size(k_ser,2));'])
	eval(['Vx' matr(i,:), '= zeros(1, size(k_ser,2));'])
	eval(['EL' matr(i,:), '= zeros(1, size(k_ser,2));'])
end

% ****************************************************************
% [2] Perform the loops on various parameters to compute E[L_0]
% ****************************************************************

i = 1;
for s = s_ser

   [Vis00(i), Vpis00(i), Vxs00(i), ELs00(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k0, s, w0, r0, r0, r0, nu0, 0);
   
   [Visu0(i), Vpisu0(i), Vxsu0(i), ELsu0(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k0, s, w0, r0, r0, r0, nu0, 0);
   
   [Vis0m(i), Vpis0m(i), Vxs0m(i), ELs0m(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, km, s, wm, rdm, rem, rmm, num, 0);
   
   [Visum(i), Vpisum(i), Vxsum(i), ELsum(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, km, s, wm, rdm, rem, rmm, num, 0); 

      i = i + 1;
end

i = 1;
for k = k_ser

   [Vik00(i), Vpik00(i), Vxk00(i), ELk00(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k, s0, w0, r0, r0, r0, nu0, 0);
   
   [Viku0(i), Vpiku0(i), Vxku0(i), ELku0(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k, s0, w0, r0, r0, r0, nu0, 0);
   
   [Vik0m(i), Vpik0m(i), Vxk0m(i), ELk0m(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k, sm, wm, rdm, rem, rmm, num, 0);
   
   [Vikum(i), Vpikum(i), Vxkum(i), ELkum(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k, sm, wm, rdm, rem, rmm, num, 0); 
  
   i = i + 1;
end

i = 1;
for w = w_ser

   [Viw00(i), Vpiw00(i), Vxw00(i), ELw00(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k0, s0, w, r0, r0, r0, nu0, 0);
   
   [Viwu0(i), Vpiwu0(i), Vxwu0(i), ELwu0(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k0, s0, w, r0, r0, r0, nu0, 0);
   
   [Viw0m(i), Vpiw0m(i), Vxw0m(i), ELw0m(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, km, sm, w, rdm, rem, rmm, num, 0);
   
   [Viwum(i), Vpiwum(i), Vxwum(i), ELwum(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, km, sm, w, rdm, rem, rmm, num, 0); 
    
   i = i + 1;
end

i = 1;
for nu = nu_ser

   [Vinu00(i), Vpinu00(i), Vxnu00(i), ELnu00(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k0, s0, w0, r0, r0, r0, nu, 0);
   
   [Vinuu0(i), Vpinuu0(i), Vxnuu0(i), ELnuu0(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k0, s0, w0, r0, r0, r0, nu, 0);
   
   [Vinu0m(i), Vpinu0m(i), Vxnu0m(i), ELnu0m(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, km, sm, wm, rdm, rem, rmm, nu, 0);
   
   [Vinuum(i), Vpinuum(i), Vxnuum(i), ELnuum(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, km, sm, wm, rdm, rem, rmm, nu, 0); 

  i = i + 1;
end

i = 1;
for rd = rd_ser

   [Vird00(i), Vpird00(i), Vxrd00(i), ELrd00(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k0, s0, w0, rd, r0, r0, nu0, 0);
   
   [Virdu0(i), Vpirdu0(i), Vxrdu0(i), ELrdu0(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k0, s0, w0, rd, r0, r0, nu0, 0);
   
   [Vird0m(i), Vpird0m(i), Vxrd0m(i), ELrd0m(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, km, sm, wm, rd, rem, rmm, num, 0);
   
   [Virdum(i), Vpirdum(i), Vxrdum(i), ELrdum(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, km, sm, wm, rd, rem, rmm, num, 0); 

  i = i + 1;
end

i = 1;
for re = re_ser

   [Vire00(i), Vpire00(i), Vxre00(i), ELre00(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k0, s0, w0, r0, re, r0, nu0, 0);
   
   [Vireu0(i), Vpireu0(i), Vxreu0(i), ELreu0(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k0, s0, w0, r0, re, r0, nu0, 0);
   
   [Vire0m(i), Vpire0m(i), Vxre0m(i), ELre0m(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, km, sm, wm, rdm, re, rmm, num, 0);
   
   [Vireum(i), Vpireum(i), Vxreum(i), ELreum(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, km, sm, wm, rdm, re, rmm, num, 0); 

  i = i + 1;
end

i = 1;
for rm = rm_ser

   [Virm00(i), Vpirm00(i), Vxrm00(i), ELrm00(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, k0, s0, w0, r0, r0, rm, nu0, 0);
   
   [Virmu0(i), Vpirmu0(i), Vxrmu0(i), ELrmu0(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, k0, s0, w0, r0, r0, rm, nu0, 0);
   
   [Virm0m(i), Vpirm0m(i), Vxrm0m(i), ELrm0m(i), NUE] ...
      = opl2f(psipi0, psiDx0, psii0, km, sm, wm, rdm, rem, rm, num, 0);
   
   [Virmum(i), Vpirmum(i), Vxrmum(i), ELrmum(i), NUE] ...
      = opl2f(psipiu, psiDxu, psiiu, km, sm, wm, rdm, rem, rm, num, 0); 

   i = i + 1;
end


% ****************************************************************
% [3] Check for magnitude of imaginary component and suppress it.
%     (Warning message if large)
% ****************************************************************

for i = 1:size(matr,1)
	if max(max(abs(imag( eval(['EL' matr(i,:)]) )))) > .0000001
		disp(['Maximum imaginary component of EL', matr(i,:), ...
		' is ', num2str(max(max(abs(imag( eval(['EL' matr(i,:)]) ))))) ])
	end
	eval(['EL' matr(i,:), '= real(EL', matr(i,:), ');']);
end


% ****************************************************************
% [4] Plots
% ****************************************************************

figure ('Name', [st 'with optimal rules']) %'PaperPosition', [.5, 2.75, 7.5, 5.5])

n= 321;
   par = 's';
   subplot(n), eval(['plot(' par '_ser,' st par '00, ''-'', ' ...
        par '_ser,' st par 'u0, '':'', ' ...
        par '_ser,' st par '0m, ''--'', ' ...
        par '_ser,' st par 'um, ''-.'')']) 
   xlabel('\sigma')
   eval(['set(gca, ''Xlim'', [' par 'l, ' par 'h])'])
    n=n+1;

   par = 'k';
   subplot(n), eval(['plot(' par '_ser,' st par '00, ''-'', ' ...
        par '_ser,' st par 'u0, '':'', ' ...
        par '_ser,' st par '0m, ''--'', ' ...
        par '_ser,' st par 'um, ''-.'')']) 
   xlabel('\kappa')
   eval(['set(gca, ''Xlim'', [' par 'l, ' par 'h])'])
   n=n+1;

   par = 'w';
   subplot(n), eval(['plot(' par '_ser,' st par '00, ''-'', ' ...
        par '_ser,' st par 'u0, '':'', ' ...
        par '_ser,' st par '0m, ''--'', ' ...
        par '_ser,' st par 'um, ''-.'')']) 
   xlabel('\omega')
   eval(['set(gca, ''Xlim'', [' par 'l, ' par 'h])'])
   n=n+1;

   par = 'nu';
   subplot(n), eval(['plot(' par '_ser,' st par '00, ''-'', ' ...
        par '_ser,' st par 'u0, '':'', ' ...
        par '_ser,' st par '0m, ''--'', ' ...
        par '_ser,' st par 'um, ''-.'')']) 
   xlabel('\nu')
   eval(['set(gca, ''Xlim'', [' par 'l, ' par 'h])'])
   n=n+1;

   par = 'rd';
   subplot(n), eval(['plot(' par '_ser,' st par '00, ''-'', ' ...
        par '_ser,' st par 'u0, '':'', ' ...
        par '_ser,' st par '0m, ''--'', ' ...
        par '_ser,' st par 'um, ''-.'')']) 
   xlabel('\rho_\delta')
   eval(['set(gca, ''Xlim'', [' par 'l, ' par 'h])'])
   n=n+1;

   par = 'rm';
   subplot(n), eval(['plot(' par '_ser,' st par '00, ''-'', ' ...
        par '_ser,' st par 'u0, '':'', ' ...
        par '_ser,' st par '0m, ''--'', ' ...
        par '_ser,' st par 'um, ''-.'')']) 
   xlabel('\rho_\mu')
   eval(['set(gca, ''Xlim'', [' par 'l, ' par 'h])'])
   legend('(\psi_0, \theta_0)', '(\psi^*, \theta_0)', ...
       '(\psi_0, \theta^*)', '(\psi^*, \theta^*)') % 'Orientation', 'Horizontal')
   n=n+1;
   
% print fig0xx.eps -deps
   

