% fig5.m
%
% Program for:
% Marc Giannoni "Robust Optimal Monetary Policy in a Forward-Looking Model 
% with Parameter and Shock Uncertainty" in Journal of Applied Econometrics.
%
% Program generates figure 5.
% Contour plots of statistics i mplied by robust optimal rule in 
% (kappa, sigma) plane for different parameter configurations (omega,nu,rho). 
%
% Function needed: opl3f.m
%
% Last revision: December 2005.
 
% *****************************************************************
% [1] Input b, r, k, s
% *****************************************************************

% Parameters in baseline model:
b  = .99;       % beta
s0 = .1571;     % sigma
a  = .66;       % alpha
g  = .6314; 	% gamma
k0 = .0238; 	% kappa
w0  = .4729; 	% omega
t  = (1-a*b)*(1-a)*(w0+s0)/(a*k0*w0) - 1/w0;	% theta
lx = k0/t;      % LAMBDA, RW(97,98)
li = .236405;

% 95% intervals for sigma and kappa (Amato and Laubach)
ses = .0328;  % estimated standard error for sigma
sek = .0035;  % estimated standard error for kappa
sew = .0946;  % estimated standard error for omega (20%)

sl = max(s0-2*ses, 0);	% lower bound for s
sh = s0+2*ses;		% upper bound for s
kl = max(k0-2*sek, 0);	% lower bound for k
kh = k0+2*sek;		% upper bound for k
wl = max(w0-2*sew, 0);	% lower bound for w
wh = w0+2*sew;		% upper bound for w

%disp(' ')
%disp('Parameters of candidate minmax equilibrium')
sm = sl; %input('s (sl, s0, sh) = ');
km = kh; %input('k (kl, k0, kh) = ');

% Coefficients of policy rule
psipiu = km/(li*sm);
psix0u = lx/(li*sm);
psix1u = -lx/(li*sm);
psii1u = 1+km/(b*sm)+1/b;
psii2u = -1/b;

% Set parameters
nu = 1; %input('nu = ');
output=0;

k_ser = [kl:(kh-kl)/10:kh]; 
s_ser = [sl:(sh-sl)/10:sh]; 

clear a g t s0 k0

% Initializing matrices of statistics

matr = ['VI ';'VPI';'VX ';'EW1';'EW2';'EW3';'EW4';'EW5';'EW6';
    'EW7';'EW8';'EW9';'NUE'];

for i = 1:size(matr,1)
	eval([matr(i,:), '= zeros(size(s_ser,2), size(k_ser,2));'])
end

% ****************************************************************
% [2] Perform the loops on k and s and compute statistics
% ****************************************************************

ik = 1;

for k = k_ser

	is  = 1;

	for s = s_ser

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW1(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, wl, 0, 0, 0, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW2(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, wl, .35, .35, .35, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW3(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, wl, .8, .8, .8, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW4(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, w0, 0, 0, 0, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW5(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, w0, .35, .35, .35, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW6(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, w0, .8, .8, .8, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW7(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, wh, 0, 0, 0, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW8(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, wh, .35, .35, .35, nu, output);

		[VI(is,ik), VPI(is,ik), VX(is,ik), EW9(is,ik), NUE(is,ik)] ...
		= opl3f(psipiu, psix0u, psix1u, psii1u, psii2u, k, s, wh, .8, .8, .8, nu, output);

		is = is + 1;

	end

	ik = ik + 1;

end

% ****************************************************************
% [3] Check for magnitude of imaginary component and suppress it.
%     (Warning message if large)
% ****************************************************************

for i = 1:size(matr,1)
	if max(max(abs(imag( eval(matr(i,:)) )))) > .0000001
		disp(['Maximum imaginary component of ', matr(i,:), ...
		' is ', num2str(max(max(abs(imag( eval(matr(i,:)) ))))) ])
	end
	eval([matr(i,:), '= real(', matr(i,:), ');']);
end


% ****************************************************************
% [4] Generate the contour plots
% ****************************************************************

% Set the coordinates of grid points
xx = k_ser;
yy = s_ser;

figure('Name', 'E[L_0] with Robust Opt. Rule', 'PaperPosition', [.25, .5, 7.75, 9.75])

% Set the coordinates of grid pointsrop
xx = k_ser;
yy = s_ser;

subplot(331)
    % find coordinates of max of EW
    [m1 i1] = max(EW1);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW1);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(wl) ', \rho = 0'])
    %xlabel('\kappa')
    ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW1(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW1(i1(i2),i2), 'r*')
    hold off

subplot(332)
    % find coordinates of max of EW
    [m1 i1] = max(EW2);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW2);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(wl) ', \rho = 0.35'])
    %xlabel('\kappa')
    %ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW2(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW2(i1(i2),i2), 'r*')
    hold off
   
subplot(333)
    % find coordinates of max of EW
    [m1 i1] = max(EW3);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW3);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(wl) ', \rho = 0.8'])
    %xlabel('\kappa')
    %ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW3(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW3(i1(i2),i2), 'r*')
    hold off

subplot(334)
    % find coordinates of max of EW
    [m1 i1] = max(EW4);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW4);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(w0) ', \rho = 0'])
    %xlabel('\kappa')
    ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW4(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW4(i1(i2),i2), 'r*')
    hold off

subplot(335)
    % find coordinates of max of EW
    [m1 i1] = max(EW5);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW5);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(w0) ', \rho = 0.35'])
    %xlabel('\kappa')
    %ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW5(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW5(i1(i2),i2), 'r*')
    hold off

subplot(336)
    % find coordinates of max of EW
    [m1 i1] = max(EW6);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW6);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(w0) ', \rho = 0.8'])
    %xlabel('\kappa')
    %ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW6(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW6(i1(i2),i2), 'r*')
    hold off

subplot(337)
    % find coordinates of max of EW
    [m1 i1] = max(EW7);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW7);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(wh) ', \rho = 0'])
    xlabel('\kappa')
    ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW7(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW7(i1(i2),i2), 'r*')
    hold off

subplot(338)
    % find coordinates of max of EW
    [m1 i1] = max(EW8);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW8);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(wh) ', \rho = 0.35'])
    xlabel('\kappa')
    %ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW8(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW8(i1(i2),i2), 'r*')
    hold off

subplot(339)
    % find coordinates of max of EW
    [m1 i1] = max(EW9);
    [m2 i2] = max(m1);
    % Plot the contour lines
    [Cons, Conh] = contour(xx, yy, EW9);
    clabel(Cons, Conh, 'FontSize', 8)
    title(['\omega = ' num2str(wh) ', \rho = 0.8'])
    xlabel('\kappa')
    ylabel('\sigma')

    % Draw a * for the baseline parametrization
    hold on
    plot3(.0238, .1571, 0, 'r*')
    plot3(xx(i2), yy(i1(i2)), EW9(i1(i2),i2), 'ro')
    plot3(xx(i2), yy(i1(i2)), EW9(i1(i2),i2), 'r*')
    hold off
    
% print fig05.eps -deps
