% fig4.m
%
% Program for:
% Marc Giannoni "Robust Optimal Monetary Policy in a Forward-Looking Model 
% with Parameter and Shock Uncertainty" in Journal of Applied Econometrics.
%
% Program generates figure 4.
%
% Last revision: December 2005.
 
% *****************************************************************
% [1] Input parameters
% *****************************************************************

s0 = .1571; % sigma
k0 = .0238; % kappa
w0  = .4729;% omega

% 95% intervals for sigma and kappa (Amato and Laubach)
ses = .0328;  % estimated standard error for sigma
sek = .0035;  % estimated standard error for kappa
sew = .0946;  % estimated standard error for omega (20%)

sl = max(s0-2*ses, 0);	% lower bound for s
sh = s0+2*ses;		% upper bound for s
kl = max(k0-2*sek, 0);	% lower bound for k
kh = k0+2*sek;		% upper bound for k
wl = max(w0-2*sew, 0);	% lower bound for w
wh = w0+2*sew;		% upper bound for w

x = -10:2:10;

% *****************************************************************
% [2] Generate figures
% *****************************************************************

% Figure 4a: \delta shock
% =======================

% Parameters of candidate minmax equilibrium
sm = sl;
km = kh;
wm = wh;

IS = -s0*x;
IS1 = -s0*x+w0/(w0+s0);
IS1m = -sm*x+wm/(wm+sm);

AS = k0*x;
ASm = km*x;

axIS = [-4 7 -.2 .8];
axAS = [-4 7 -.05 .1];

figure('PaperPosition', [.5, .5, 10, 7])
subplot(231), plot(x, IS, '-', x, IS1, '-', x, IS1m, '--', ...
	[x(1), x(size(x,2))], [0 0], 'k-', [0 0], [-10 10], 'k-')
	axis(axIS)
	axis off
    text(axIS(2)*1.05,0,'\fontname{times}{\itx_t}','FontSize',10)
    text(0,axIS(4)*1.05,0,'\fontname{times}{\iti_t}','FontSize',10)
    text(0,axIS(4)*1.21,0, ...
        '\fontname{times}{Figure 4a: \delta-shock}','FontSize',12, ...
        'HorizontalAlignment', 'center')

subplot(234), plot(x, AS, '-', x, ASm,'--', ...
	[x(1), x(size(x,2))], [0 0], 'k-', [0 0], [-10 10], 'k-')
	axis(axAS)
	axis off
    text(axAS(2)*1.05,0,'\fontname{times}{\itx_t}','FontSize',10)
    text(0,axAS(4)*1.05,0,'\fontname{times}{\it\pi_t}','FontSize',10)
    
% Figure 4b: \epsilon shock
% =========================

% Parameters of candidate minmax equilibrium
sm = sh;
km = kh;
wm = wl;

IS1b = -s0*x+s0/(w0+s0);
IS1bm = -sm*x+sm/(wm+sm);

subplot(232), plot(x, IS, '-', x, IS1b, '-', x, IS1bm, '--', ...
	[x(1), x(size(x,2))], [0 0], 'k-', [0 0], [-10 10], 'k-')
	axis(axIS)
	axis off
    text(axIS(2)*1.05,0,'\fontname{times}{\itx_t}','FontSize',10)
    text(0,axIS(4)*1.05,0,'\fontname{times}{\iti_t}','FontSize',10)
    text(0,axIS(4)*1.21,0, ...
        '\fontname{times}{Figure 4b: \epsilon-shock}','FontSize',12, ...
        'HorizontalAlignment', 'center')

subplot(235), plot(x, AS, '-', x, ASm,'--', ...
	[x(1), x(size(x,2))], [0 0], 'k-', [0 0], [-10 10], 'k-')
	axis(axAS)
	axis off
    text(axAS(2)*1.05,0,'\fontname{times}{\itx_t}','FontSize',10)
    text(0,axAS(4)*1.05,0,'\fontname{times}{\it\pi_t}','FontSize',10)
    
% Figure 4c: \mu shock
% ====================

% Parameters of candidate minmax equilibrium
sm = sl;
km = kh;
wm = wl;

ISm = -sm*x;

AS1 = k0*(x+1/(w0+s0));
AS1m = km*(x+1/(wm+sm));

subplot(233), plot(x, IS, '-', x, ISm, '--', ...
	[x(1), x(size(x,2))], [0 0], 'k-', [0 0], [-10 10], 'k-')
	axis(axIS)
	axis off
    text(axIS(2)*1.05,0,'\fontname{times}{\itx_t}','FontSize',10)
    text(0,axIS(4)*1.05,0,'\fontname{times}{\iti_t}','FontSize',10)
    text(0,axIS(4)*1.21,0, ...
        '\fontname{times}{Figure 4c: \mu-shock}','FontSize',12, ...
        'HorizontalAlignment', 'center')

subplot(236), plot(x, AS, '-', x, AS1,'-', x, AS1m,'--', ...
	[x(1), x(size(x,2))], [0 0], 'k-', [0 0], [-10 10], 'k-')
	axis(axAS)
	axis off
    text(axAS(2)*1.05,0,'\fontname{times}{\itx_t}','FontSize',10)
    text(0,axAS(4)*1.05,0,'\fontname{times}{\it\pi_t}','FontSize',10)
    
orient landscape



