library(MASS)

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=10.0)

z <- read.table("Z.txt",sep="",header=TRUE)

z1 <- z[,1]
z2 <- z[,2]
z3 <- z[,3]

postscript(file="zhist.eps")
par(mfrow=c(3,1),mar=c(2.5,4,1.5,2)+0.1) # mar=c(b,l,t,r)

hist.scott(z1,main="Histogram of Z_1")
hist.scott(z2,main="Histogram of Z_2")
hist.scott(z3,main="Histogram of Z_3")

dev.off()

pvals <- seq(0.01,0.99,0.001)

postscript(file="zqq.eps")
par(mfrow=c(3,1),mar=c(2.5,4,1.5,2)+0.1) # mar=c(b,l,t,r)

zdist <- qnorm(p=pvals)
tdist <- qt(p=pvals,df=3)
zval1 <- quantile(z1,probs=pvals)
zval2 <- quantile(z2,probs=pvals)
zval3 <- quantile(z3,probs=pvals)

plot(zdist,zval1,type="n",ylab="")
lines(zdist,zval1,lty="solid")
lines(tdist,zval1,lty="dashed")
lines(c(0,0),range(zval1),lty="dotted")
lines(range(zdist),c(0,0),lty="dotted")

plot(zdist,zval2,type="n",ylab="")
lines(zdist,zval2,lty="solid")
lines(tdist,zval2,lty="dashed")
lines(c(0,0),range(zval2),lty="dotted")
lines(range(zdist),c(0,0),lty="dotted")

plot(zdist,zval3,type="n",ylab="")
lines(zdist,zval3,lty="solid")
lines(tdist,zval3,lty="dashed")
lines(c(0,0),range(zval3),lty="dotted")
lines(range(zdist),c(0,0),lty="dotted")

dev.off()



