library(MASS)

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=10.0)

filename <- "dcf.V_hat_hess.dat"
tmp <- scan(filename)
rows <- tmp[1]
cols <- tmp[2]
V <- matrix(tmp[3:(2+rows*cols)],nrow=rows,ncol=cols)

C <- V

for (i in 1:rows) {
  for (j in 1:cols) {
    ii <- rows - i + 1
    #jj <- cols - j + 1
    jj <- j
    if (i != j) {
      C[ii,jj] <- -V[i,j]/sqrt(V[i,i]*V[j,j])
    } else {
      C[ii,jj] <- 0
    }
  }
}

filename <- "V_heatmap.eps"

postscript(file=filename)

x <- seq(1,20)
y <- seq(1,20)

#heatmap(C,Rowv=NA,Colv=NA,revC=TRUE,xlab="",ylab="")

image(x,y,C,zlim=c(-1,1),xlab="",ylab="",xaxt="n",yaxt="n")

dev.off()

