#include "libscl.h"
#include <map>

using namespace std;
using namespace scl;

int main(int argc, char** argp, char** envp)
{
  realmat rho, hess;

  if(!vecread("dcf.rho_mode.dat",rho)) error("Error, vecread failed");
  if(!vecread("dcf.V_hat_hess.dat",hess)) error("Error, vecread failed");

  string filename = "heatmap.tex";
  ofstream fout;
  fout.open(filename.c_str());
  if (!fout) error("Error, cannot open " + filename);

  map<INTEGER,string> rho_names;
  rho_names[ 1] = "$b_0(1)$";
  rho_names[ 2] = "$b_0(2)$";
  rho_names[ 3] = "$b_0(3)$";
  rho_names[ 4] = "$B(1,1)$";
  rho_names[ 5] = "$B(2,1)$";
  rho_names[ 6] = "$B(3,1)$";
  rho_names[ 7] = "$B(1,2)$";
  rho_names[ 8] = "$B(2,2)$";
  rho_names[ 9] = "$B(3,2)$";
  rho_names[10] = "$B(1,3)$";
  rho_names[11] = "$B(2,3)$";
  rho_names[12] = "$B(3,3)$";
  rho_names[13] = "$R(1,1)$";
  rho_names[14] = "$R(1,2)$";
  rho_names[15] = "$R(2,2)$";
  rho_names[16] = "$R(1,3)$";
  rho_names[17] = "$R(2,3)$";
  rho_names[18] = "$R(3,3)$";
  rho_names[19] = "$\\beta$";
  rho_names[20] = "$\\gamma$";

  INTEGER p = hess.nrow();

  realmat C(p,p,0.0);

  for (INTEGER j=1; j<=p; ++j) {
    for (INTEGER i=1; i<j; ++i) {
      REAL rho = hess(i,j)/sqrt(hess(i,i)*hess(j,j));
      C(j,i) = rho;
      string sgn = "$+";
      if (rho < 0.0) {
        rho = -rho;
	sgn = "$-";
      }
      if (rho < 0.25) { C(j,i) = 0; fout << " & "; }
      if (0.25 <= rho && rho <  0.5 ) fout << sgn << "\\circ$ & ";
      if (0.5  <= rho && rho <  0.75) fout << sgn << "\\bullet$ & ";
      if (0.75 <= rho) fout << sgn << "\\medbullet$ & ";
    }
    fout << rho_names[j] << "\\\\" << '\n';
  }

  fout.clear(); fout.close();

  cout << C;

  return 0;
}

