
// Maximum likelihood estimation of the reduced form Lubik and Schorfheide's
// model

// VARX starting values for LI_bayes.mod

// Martin Fukac and Adrian Pagan, "Limited Information Estimation of DSGE
// models," Journal of Applied Econometrics, forthcoming.

// Matlab 2007, Dynare 3.065
// January 2008
// ========================================================================

var          dy ytil R R4 de infl infl4 dA dq;
varexo       eps_ytil eps_R eps_dA eps_de eps_q;

parameters   a11 a12 a13 a14 a21 a22 a23 a24 a31 a32 a33 a34 a41 a42 a43 a44 
             b11 b12 b13 b14 b21 b22 b23 b24 b31 b32 b33 b34 b41 b42 b43 b44 
             c11 c12 c21 c22 c31 c32 c41 c42
             cv1 cv2 cv3 cv4 cv5 cv6
             rhoA rhoq stde;

   
a11 =  0.3161;
a12 = -0.1928;
a13 =  0.2136;
a14 = -0.0985;
a21 =  0.0056;
a22 =  0.1409;
a23 =  0.1014;
a24 = -0.0801;
a31 =  0.5378;
a32 =  0.0422;
a33 =  0.0809;
a34 = -0.0693;
a41 = -0.1012;
a42 = -0.1294;
a43 =  0.0042;
a44 =  0.0742;
b11 = -0.0620;
b12 = -0.0102;
b13 =  0.2129;
b14 = -0.0163;
b21 = -0.2388;
b22 =  0.0671;
b23 =  0.0630;
b24 = -0.0799;
b31 =  0.3417;
b32 =  0.1574;
b33 =  0.3050;
b34 =  0.1538;
b41 = -0.2266;
b42 = -0.4851;
b43 = -0.1468;
b44 = -0.2542;
c11 = 0;
c12 = 0;
c21 = 0;
c22 = 0;
c31 = 0;
c32 = 0;
c41 = 0;
c42 = 0;
cv1=0;
cv2=0;
cv3=0;
cv4=0;
cv5=0;
cv6=1;
rhoA = 0.95;

rhoq = -0.18;
stde=5;

   

model;
    ytil = a11*ytil(-1) + a12*R(-1) + a13*de(-1) + a14*infl(-1) + b11*ytil(-2) + b12*R(-2) + b13*de(-2) + b14*infl(-2) + c11*dq + c12*dq(-1) + eps_ytil;
    R    = a21*ytil(-1) + a22*R(-1) + a23*de(-1) + a24*infl(-1) + b21*ytil(-2) + b22*R(-2) + b23*de(-2) + b24*infl(-2) + c21*dq + c22*dq(-1) + cv1*eps_ytil + eps_R;
    de   = a31*ytil(-1) + a32*R(-1) + a33*de(-1) + a34*infl(-1) + b31*ytil(-2) + b32*R(-2) + b33*de(-2) + b34*infl(-2) + c31*dq + c32*dq(-1) + cv2*eps_ytil + cv3*eps_R  + eps_de;
    infl = a41*ytil(-1) + a42*R(-1) + a43*de(-1) + a44*infl(-1) + b41*ytil(-2) + b42*R(-2) + b43*de(-2) + b44*infl(-2) + c41*dq + c42*dq(-1) + cv4*eps_ytil + cv5*eps_de + cv6*eps_de + eps_dA;
    dA   = rhoA*dA(-1) + eps_dA;
    dq   = rhoq*dq(-1) + eps_q;
    dy   = ytil - ytil(-1) + dA;
    R    = R4/4;
    infl = infl4/4;

end;

initval;
    ytil   = 0;
    dA     = 0;
    R      = 0;
    infl   = 0;
    R4     = 0;
    infl4  = 0;
    de     = 0;
end;


steady;
check;


estimated_params;
    a11 ,0,-2,2;
    a12 ,0,-1,2;
    a13 ,0 ,-1,1;
    a14 ,0,-1,1;
    a21 , 0,-1,1;
    a22 , 0,-1,2;
    a23 , 0,-1,1;
    a24 , 0,-1,1;
    a31 , 0,-10,1;
    a32 , 0,-10,1;
    a33 , 0,-1,1;
    a34 , 0,-1,1;
    a41 , 0,-2,4;
    a42 , 0,-1,2;
    a43 , 0,-1,1;
    a44 , 0,-2,1;
    b11 , 0,-1,1;
    b12 , 0,-1,1;
    b13 , 0,-1,1;
    b14 , 0,-1,1;
    b21 , 0,-1,1;
    b22 , 0,-1,1;
    b23 , 0,-1,1;
    b24 , 0,-1,1;
    b31 , 0,-1,10;
    b32 , 0,-1,10;
    b33 , 0,-1,1;
    b34 , 0,-1,1;
    b41 , 0,-4,4;
    b42 , 0,-4,1;
    b43 , 0,-1,1;
    b44 , 0,-1,1;
    c11 , 0,-4,4;
    c12 , 0,-4,4;
    c21 , 0,-4,4;
    c22 , 0,-4,4;
    c31 , 0,-4,4;
    c32 , 0,-4,4;
    c41 , 0,-4,4;
    c42 , 0,-4,4;
    cv1 , 0,-2,2;
    cv2 , 0,-2,4;
    cv3 , 0,-2,2;
    cv4 , 0,-2,2;
    cv5 , 0,-2,2;
    cv6 , 1,-2,2;

    //rhoA, 0.5,0,1;
    //rhoq, -0.2,-1,1;


    stderr eps_ytil, 1,0,10;
    stderr eps_R,    1,0,10;
    stderr eps_de,   1,0,10;
    stderr eps_dA,   1,0,10;
    stderr eps_q,    1,0,10;
end;



varobs de R4 infl4 dy dq;


estimation(datafile=NEWUKDAT);
