//             Replication of Lubik and Schorfheide (2007);

// The model solution from here is used to calibrate the LI/FI case.
// Matlab 2007, Dynare 3.065
// June 2008
// ========================================================================


var          dA R infl infl_s de dq ytil y_s dy infl4 R4 ;
varexo       eps_R eps_q eps_ys eps_infls eps_dA;

parameters  alpha beta kappa tau rho rho_A rho_q rho_ys rho_infls psi_1 psi_2 psi_3 c clag th;

// LS(2007) estimates - as published in JME (can be obtained from LS upon request)
alpha     = 0.12;
beta      = 0.997;
kappa     = 1.93;
tau       = 0.52;
rho       = 0.68;
rho_A     = 0.20;
rho_q     = -0.17;    // our estimate
rho_ys    = 0.97;
rho_infls = 0.37;
psi_1     = 1.17;
psi_2     = 0.40;
psi_3     = 0.12;

th        = alpha*(2-alpha)*(1-tau);

c    = 1;
clag = 0;


model;
    // Endogeneous variables
    ytil   = ytil(+1) -(tau+th)*(R-infl(+1)) - alpha*(tau+th)*rho_q*dq + (th/tau)*(1-rho_ys)*y_s; 
    infl   = beta*((1-clag)*infl(+1)+clag*infl(-1)) - alpha*(1-beta*rho_q)*dq +(kappa/(tau+th))*ytil + kappa*rho_A/((tau+th)*(1-rho_A))*dA + ((kappa*th)/(tau^2+tau*th))*y_s; 
    R      = rho*R(-1) + (1-rho)*psi_1*infl + (1-rho)*psi_2*ytil  + (1-rho)*psi_3*de + psi_3*(1-rho)*rho_A/(1-rho_A)*dA + eps_R;
    de     = infl - (1-alpha)*dq - infl_s;

    // Exogeneous variables
    dq     = rho_q*dq(-1) + eps_q;
    y_s    = rho_ys*y_s(-1) + eps_ys;
    dA     = rho_A*dA(-1) + eps_dA;
    infl_s = rho_infls*infl_s(-1) + eps_infls;

    // Definitions
    dy     = ytil - ytil(-1) + eps_dA/(1-rho_A);
    infl   = infl4/4;
    R      = R4/4;
end;

steady;
check;

shocks;
var eps_R;     stderr 0.2870;
var eps_q;     stderr 1.3233;
var eps_ys;    stderr 0.6815;
var eps_infls; stderr 3.3465;
var eps_dA;    stderr 0.5609;
end;


stoch_simul(order=1,periods=10000,irf=40,simul_seed=3) ytil R de infl;    
