
//         LIFI Bayesian estimation fo the Phillips curve

// This file replicates the LI/FI case in
// Martin Fukac and Adrian Pagan, "Limited Information Estimation of DSGE
// models," Journal of Applied Econometrics, forthcoming.

// Matlab 2007, Dynare 3.065
// June 2008
// ========================================================================


var          ytil R R4 de infl Einfl infl4 dq  y_s dA dy inflT;
varexo       eps_R eps_q eps_ys eps_dA eps_infls;

parameters   a11 a12 a13 a14 a21 a22 a23 a24 a31 a32 a33 a34 a41 a42 a43 a44 
             b11 b12 b13 b14 b21 b22 b23 b24 b31 b32 b33 b34 b41 b42 b43 b44 
             c11 c12 c21 c22 c31 c32 c41 c42
             cv11 cv12 cv13 cv14 cv21 cv22 cv23 cv24 cv31 cv32 cv33 cv34 cv41 cv42 cv43 cv44
             rhoq rhoA rho_ys alpha beta kappa tau rho_ys2 th clag rho_infls;



A = [    1.3476    0.5938    0.0057   -0.2186
        -1.3661   -0.6226   -0.0141    0.2459
        -3.7272   -3.3397    0.2997    0.3278
        -3.7272   -3.3397   -0.0703    0.6978];          

B = 1.0e-005 *[ 0    0.0967         0         0
                0   -0.0924         0         0
                0   -0.2538         0         0
                0   -0.2538         0         0];
  
C = [  0.0421   -0.0283
      -0.0232    0.0234
      -0.8675    0.3609
       0.0125    0.0353];
  
CV =[ -0.0582    0.0224   -0.1424   -0.4359
       0.1885    0.0055    0.1687    0.2684
       0.4747   -0.9005    0.4530   -1.6371
       0.4747    0.0995    0.4530   -1.6371];
   
a11 = A(1,1);
a12 = A(1,2);
a13 = A(1,3);
a14 = A(1,4);
a21 = A(2,1);
a22 = A(2,2);
a23 = A(2,3);
a24 = A(2,4);
a31 = A(3,1);
a32 = A(3,2);
a33 = A(3,3);
a34 = A(3,4);
a41 = A(4,1);
a42 = A(4,2);
a43 = A(4,3);
a44 = A(4,4);

b11 = B(1,1);
b12 = B(1,2);
b13 = B(1,3);
b14 = B(1,4);
b21 = B(2,1);
b22 = B(2,2);
b23 = B(2,3);
b24 = B(2,4);
b31 = B(3,1);
b32 = B(3,2);
b33 = B(3,3);
b34 = B(3,4);
b41 = B(4,1);
b42 = B(4,2);
b43 = B(4,3);
b44 = B(4,4);

c11 = C(1,1);
c21 = C(2,1);
c31 = C(3,1);
c41 = C(4,1);
c12 = C(1,2);
c22 = C(2,2);
c32 = C(3,2);
c42 = C(4,2);


cv11 = CV(1,1);
cv12 = CV(1,2);
cv13 = CV(1,3);
cv14 = CV(1,4);
cv21 = CV(2,1);
cv22 = CV(2,2);
cv23 = CV(2,3);
cv24 = CV(2,4);
cv31 = CV(3,1);
cv32 = CV(3,2);
cv33 = CV(3,3);
cv34 = CV(3,4);
cv41 = CV(4,1);
cv42 = CV(4,2);
cv43 = CV(4,3);
cv44 = CV(4,4);



alpha     = 0.12;
beta      = 0.997;
kappa     = 1.93;
tau       = 0.52;
rho       = 0.68;
rhoA      = 0.20;
rhoq      = -0.17;
rho_ys    = 0.97;
rho_infls = 0.37;
psi_1     = 1.17;
psi_2     = 0.40;
psi_3     = 0.12;
c = 1;


rho_ys2 = 0;

clag    =  0;

th = alpha*(2-alpha)*(1-tau);
   


model;
    // Substitutions
    #th=alpha*(2-alpha)*(1-tau);

    // The Phillips curve
    infl = beta*((1-clag)*Einfl+clag*infl(-1)) - alpha*(1-beta*rhoq)*dq +(kappa/(tau+th))*ytil +
           kappa*rhoA/((tau+th)*(1-rhoA))*dA + ((kappa*th)/(tau^2+tau*th))*y_s; 

    // Inflation expectations based on reduced form (VAR) estimates
    Einfl = a41*ytil + a42*R + a43*de + a44*inflT +
            b41*ytil(-1)+ b42*R(-1) + b43*de(-1) + b44*infl(-1) + 
            (c41*rhoq + c42)*dq; 
  
    // VARX equations
    inflT = a41*ytil(-1) + a42*R(-1) + a43*de(-1) + a44*infl(-1) + b41*ytil(-2) +
            b42*R(-2) + b43*de(-2) + b44*infl(-2) + 
            (c41*rhoq + c42)*dq(-1) +
            cv41*eps_dA + cv42*eps_infls + cv43*eps_ys + cv44*eps_R;  

    ytil  = a11*ytil(-1) + a12*R(-1) + a13*de(-1) + a14*infl(-1) + 
            b11*ytil(-2) + b12*R(-2) + b13*de(-2) + b14*infl(-2) + 
            c11*dq + c12*dq(-1) + 
            cv11*eps_dA + cv12*eps_infls + cv13*eps_ys + cv14*eps_R;

    R     = a21*ytil(-1) + a22*R(-1) + a23*de(-1) + a24*infl(-1) +
            b21*ytil(-2) + b22*R(-2) + b23*de(-2) + b24*infl(-2) + 
            c21*dq + c22*dq(-1) +
            cv21*eps_dA + cv22*eps_infls + cv23*eps_ys + cv24*eps_R;

    de    = a31*ytil(-1) + a32*R(-1) + a33*de(-1) + a34*infl(-1) + 
            b31*ytil(-2) + b32*R(-2) + b33*de(-2) + b34*infl(-2) + 
            c31*dq + c32*dq(-1) +
            cv31*eps_dA + cv32*eps_infls + cv33*eps_ys + cv34*eps_R;

    // Exogeneous and latent processes
    dq    = -0.1701*dq(-1)  + eps_q;
    y_s   = rho_ys*y_s(-1)  + eps_ys;
    dA    = rhoA*dA(-1)     + eps_dA;

    // Definitions
    dy    = ytil - ytil(-1) + eps_dA/(1-rhoA);
    R     = R4/4;
    infl  = infl4/4;
end;

 
initval;
    Einfl  = 0;
    ytil   = 0;
    R      = 0;
    infl   = 0;
    R4     = 0;
    infl4  = 0;
    de     = 0;
    dy     = 0;
    dq     = 0;
    y_s    = 0;
    dA     = 0;
    inflT  = 0;
end;

steady;
check;

estimated_params;
    alpha            ,.2,0,1   , BETA_PDF      ,0.20, 0.05 ;
    kappa            ,0.5,0,inf, GAMMA_PDF     ,0.50, 0.25 ; //1.8
    tau              ,0.5,0,4  , GAMMA_PDF     ,0.50, 0.20 ; //.22
   // clag            ,.01,0,1  ,BETA_PDF       ,0.50, 0.20; // Uncomment for the hybrid Phillips curve

    stderr eps_R,    .11,0,10,INV_GAMMA_PDF ,.11, 4;
    stderr eps_infls, 2.37,0,10,INV_GAMMA_PDF ,2.37, 4;
    stderr eps_q,    1.32,0,10,INV_GAMMA_PDF ,1.32, 4;
    stderr eps_ys,   .17,0,10,INV_GAMMA_PDF ,.17, 4;
    stderr eps_dA,   .31,0,10,INV_GAMMA_PDF ,.31, 4;
end;

// Observables
varobs de R4 infl4 dy dq;


estimation(datafile=NEWUKDAT,mh_replic=20000,mh_nblocks=1,mh_jscale=1);

