%script to design a tex-matrix summarizing the results
%written by Sylvia Kaufmann, 2001, constantly upgraded, last change 2004
%file='table.tex';
t_val=2; %flag for significance (0 for s.e.,1 for t-value,2 for shortest 95% conf.int.), 
euro=1; %flag to convert to euro
nlag=size(am_MIX,1);
ngrp=size(am_MIX,2);


fid=fopen(file,'w');
t=['\\begin{table}\\caption{ }\\label{tab:1}\\begin{center}\\begin{tabular}{l|' ... 
        '*{' int2str(ngrp) '}{c}|*{' int2str(ngrp) '}{c}|*{' int2str(ngrp) '}{c}|} \\hline \\hline \n'];
fprintf(fid,t);

t=['coeff.& \\multicolumn{' int2str(ngrp) '}{l|}{$I_t=1$}& \\multicolumn{' int2str(ngrp*2) '}{l|}{$I_t=0$}  \\\\ \n'];
fprintf(fid,t);
t1=[];
t2=[];
t3=[];
for i=1:ngrp;
    t1=[t1 '&$\\beta^G_{' int2str(i) '\\cdot}$'];
    t2=[t2 '&$\\beta^G_{' int2str(i) '\\cdot}-\\beta^R_{' int2str(i) '\\cdot}$'];
    t3=[t3 '&$\\beta^R_{' int2str(i) '\\cdot}$' ];
end
t=[t1 t2 t3 ' \\\\ \\hline \n'];

fprintf(fid,t);

for j=1:nlag;
    t11=['dir$_{t-' int2str(j) '}$ &' num2str(am_MIX(j,1),'%5.3f') '&' ];
    t12=[num2str(am_REC(j,1),'%5.3f') '&'  ];
    t13=[num2str(am_MS(j,1),'%5.3f') ];
    if t_val==1
        t11b=[ '& (' num2str(t_MIX(j,1),'%5.3f') ')&'];
        t12b=[ '(' num2str(t_REC(j,1),'%5.3f') ')&'];
        t13b=[ '(' num2str(t_MS(j,1),'%5.3f') ')'];
    elseif t_val==0
        t11b=[ '& (' num2str(sd_MIX(j,1),'%5.3f') ')&'];
        t12b=[ '(' num2str(sd_REC(j,1),'%5.3f') ')&'];
        t13b=[ '(' num2str(sd_MS(j,1),'%5.3f') ')'];
    elseif t_val==2
        t11b=[ '& (' num2str(ki_MIX(j,1,1),'%5.3f') ' ' num2str(ki_MIX(j,1,2),'%5.3f') ')&'];
        t12b=[ '(' num2str(ki_REC(j,1,1),'%5.3f') ' ' num2str(ki_REC(j,1,2),'%5.3f') ')&'];
        t13b=[ '(' num2str(ki_MS(j,1,1),'%5.3f') ' ' num2str(ki_MS(j,1,2),'%5.3f') ')'];
    end
    for i=2:ngrp;
        t11=[t11 num2str(am_MIX(j,i),'%5.3f') '&' ] ;
        t12=[t12 num2str(am_REC(j,i),'%5.3f') '&'  ];
        t13=[t13 '&' num2str(am_MS(j,i),'%5.3f') ];
        if t_val==1
            t11b=[t11b '(' num2str(t_MIX(j,i),'%5.3f') ')&'];
            t12b=[t12b '(' num2str(t_REC(j,i),'%5.3f') ')&'];   
            t13b=[t13b '&(' num2str(t_MS(j,i),'%5.3f') ')'];
        elseif t_val==0
            t11b=[t11b '(' num2str(sd_MIX(j,i),'%5.3f') ')&'];
            t12b=[t12b '(' num2str(sd_REC(j,i),'%5.3f') ')&'];  
            t13b=[t13b '&(' num2str(sd_MS(j,i),'%5.3f') ')'];
        elseif t_val==2
            t11b=[t11b '(' num2str(ki_MIX(j,i,1),'%5.3f') ' ' num2str(ki_MIX(j,i,2),'%5.3f') ')&'];
            t12b=[t12b '(' num2str(ki_REC(j,i,1),'%5.3f') ' ' num2str(ki_REC(j,i,2),'%5.3f') ')&'];
            t13b=[t13b '&(' num2str(ki_MS(j,i,1),'%5.3f') ' ' num2str(ki_MS(j,i,2),'%5.3f') ')'];
        end
    end
    t1=[t11 t12 t13];
    t2=[t11b t12b t13b];
    t1=[t1 ' \\\\ \n'];
    t2=[t2 ' \\\\ \n'];
    fprintf(fid,t1);
    fprintf(fid,t2);
end
fprintf(fid,'\\hline \n');
t11=[];t12=[];t11b=[];t12b=[];
for i=1:ngrp;
    t11=[t11 '&' num2str(am_MIXSUM(i),'%5.3f') ] ;
    t12=[t12 '&' num2str(am_MSSUM(i),'%5.3f')   ];
    if t_val==1
        t11b=[t11b '&(' num2str(t_MIXSUM(i),'%5.3f') ')'];
        t12b=[t12b '&(' num2str(t_MSSUM(i),'%5.3f') ')'];   
    elseif t_val==0
        t11b=[t11b '&(' num2str(sd_MIXSUM(i),'%5.3f') ')'];
        t12b=[t12b '&(' num2str(sd_MSSUM(i),'%5.3f') ')'];   
    elseif t_val==2
        t11b=[t11b '&(' num2str(ki_MIXSUM(i,1),'%5.3f') ' ' num2str(ki_MIXSUM(i,2),'%5.3f') ')'];
        t12b=[t12b '&(' num2str(ki_MSSUM(i,1),'%5.3f') ' ' num2str(ki_MSSUM(i,2),'%5.3f') ')'];   
        
    end
end
t1=['sum' t11 t12 ];
t2=[ t11b t12b ];
t1=[t1 '&\\multicolumn{' int2str(ngrp) '}{l|}{\\ } \\\\ \n'];
t2=[t2 '&\\multicolumn{' int2str(ngrp) '}{l|}{\\ } \\\\ \n'];
fprintf(fid,t1);
fprintf(fid,t2);

if K>1;
    t11=[];t12=[];t11b=[];t12b=[];
    t13=[];%t14=[];
    for i=1:ngrp;
        t11=[t11 '&' num2str(mean(exp(Zbasis(24,2,class(:,i)==1))/(13.7603*euro+(1-euro))),'%5.2f')  ] ;
        t12=[t12 '&' num2str(mean(Zbasis(24,3,class(:,i)==1)),'%5.2f')  ];
        t11b=[t11b '&' num2str(median(exp(Zbasis(24,2,class(:,i)==1))/(13.7603*euro+(1-euro))),'%5.2f') ];
        t12b=[t12b '&' num2str(median(Zbasis(24,3,class(:,i)==1)),'%5.2f')];   
        t13=[t13 '&' num2str(sum(prob(i,:),2)','%5.0f') ];
        %     t14=[t14 num2str(sum(exp(loans(size(Zbasis,1)+1,class(:,i)==1)))/sum(exp(loans(size(Zbasis,1)+1,any(class(:,1:ngrp),2)))),'%5.3f') '&'];
    end
    t11=['av. size' t11 '&\\multicolumn{' int2str(ngrp*2) '}{l|}{\\ } \\\\ \n'];
    t12=['av. liq.' t12 '&\\multicolumn{' int2str(ngrp*2) '}{l|}{\\ } \\\\ \n'];
    t11b=['med. size' t11b '&\\multicolumn{' int2str(ngrp*2) '}{l|}{\\ } \\\\ \n'];
    t12b=['med. liq' t12b '&\\multicolumn{' int2str(ngrp*2) '}{l|}{\\ } \\\\ \n'];
    t13=['no. countries' t13 '&\\multicolumn{' int2str(ngrp*2) '}{l|}{\\ } \\\\ \n'];
    % t14=['market loan sh.&' t14 '\\multicolumn{' int2str(ngrp+1) '}{l|}{\\ } \\\\ \n'];
    fprintf(fid,t13);
    fprintf(fid,t11);
    fprintf(fid,t11b);
    fprintf(fid,t12);
    fprintf(fid,t12b);
    % fprintf(fid,t14);
end

t11=[];t11b=[];t12=[];t12b=[];
%t13=[];t14=[];
for i=1:size(m_eta,3);
    t11=[t11 num2str(m_eta(1,1,i),'%5.2f') '&' ] ;
    t12=[t12 num2str(m_eta(2,2,i),'%5.2f') '&'  ];
    
    %     t11b=[t11b '(' num2str(s_eta(1,1,i,fix(size(s_eta,4)*0.025)),'%5.2f') ' ' num2str(s_eta(1,1,i,fix(size(s_eta,4)*0.975)),'%5.2f') ')&'];
    %     t12b=[t12b '(' num2str(s_eta(2,2,i,fix(size(s_eta,4)*0.025)),'%5.2f') ' ' num2str(s_eta(2,2,i,fix(size(s_eta,4)*0.975)),'%5.2f') ')&'];   
    t11b=[t11b '(' num2str(ki_eta(1,i,1),'%5.2f') ' ' num2str(ki_eta(1,i,2),'%5.2f') ')&'];
    t12b=[t12b '(' num2str(ki_eta(2,i,1),'%5.2f') ' ' num2str(ki_eta(2,i,2),'%5.2f') ')&'];   
    
    %         t13=[t13 num2str(sum(prob(i,:),2)','%5.0f') '&'];
    %     t14=[t14 num2str(sum(exp(loans(size(Zbasis,1)+1,class(:,i)==1)))/sum(exp(loans(size(Zbasis,1)+1,any(class(:,1:ngrp),2)))),'%5.3f') '&'];
end
t11=['$\\eta_{00}$&' t11 '\\multicolumn{' int2str(ngrp*3-1) '}{l|}{\\ } \\\\ \n'];
t12=['$\\eta_{11}$&' t12 '\\multicolumn{' int2str(ngrp*3-1) '}{l|}{\\ } \\\\ \n'];
t11b=['conf.int.&' t11b '\\multicolumn{' int2str(ngrp*3-1) '}{l|}{\\ } \\\\ \n'];
t12b=['conf.int.&' t12b '\\multicolumn{' int2str(ngrp*3-1) '}{l|}{\\ } \\\\ \n'];
%     t13=['no. countries&' t13 '\\multicolumn{' int2str(ngrp+1) '}{l|}{\\ } \\\\ \n'];
% t14=['market loan sh.&' t14 '\\multicolumn{' int2str(ngrp+1) '}{l|}{\\ } \\\\ \n'];
%     fprintf(fid,t13);
fprintf(fid,t11);
fprintf(fid,t11b);
fprintf(fid,t12);
fprintf(fid,t12b);
% fprintf(fid,t14);

t='\\hline \\hline \\end{tabular}\\end{center}\\end{table}\n';
fprintf(fid,t);


st=fclose(fid);
%[ac, hm, sd, ki, ineff] = autocovneu(par,1000);


