% make a table to summarize the database, define file
noout=0; %flag for banks to include, 0: include all banks, 1:exclude banks with mergers and outliers+leasing and foreign banks
excl_out=1; %flag for excluding only leasing and foreign banks
liq_sh=0; %flag (1) to eliminate banks with liquidity shares above 100% 
EURO=1 ; %flag for conversion to EURO
si_abs=[10 5];si_rel_pct=[0.975 0.50]; %vector containing values for big and small banks: si_abs in log values, si_rel contains percentiles in decimal writing
li_rel_pct=[0.95 0.50]; %values for liquid and illiquid banks, contains percentiles in decimal writing
avge=1; %flag for taking average rather median (0);
if EURO si_abs=si_abs-log(13.7603); end

load lenddata_b.asc;
load lo_losh.asc; %loans in 10 tausend!
%mergers,outliers,dum_BA
load dlo_merg.asc; 
load dlo_sonst.asc
load dlo_ba.asc
exclude_ind % load index of banks to exclude

nobs=35; %90:2-98:4
%r_smpl=[8:33]; %restrict sample to 92:1-98:2 BANK AUSTRIA IN SAMPLE.
r_smpl=[1:35]; %restrict sample to 90:2-98:2 CA IN SAMPLE.
%r_smpl=[1:35]; %full sample

nbank=size(lenddata_b,1)/nobs;

dat=1999;
time=1:nobs;
cal=[sort(dat-time/4)]';
cal=cal(r_smpl);

lish_out=reshape(lenddata_b(:,4),nobs,nbank)*1>100; %ERGAENZT 18.6.01, to exclude banks with liq.share>100%

dlo_merg=reshape(dlo_merg,nobs,nbank);
dlo_sonst=reshape(dlo_sonst,nobs,nbank);
dlo_ba=reshape(dlo_ba,nobs,nbank);
%dlo_out=dlo_merg+dlo_sonst;
dlo_out=(dlo_merg+dlo_sonst+lish_out)>0; %ERGAENZT 18.6.01, to exclude banks with liq.share>100%
dlo_out(r_smpl(1)+1,ind)=1;
if excl_out
   ind_excl=zeros(1,nbank);
   ind_excl(1,ind)=1;
end
dlo_out=dlo_out(r_smpl,:);
dlo_ba=dlo_ba(r_smpl,:);

ind=(sum(dlo_out,1)==0)*noout+ones(1,nbank)*(1-noout); %index to select banks for table
if excl_out
   ind=1-ind_excl;
end
ind = ind.*(sum(lish_out,1)==0);
nomerger=sum(dlo_out,2)==0;
dat_nomerg=cal(nomerger)
ref=find(cal==dat_nomerg(round(length(dat_nomerg)/2)));
%ref=35;

dlo=reshape(lenddata_b(:,11),nobs,nbank)*100; %w-rate kredite
dlo=dlo(r_smpl,:);

%Zbasis=zeros(nobs,6,nbank);
% Zbasis(:,1,:)=reshape(lenddata_b(:,9),nobs,nbank)*100; % zinssatz dir
% Zbasis(:,2,:)=reshape(lenddata_b(:,3),nobs,nbank); %Grsse si
% Zbasis(:,3,:)=reshape(lenddata_b(:,4),nobs,nbank)*100; %liquiditt lish
% Zbasis(:,4,:)=reshape(lenddata_b(:,14),nobs,nbank)*100; % interaktion zinssatz groesse disi
% Zbasis(:,5,:)=reshape(lenddata_b(:,15),nobs,nbank)*(100^2); %interaktion zinssatz liquiditt dilish
% Zbasis(:,6,:)=reshape(lenddata_b(:,16),nobs,nbank)*(100^2); %interaktion zinssatz liquiditt groesse disili
%Zbasis=Zbasis(r_smpl,:,:);
si=reshape(lenddata_b(:,3),nobs,nbank); %Grsse si
lish=reshape(lenddata_b(:,4),nobs,nbank)*100; %liquiditt lish
lo=reshape(lo_losh(:,1),nobs,nbank)-log(100); %loans in million schilling
if EURO 
    si=reshape(lenddata_b(:,3),nobs,nbank)-log(13.7603);
    lo=reshape(lo_losh(:,1),nobs,nbank)-log(100)-log(13.7603); end
losh=reshape(lo_losh(:,2),nobs,nbank); %loan share
si=si(r_smpl,ind==1);
lish=lish(r_smpl,ind==1);
lo=lo(r_smpl,ind==1);
losh=losh(r_smpl,ind==1);
lo=lo(ref,:);
losh=losh(ref,:);
losh_srt=sort(losh);
si=si(ref,:);       %grsse zum zeitpunkt ref
si_srt=sort(si);    %grsse sortiert      
si_rel=si_srt(round(sum(ind)*si_rel_pct))  %grenzen fr rel grsse (grosse,kleine bank)
lish=lish(ref,:);   %liquiditt zum zeitpunkt ref
lish_srt=sort(lish); %liquiditt sortiert
li_rel=lish_srt(round(sum(ind)*li_rel_pct)) %grenzen fr rel liquiditt (liquide,illiquide bank)

si_big_abs=sort(si(si>=si_abs(1))); si_small_abs=sort(si(si<=si_abs(2))); %grosse ,kleine banken (absolut, sortiert)
si_big_rel=sort(si(si>=si_rel(1))); si_small_rel=sort(si(si<=si_rel(2))); %grosse, kleine banken (relativ, sortiert)
si_liq_rel=sort(si(lish>=li_rel(1))); si_ill_rel=sort(si(lish<=li_rel(2))); %liquide, illiquide banken (relativ, nach grsse sortiert)

li_big_abs=sort(lish(si>=si_abs(1))); li_small_abs=sort(lish(si<=si_abs(2))); %grosse, kleine banken (absolut, nach liquiditt sortiert)
li_big_rel=sort(lish(si>=si_rel(1))); li_small_rel=sort(lish(si<=si_rel(2))); %grosse, kleine banken (relativ, nach liquiditt sortiert)
li_liq_rel=sort(lish(lish>=li_rel(1))); li_ill_rel=sort(lish(lish<=li_rel(2))); %liquide, illiquide banken (relativ, sortiert)

lo_big_abs=sort(lo(si>=si_abs(1))); lo_small_abs=sort(lo(si<=si_abs(2))); %grosse, kleine banken (absolut, nach loans sortiert)
lo_big_rel=sort(lo(si>=si_rel(1))); lo_small_rel=sort(lo(si<=si_rel(2))); %grosse, kleine banken (relativ, nach loans sortiert)
lo_liq_rel=sort(lo(lish>=li_rel(1))); lo_ill_rel=sort(lo(lish<=li_rel(2))); %liquide, illiquide banken (relativ, nach loans sortiert)

ls_big_abs=sort(losh(si>=si_abs(1))); ls_small_abs=sort(losh(si<=si_abs(2))); %grosse, kleine banken (absolut, nach kreditanteil sortiert)
ls_big_rel=sort(losh(si>=si_rel(1))); ls_small_rel=sort(losh(si<=si_rel(2))); %grosse, kleine banken (relativ, nach kreditanteil sortiert)
ls_liq_rel=sort(losh(lish>=li_rel(1))); ls_ill_rel=sort(losh(lish<=li_rel(2))); %liquide, illiquide banken (relativ, nach kreditanteil sortiert)


lpct=round(sum(ind)*0.025);
upct=round(sum(ind)*0.975);
mpct=round(sum(ind)*0.5);
lind_ba=round(sum(si>=si_abs(1))*0.025); uind_ba=round(sum(si>=si_abs(1))*0.975); %Perzentil-index fr grosse banken (absolut)
lind_sa=round(sum(si<=si_abs(2))*0.025); uind_sa=round(sum(si<=si_abs(2))*0.975); %Perzentil-index fr kleine banken (absolut)
lind_br=round(sum(si>=si_rel(1))*0.025); uind_br=round(sum(si>=si_rel(1))*0.975); %Perzentil-index fr grosse banken (relativ)
lind_sr=round(sum(si<=si_rel(2))*0.025); uind_sr=round(sum(si<=si_rel(2))*0.975); %Perzentil-index fr kleine banken (relativ)
lind_l=round(sum(lish>=li_rel(1))*0.025); uind_l=round(sum(lish>=li_rel(1))*0.975); %Perzentil-index fr liquide banken (relativ)
lind_i=round(sum(lish<=li_rel(2))*0.025); uind_i=round(sum(lish<=li_rel(2))*0.975); %Perzentil-index fr illiquide banken (relativ)

BLZ=reshape(lenddata_b(:,1),nobs,nbank); % BLZ
BLZ=BLZ(1,:)';

nobs=length(r_smpl);

'Anzahl outlier' 
sum(sum(dlo_out,1))
%sum(ioutc)
ioutc=sum(dlo_out,1)==0;
%ioutc=ioutc==0;
'Anzahl banken mit outlier'
sum(ioutc==0)

BLZ=BLZ(ioutc==1);
%y=y(ind==1);

fid=fopen(file,'w');
t='\\begin{table}\\caption{Unadjusted sample, ';
if noout 
    t='\\begin{table}\\caption{Adjusted sample, ';
end
t=[t num2str(cal(ref),'%6.2f') '}\\label{tab:1}\\begin{center}\\begin{tabular}{l|*{7}{c}|} \\hline \\hline \n'];
fprintf(fid,t);
t='& Total& big& small& big& small& liquid& illiquid \\\\ \n';
fprintf(fid,t);
t=['& & $>$' int2str(exp(si_abs(1))) '& $<$' int2str(exp(si_abs(2))) '& $>$' num2str(si_rel_pct(1)*100,'%3.1f') 'th & $<$' num2str(si_rel_pct(2)*100,'%3.1f') ...
       'th &$>$' num2str(li_rel_pct(1)*100,'%3.1f') 'th &$<$' num2str(li_rel_pct(2)*100,'%3.1f') 'th \\\\ \n'];
fprintf(fid,t);
t=['No of banks&' int2str(size(si,2)) '&' int2str(size(si_big_abs,2)) '&' int2str(size(si_small_abs,2)) '&'...
    int2str(size(si_big_rel,2)) '&' int2str(size(si_small_rel,2)) '&' ...
    int2str(size(si_liq_rel,2)) '&' int2str(size(si_ill_rel,2)) '\\\\ \\hline \n'];
fprintf(fid,t);
t=['Total assets&' int2str(sum(exp(si))) '&' int2str(sum(exp(si_big_abs))) '&' int2str(sum(exp(si_small_abs))) '&'...
    int2str(sum(exp(si_big_rel))) '&' int2str(sum(exp(si_small_rel))) '&' ...
    int2str(sum(exp(si_liq_rel))) '&' int2str(sum(exp(si_ill_rel))) '\\\\ \n'];
fprintf(fid,t);
t=['Asset share&' '&' num2str(sum(exp(si_big_abs))/sum(exp(si)),'%5.2f') '&' num2str(sum(exp(si_small_abs))/sum(exp(si)),'%5.2f') '&'...
    num2str(sum(exp(si_big_rel))/sum(exp(si)),'%5.2f') '&' num2str(sum(exp(si_small_rel))/sum(exp(si)),'%5.2f') '&' ...
    num2str(sum(exp(si_liq_rel))/sum(exp(si)),'%5.2f') '&' num2str(sum(exp(si_ill_rel))/sum(exp(si)),'%5.2f') '\\\\ \n'];
fprintf(fid,t);
if ~avge
t=['Median size&' int2str(median(exp(si),2)) '&' int2str(median(exp(si_big_abs))) '&' int2str(median(exp(si_small_abs))) '&'...
    int2str(median(exp(si_big_rel))) '&' int2str(median(exp(si_small_rel))) '&' ...
    int2str(median(exp(si_liq_rel))) '&' int2str(median(exp(si_ill_rel))) '\\\\  \n'];
fprintf(fid,t);
end
if avge
t=['Average size&' int2str(mean(exp(si),2)) '&' int2str(mean(exp(si_big_abs))) '&' int2str(mean(exp(si_small_abs))) '&'...
    int2str(mean(exp(si_big_rel))) '&' int2str(mean(exp(si_small_rel))) '&' ...
    int2str(mean(exp(si_liq_rel))) '&' int2str(mean(exp(si_ill_rel))) '\\\\  \n'];
fprintf(fid,t);
end
t=['95\\%%  interval&' int2str(exp(si_srt(lpct))) '/' int2str(exp(si_srt(upct))) '&'];
  t=[t int2str(exp(si_big_abs(lind_ba))) '/' int2str(exp(si_big_abs(uind_ba))) '&' int2str(exp(si_small_abs(lind_sa))) '/' int2str(exp(si_small_abs(uind_sa))) '&' ];
  t=[t int2str(exp(si_big_rel(lind_br))) '/' int2str(exp(si_big_rel(uind_br))) '&' int2str(exp(si_small_rel(lind_sr))) '/' int2str(exp(si_small_rel(uind_sr))) '&' ];
  t=[t int2str(exp(si_liq_rel(lind_l))) '/' int2str(exp(si_liq_rel(uind_l))) '&' int2str(exp(si_ill_rel(lind_i))) '/' int2str(exp(si_ill_rel(uind_i))) '\\\\ \\hline \\hline \n' ];
fprintf(fid,t);
if ~avge
t=['Median liquidity&' num2str(median(lish),'%5.2f') '&' num2str(median(li_big_abs),'%5.2f') '&' num2str(median(li_small_abs),'%5.2f') '&'...
    num2str(median(li_big_rel),'%5.2f') '&' num2str(median(li_small_rel),'%5.2f') '&' ...
    num2str(median(li_liq_rel),'%5.2f') '&' num2str(median(li_ill_rel),'%5.2f') '\\\\  \n'];
fprintf(fid,t);
end
if avge
t=['Mean liquidity&' num2str(mean(lish),'%5.2f') '&' num2str(mean(li_big_abs),'%5.2f') '&' num2str(mean(li_small_abs),'%5.2f') '&'...
    num2str(mean(li_big_rel),'%5.2f') '&' num2str(mean(li_small_rel),'%5.2f') '&' ...
    num2str(mean(li_liq_rel),'%5.2f') '&' num2str(mean(li_ill_rel),'%5.2f') '\\\\  \n'];
fprintf(fid,t);
end
t=['95\\%%  interval&' num2str(lish_srt(lpct),'%5.2f') '/' num2str(lish_srt(upct),'%5.2f') '&'];
  t=[t num2str(li_big_abs(lind_ba),'%5.2f') '/' num2str(li_big_abs(uind_ba),'%5.2f') '&' num2str(li_small_abs(lind_sa),'%5.2f') '/' num2str(li_small_abs(uind_sa),'%5.2f') '&' ];
  t=[t num2str(li_big_rel(lind_br),'%5.2f') '/' num2str(li_big_rel(uind_br),'%5.2f') '&' num2str(li_small_rel(lind_sr),'%5.2f') '/' num2str(li_small_rel(uind_sr),'%5.2f') '&' ];
  t=[t num2str(li_liq_rel(lind_l),'%5.2f') '/' num2str(li_liq_rel(uind_l),'%5.2f') '&' num2str(li_ill_rel(lind_i),'%5.2f') '/' num2str(li_ill_rel(uind_i),'%5.2f') '\\\\ \\hline \\hline \n' ];
  fprintf(fid,t);
t=['Total loans&' int2str(sum(exp(lo))) '&' num2str(sum(exp(lo_big_abs))/sum(exp(lo)),'%5.2f') '&' num2str(sum(exp(lo_small_abs))/sum(exp(lo)),'%5.2f') '&'...
    num2str(sum(exp(lo_big_rel))/sum(exp(lo)),'%5.2f') '&' num2str(sum(exp(lo_small_rel))/sum(exp(lo)),'%5.2f') '&' ...
    num2str(sum(exp(lo_liq_rel))/sum(exp(lo)),'%5.2f') '&' num2str(sum(exp(lo_ill_rel))/sum(exp(lo)),'%5.2f') '\\\\  \n'];
fprintf(fid,t);
if ~avge
t=['Median loan share&' num2str(median(losh),'%5.2f') '&' num2str(median(ls_big_abs),'%5.2f') '&' num2str(median(ls_small_abs),'%5.2f') '&'...
    num2str(median(ls_big_rel),'%5.2f') '&' num2str(median(ls_small_rel),'%5.2f') '&' ...
    num2str(median(ls_liq_rel),'%5.2f') '&' num2str(median(ls_ill_rel),'%5.2f') '\\\\  \n'];
fprintf(fid,t);
end
if avge
t=['Mean loan share&' num2str(mean(losh),'%5.2f') '&' num2str(mean(ls_big_abs),'%5.2f') '&' num2str(mean(ls_small_abs),'%5.2f') '&'...
    num2str(mean(ls_big_rel),'%5.2f') '&' num2str(mean(ls_small_rel),'%5.2f') '&' ...
    num2str(mean(ls_liq_rel),'%5.2f') '&' num2str(mean(ls_ill_rel),'%5.2f') '\\\\  \n'];
fprintf(fid,t);
end
t=['95\\%%  interval&' num2str(losh_srt(lpct),'%5.2f') '/' num2str(losh_srt(upct),'%5.2f') '&'];
  t=[t num2str(ls_big_abs(lind_ba),'%5.2f') '/' num2str(ls_big_abs(uind_ba),'%5.2f') '&' num2str(ls_small_abs(lind_sa),'%5.2f') '/' num2str(ls_small_abs(uind_sa),'%5.2f') '&' ];
  t=[t num2str(ls_big_rel(lind_br),'%5.2f') '/' num2str(ls_big_rel(uind_br),'%5.2f') '&' num2str(ls_small_rel(lind_sr),'%5.2f') '/' num2str(ls_small_rel(uind_sr),'%5.2f') '&' ];
  t=[t num2str(ls_liq_rel(lind_l),'%5.2f') '/' num2str(ls_liq_rel(uind_l),'%5.2f') '&' num2str(ls_ill_rel(lind_i),'%5.2f') '/' num2str(ls_ill_rel(uind_i),'%5.2f') '\\\\  \n' ];
  fprintf(fid,t);
 
t='\\hline \\hline \\end{tabular}\\end{center}\\end{table}\n';
fprintf(fid,t);

st=fclose(fid);
