function [alphamc,Smc,IMSmc,sepsmc,lambmc,postseps,postlamb,etamc,etaMSmc,etapostmc,etapostMSmc,anmc,ancholmc,dlo_miss] = ... 
    mixture3mcmc_samIt(y,ZG,ZMS,miss,dlo,dlo_out,indexb,indexn,index0,gr_fix,isp_lag_dlo,lag_dir,IMS,S,pralm,pralinf,Q,prseps,seps,prlamb,lamb,unit_spec_var,K,eta,etaMS,alpha,perm,e0,e0MS,frac,M,it0,it0cov,it0b)

% newly designed, Sylvia Kaufmann, 2003
% ZG(:,1:dd,:) .. group-specific effects .. X2
% ZG(:,dd+1:end,:) .. fixed effects .. X1
% 
% ZMS(:,1:dMS,:) .. group-specific switching effects


% Modell: y = X1*alpha + X2*D(1)*betak(1) + .. + X2*D(K)*betak(K)+... + X3*D(K)betaR(K)*(I_t,-1) + sepsi  for all i (Index weggelassen)
% K .. number of groups
% D(k) .. Dummy to indicate the group
% sepsi - N(0,sigma^2_i)
% b(i) - b(k), k=1,...,K ; S(i).. group indicator, implemented for pooling within groups

% input: 
%    - observations and design matrices:

%        y (T times N)  observations
%           T .. time dimension
%           N .. cross-section dimension

%        ZG (T times dd+1:end times N) design matrix for the fixed effects
%           d-dd .. dimension of  parameter alpha of fixed effects

%        ZG (T times 1:dd times N) design matrix for group-specific effects
%           dd .. dimension of  parameter betak of group-specific effects

%        ZMS (T times 1:dMS times N) design matrix for switching effects
%           dMS .. dimension of  parameter betaR of switching effects

%        IMS (1 times T) matrix of the state variable
%           

%    - prior information:

%        pralm  (d+dd*(k-1)+dMS*K) ... normal prior distribution :  mean 
%        pralinf (d+dd*(k-1)+dMS*K times d+dd*(k-1)+dMS*K) ... normal prior distribution : information matrix 
%                                                                                                                                                                       (inverse of covariance)
%        prseps (1 times 2).. inverted gamma prior distribution of seps
%             1,1 ... degrees of freedom
%             1,2 ... scale parameter

%
%        e0 (1 times K) .. Dirichlet prior for eta
%        e0MS  Dirichlet prior for etaMS (2 times 2 times K) if group-specific transition probabilities,
%                                        (2 times 2) if group-independent transition probabilities

%    - Size and starting value for MCMC:

%        M ... size of MCMC-sample
%        it0 ... burn-in 
%        it0b ... M-it0b values are saved for Smc and IMSmc
%        it0cov ... M-it0cov values are saved for ancm and ancholmc
%        sp=M-it0;
%        spcov=fix(M-it0cov);
%        spb=min(100,M-it0b);


%        Starting values:

%          seps (scalar) variance of the observation equation
%          Q (dd times dd times K) symmetric covariance matrix of the random effects
%          alpha (d+dd*(K-1)+dMS*K) fixed effects and group specific effects
%          eta (K) weights
%          etaMS (2 times 2 times K) if group-specific transition probabilities,
%                (2 times 2) if group-independent transition probabilities
%          IMS (K times T) group-specific state variable

%    - Model:
%          perm ... to define the restriction for the permutation sampler
%          K ... to define the number of groups

% output:
%        MCMC-sample:
%          alphamc (sp times d+dd*(k-1)+dMS*K)  group specific, fixed and group-specific switching effects
%          sepsmc (sp times 1) variance of the observation equation
%          etamc (sp times K) weigths
%          etaMSmc (size(e0MS) times sp) transition probabilities
%          Smc (spb times N) group indicator
%          IMSmc (K times N times spb) state variable

%        Parameters of conditional densities used for estimation (if post==1): 
%          postQS(spcov times dd*(dd+1)/2 times K) scale matrix of inverted  Wishart posterior of Q
%          postseps(spcov)  scale parameter of inverted gamma posterior densities of seps
%          etapostmc(spcov times K)
%          anmc(spcov times d+dd*(k-1)+dMS*K)
%          ancolmc(spcov times d+dd*(k-1)+dMS*K times d+dd*(k-1)+dMS*K)

post=0; %flag to save the parameters of posteriors
d = size(ZG,2); % the first dd columns contain the group-specific effects
dd = size(Q,1);
dMS=size(ZMS,2); %dimension of the switching effects

N = size(y,2);
T = size(y,1);
lag_dlo=size(isp_lag_dlo,2);
nobs_nu=(lag_dir-lag_dlo)*(lag_dir>lag_dlo);
dlo_miss=zeros(size(dlo));

dlo_m=median(dlo);dlo_s=iqr(dlo);      
nst=size(etaMS,1);
states = 1:nst;
groups = [1:K]';
etaMSmc=zeros(2,2,size(etaMS,3),1);
etapostMSmc=zeros(2,2,size(etaMS,3),1);
IMSmc=zeros(size(IMS,1),size(IMS,2));

sp=M-it0;
spcov=fix(M-it0cov);
spb=min(100,M-it0b);

alphamc=zeros(sp,dd*(K-1)+d+dMS*K);  
sepsmc=zeros(sp,1);
lambmc=lamb;
if unit_spec_var
    lambmc=zeros(sp,N);
end
etamc=zeros(sp*(1-gr_fix),K);
if dMS>0 
    etaMSmc=zeros(nst,nst,size(etaMS,3),sp);
    if post
        etaMSpostmc=zeros(nst,nst,size(etaMS,3),spcov);
    end
    IMSmc=zeros(size(IMS,1),size(IMS,2),spb);
    
    index_col=[1:size(ZG,2)];
    index_perm2=zeros(dMS,1);
    for iMS=1:dMS
        incol=index_col(all(all((ZG-ZMS(:,iMS*ones(size(ZG,2),1),:))==0,3)==1,1));
        if isempty(incol) 
            ['warning: column ' num2str(iMS) ' of ZMS not contained in ZG']
        else   
            index_perm2(iMS)=incol;
        end  
    end   
else
    etaMSmc=[]; etaMSpostmc=[]; IMSmc=[];
end

shilf=1;
it0mmc=M;rat=M;
postseps=zeros(1,2);
postlamb=zeros(1,2);
etapostmc=zeros(1,K);
anmc=zeros(1,dd*(K-1)+d+dMS*K);
ancholmc=zeros(1,dd*(K-1)+d+dMS*K,dd*(K-1)+d+dMS*K);

if post
    % saves each r-th simulation after the burn-in phase
    if spcov > 0
        rat = floor((M-it0)/spcov);
        it = it0:M;
        it0mmc=it(find(((M-it)/spcov)==rat));
    end   
    
    postseps=zeros(spcov,2);
    if unit_spec_var
        postlamb=zeros(spcov,2,N);
    end
    etapostmc=zeros(spcov,K);
    anmc=zeros(spcov,dd*(K-1)+d+dMS*K);
    ancholmc=zeros(spcov,dd*(K-1)+d+dMS*K,dd*(K-1)+d+dMS*K);
end

eps = zeros(T,N); 
Smc=zeros(spb*(1-gr_fix),N);
prob = zeros(K,N);
y_mf=zeros(T,N);
y_MS=zeros(T,N);

sp=0;  % to compute the likelihood

indexG = kron(ones(1,K),[1:dd]); 
indexK = kron([1:K]',ones(dd,1))'; 
indexR = kron(ones(1,K),[1:dMS]);
indexM = kron([1:K]',ones(dMS,1))';
indexMIX=[1:dd*K];
indexFIX=[K*dd+1:d+(K-1)*dd];
indexMS=[(d+(K-1)*dd+1):(d+(K-1)*dd+dMS*K)];

if gr_fix
    [S_new,sp_new, Vinv] = simstateexmix(y,eta,ZG,ZMS,IMS,Q,alpha,indexMIX,indexFIX,indexMS,seps,lamb,dd,sp);  
end
    

for m=1:M
    
    if any(m==[1:1000:M]) 
        m
    end
    
    ANinv = pralinf;
    a = pralinf*pralm;
    
    % 3. sampling the group indicator
    
    if ~gr_fix
        [S,sp, Vinv] = simstateexmix(y,eta,ZG,ZMS,IMS,Q,alpha,indexMIX,indexFIX,indexMS,seps,lamb,dd,sp);  
    end
    
    
    D = S(ones(K,1),:)==groups(:,ones(N,1)); %group dummy
    
    %   1a.  Sampling the fixed and group-specific (non-random) effects from the marginal model
    if dMS>0;
        if size(IMS,1)<K
            IMStr=IMS(ones(K,1),:)';
        else
            IMStr=IMS';
        end
    end
    for k=1:K;
        %X'X (calculated by group) save each block separately (block for the group-specific, the fixed and the group-specific switching effects)
        
        Xtr=reshape(permute([ZG(:,:,S==k).*permute(sqrt(Vinv(ones(T,1),S==k,ones(d,1))),[1 3 2])],[2 1 3]),d,sum(S==k)*T);
        if sum(S==k)==0;
           Xtr=zeros(d+dMS,1);
        end
        if (dMS>0)*(sum(S==k)>0);
            Xtr=[Xtr; reshape(permute([(ZMS(:,:,S==k).*permute(sqrt(Vinv(ones(T,1),S==k,ones(dMS,1))),[1 3 2])) ... 
                        .*(permute([IMStr(:,k,ones(dMS,1),ones(sum(S==k),1))-1],[1 3 4 2]))],[2 1 3]),dMS,sum(S==k)*T)]; %X-transpose
         end
         
         XX = Xtr*Xtr';
         if sum(S==k)>0;
            Xy = Xtr*reshape([y(:,S==k).*sqrt(Vinv(ones(T,1),S==k))],size(Xtr,2),1);
         elseif sum(S==k)==0;
            Xy= zeros(d+dMS,1);
         end
                 
        ANinv((k-1)*dd+[1:dd],[(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])]) = ANinv((k-1)*dd+[1:dd],[(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])]) + XX(1:dd,:);        
        ANinv(indexFIX,[(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])]) = ANinv(indexFIX,[(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])]) + XX(dd+1:d,:);
        ANinv(indexMS((k-1)*dMS+[1:dMS]), [(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])]) = ANinv(indexMS((k-1)*dMS+[1:dMS]), [(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])]) + XX(d+1:end,:);
        a([(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])]) = a([(k-1)*dd+[1:dd] indexFIX indexMS((k-1)*dMS+[1:dMS])])+ Xy;
    end
    
    % schur decomposition   - informationsmatrix
    
    [U, Td]=schur(ANinv);
    Td=diag(1./(abs(diag(real(Td))).^.5));
    U=real(U);
    %   ancov=U*Td.^2*U';
    an = U*Td.^2*U'*a;
    anchol = U*Td;
    alpha = an + anchol*randn(dd*(K-1)+d+dMS*K,1);
    
    %  4. sampling the group probability
    if ~gr_fix
        [eta,etapost] = simtransex(D,e0);
    end
    if dMS>0 
        [etaMS,etapostMS] = simxi_ms(IMS'+1,e0MS);
    end
    
    
    alph=permute(alpha([(S(ones(dd,1),:)'-1)*dd+kron(ones(N,1),[1:dd]) kron(ones(N,1),indexFIX)]),[3 2 1]);
    if N==1
        alph=reshape(alph,1,size(alph,3),1);
    end
    y_mf = squeeze(sum(ZG.*alph(ones(T,1),:,:),2));
    if dMS>0 
        IMSmat=reshape(IMStr(:,S),T,1,N);
        alph=permute(alpha([reshape([indexMS([(S(ones(dMS,1),:)'-1)*dMS+kron(ones(N,1),[1:dMS])])],N,dMS)]),[3 2 1]);
        if N==1
            alph=reshape(alph,1,size(alph,3),1);
        end
        y_MS = squeeze(sum( (ZMS.*(IMSmat(:,ones(1,dMS),:)-1)).*alph(ones(T,1),:,:),2));
        eps = y - y_mf - y_MS;
    else
        eps = y - y_mf;
    end
    
    
    
    %  2b. variances of observation equation   
    
    posts = prseps + .5*frac*[N*T  sum(sum(eps.^2,1).*lamb,2)];
    seps = 1./gamrnd(posts(1,1),1./posts(1,2));
    
    % sample unit-specific lambda's
    if unit_spec_var
        postl = prlamb(ones(N,1),:)./2 + 0.5*[T*ones(N,1) (sum(eps.^2,1)./seps)']; %prlamb(ones(N,1),:)./2
        lamb = gamrnd(postl(:,1),1./postl(:,2))';
    end
    
    % Sample MS-Indicator
    
    if dMS>0        
        Dstat1=permute(D,[3 1 2]);
        ystat1 = squeeze(sum((-ZMS(:,indexR,:).*Dstat1(ones(size(ZMS,1),1),kron(1:K,ones(1,dMS)),:)).*permute(alpha([indexMS],ones(size(ZMS,1),1),ones(size(ZMS,3),1)),[2 1 3]),2));
        lik = full_lik([y-y_mf-ystat1],[y-y_mf],S,seps./lamb,size(IMS,1));
        IMS = simstate_ms_new(etaMS,lik)'-1;
    end
    
    if miss==1 
        % sample missing values
        Tall=size(dlo,1)-nobs_nu;
        dlo_use=dlo(1+nobs_nu:end,:);
        for i=1:N
            ib=indexb(i);
            imiss=dlo_out(1+nobs_nu:end,ib)'==1;
            if any(imiss)
                betai=[alpha((S(i)-1)*dd+[1:dd]);alpha(indexFIX);zeros(dMS,1)];
                betai=betai(:,ones(1,T));
                if dMS>0
                    betai(d+1:d+dMS,:)=betai(d+1:d+dMS,:)+alpha(indexMS([(S(i)-1)*dMS+[1:dMS]]),ones(1,T)).*(permute([IMS(1,:,ones(dMS,1))],[3,2,1])-1);
                end   
                
                if lag_dlo>0
                    isp_nolag=[1:(isp_lag_dlo(1)-1) (isp_lag_dlo(end)+1):size(ZG,2)];
                    %construct Bi
                    Bi=reshape([betai(isp_lag_dlo(end:-1:1),:)' -ones(T,1) zeros(T)]',T*(Tall+1),1);
                else
                    isp_nolag=[1:size(ZG,2)];
                    Bi=reshape([-ones(T,1) zeros(T)]',T*(Tall+1),1); 
                end   
                Bi=reshape(Bi(1:end-T),Tall,T)';
                izero=all(Bi(:,imiss)==0,2);
                Bitilde=Bi(~izero,imiss);
                dc=Bi(~izero,~imiss)*dlo_use(~imiss,ib)+sum(squeeze(ZG(~izero,isp_nolag,i)).*betai(isp_nolag,~izero)',2);
                if dMS>0; 
                    dc=dc+sum(squeeze(ZMS(~izero,:,i)).*betai(d+1:end,~izero)',2);
                end
                C0=(1.34/5)^2*diag((1./dlo_s(ib*ones(1,size(Bitilde,2)))).^2);
                Sy=inv(Bitilde'*Bitilde/(seps/lamb(i))+C0);                                           
                my=Sy*(-Bitilde'*dc/(seps/lamb(i))+C0*dlo_m(ib*ones(1,size(Bitilde,2)))');
                
                ytilde=my+chol(Sy)'*randn(size(my,1),1);
                dlo_use(imiss,ib)=ytilde;
            end   
            
        end   
        dlo(1+nobs_nu:end,:)=dlo_use;
        % impute missing values
        y=dlo(indexn,indexb);
        if lag_dlo>0
            for i1=1:lag_dlo
                ZG(1:size(indexn,1),isp_lag_dlo(i1),1:size(indexb,2))=dlo(indexn-i1,indexb);
            end
        end   
    end   
    
    
    % 5. Permutation
    
    if perm == 100
        si = randperm(K); 
        if gr_fix
            si=[1:K];
        end
        siMS = randperm(2);
        %siMS=[1:2];  %no permutation
    else
        si =[1:K];siMS=[1:2];
    end
    
    %CHANGE THE FOLLOWING IF FIXED EFFECTS ARE ALSO SWITCHING
    alphai=reshape(alpha([indexMIX indexMS]),dd,K,nst); 
    
    if and(dMS>0,siMS(1)==2)
        % match group specific and fixed parameters 
        iiMIX=index_perm2(index_perm2<=dd);
        iiFIX=index_perm2(index_perm2>dd)+(K-1)*dd; 
        
        %CHANGE THE FOLLOWING IF FIXED EFFECTS ARE ALSO SWITCHING
        alphai(iiMIX,:,1)=alphai(iiMIX,:,1)-alphai(iiMIX,:,2);
        %alpha(iiFIX)=alpha(iiFIX)-alpha(indexMS(???));  %CHOOSE WHICH STATE VARIABLE IS RELEVANT FOR FIXED EFFECTS
        alphai(iiMIX,:,2)=-alphai(iiMIX,:,2);
        IMS = 1-IMS;
        etaMS=etaMS(siMS,siMS,:);
        alpha(indexMIX,1) = reshape(alphai(:,:,1),dd*K,1);
        alpha(indexMS,1) = reshape(alphai(:,:,2),dd*K,1);
    end
    
    if any(si~=[1:K])
        [si1,ssort]=sort(si);
        S = ssort(S);
        %CHANGE THE FOLLOWING IF FIXED EFFECTS ARE ALSO SWITCHING
        alpha(indexMIX,1) = reshape(alphai(:,si,1),dd*K,1);
        if dMS>0
        alpha(indexMS,1) = reshape(alphai(:,si,2),dd*K,1);
        end
        eta = eta(si);
        if size(IMS,1)>1;
            IMS = IMS(si,:);
        end
        if size(etaMS,3)>1;
            etaMS=etaMS(:,:,si);
        end
    end
    
    
    % 6. saving
    if m > it0 
        alphamc(m-it0,:)=alpha';
        sepsmc(m-it0)=seps;
        lambmc(m-it0,:)=lamb;
        if ~gr_fix
            etamc(m-it0,:)=eta;
        end
        if dMS>0 
            etaMSmc(:,:,:,m-it0)=etaMS; 
        end
        dlo_miss=dlo_miss+dlo;
    end
    
    if (m == it0mmc + rat*shilf)*post
        anmc(shilf,:)=an';
        ancholmc(shilf,:,:)=anchol;
        postseps(shilf,:)=posts;
        postlamb(shilf,:,:)=permute(postl,[3 2 1]);
        etapostmc(shilf,:)=etapost;
        if dMS>0 etapostMSmc(:,:,:,shilf)=etapostMS; end
        
        shilf = shilf+1;
    end
    
    if (m > M-spb)
        if ~gr_fix
            Smc(m-(M-spb),:)=S; 
        end
        if dMS>0  IMSmc(:,:,m-(M-spb))=IMS; end
    end
        
end 

dlo_miss=dlo_miss/(M-it0);