function [indexfc] = define_banks(fc_beg,fc_end)
%find outliers and select banks for forecast evaluation
%ADJUST procedure before using it, in particular lines  15-40 and line 80 (to enforce some banks to be included regardless of outliers)
% fc_beg  forecast interval begin
% fc_end  forecast interval end

% load updated databank
% load merger file
% define observation range of sample on line 19, set sample-end+1 on line 24
% dlo loan growth rates, TxN
% m_ret merger identification TxN
% z_ret zero or NANA entries identification TxN
% o_ret additional outlier identification TxN


load lenddata_update.asc %%1990Q2-2002Q4
% label	date	si	lish	dum1	dum2	dum3	dumliq	dir	dp86	dyr	dlo	outdlo	disi	dilish	disili

nobs_full= (2002-1990+1)*4-1; %1990Q2-2002Q4
nobs=nobs_full;
% fc_beg=1999; fc_end=2001.75; % forecast interval 1999Q1-2002Q4

time = 1:nobs;
c = 2003;
cal = [sort(c-time/4)]';
fc_int=[find(cal==fc_beg):find(cal==fc_end)]; %forecast interval

nbanks=804;
BLZ=lenddata_update(1:nobs:end,1);

dlo=reshape(lenddata_update(:,12),nobs,nbanks);

load dlo_merg_90q2_02q4.asc % nobs_full x N matrix of dummies identifying merger outliers
%MERGERS
m_ret=reshape(dlo_merg_90q2_02q4,nobs,nbanks);

%ev. UNIT EXCLUSION
ex_ret=zeros(1,nbanks);
liq_sh=0;
exclude_ind
ex_ret(1,ind)=1;

%IDENTIFY ZERO or NAN ENTRIES (means ev. not reported values, growth rates not available)
z_ret=zeros(nobs,nbanks);
z_ret= 1-((dlo>-Inf).*(dlo<Inf));

%IDENTIFY ADDITIONAL OUTLIERS
dlo_m=zeros(1,nbanks);
dlo_s=zeros(1,nbanks);
for j=1:nbanks
dlo_m(1,j)=median(dlo(z_ret(:,j)==0,j));
dlo_s(1,j)=iqr(dlo(z_ret(:,j)==0,j));
end
dlo_z=(dlo-dlo_m(ones(nobs,1),:))./dlo_s(ones(nobs,1),:);
% figure(1);
% subplot(3,1,1);
% plot(dlo_m);
% subplot(3,1,2);
% plot(dlo_s);
% subplot(3,1,3);
% plot(cal,dlo_z);


% xmin=-100;
% xmax=100;
% dn=50;
%for i=1:14
%   figure(1+i);
%   indexb=dn*(i-1);
%   boxplot(dlo(:,[(indexb+1):min((indexb+dn),nbanks)]),0,'r+',1,5);
%   title(['bank:' num2str(indexb+1) ' bis ' num2str(min((indexb+dn),nbanks))]);
%   axis([1 dn xmin xmax]);
%end   

index=[1:nbanks];

o_ret=(abs(dlo)>(dlo_m(ones(1,nobs),:)+5*dlo_s(ones(1,nobs),:)))-(((z_ret+m_ret)>0).*(abs(dlo)>(dlo_m(ones(1,nobs),:)+5*dlo_s(ones(1,nobs),:))));

indexfc=index(all((1-m_ret(fc_int,:)).*(1-z_ret(fc_int,:)).*(1-o_ret(fc_int,:)).*(1-ex_ret(ones(1,length(fc_int)),:)),1));
% ev. enforce inclusion of some banks: be aware of mergers or outliers, however!!!
indexfc=sort([find(BLZ==12000) find(BLZ==14000) indexfc]);


clear lenddata_update dlo_merg_90q2_02q4

% xmin=-1.5;
% xmax=1.5;
% iplot=0;ifig=5;nplot=9;nline=3;
% for i=find(any(o_ret(fc_int,:)))
% % for i=find(all((1-m_ret(fc_int,:)).*(1-z_ret(fc_int,:)).*(1-o_ret(fc_int,:)).*(ex_ret(ones(1,length(fc_int)),:)),1))
% 
%     outl=m_ret;
%     outl2=o_ret;
%     %     outl3=z_ret(2:end,:);
%     iplot=iplot+1;
%     if iplot==1;ifig=ifig+1;figure(ifig);end
%     subplot(nplot/nline,nline,iplot);
%     bar(cal,outl(:,i)*(-100),'r')
%     hold on;
%     bar(cal,outl(:,i)*100,'r')
%     hold on;
%         bar(cal,outl2(:,i)*(-100),'m')
%         hold on;
%         bar(cal,outl2(:,i)*100,'m')
%         hold on;
%     %     bar(cal,outl3(:,i)*(-100),'y')
%     %     hold on;
%     %     bar(cal,outl3(:,i)*100,'y')
%     %     hold on;
%     plot(cal,dlo(:,i));
%     legend(num2str(BLZ(i)));
%     % %     title(num2str(i));
%     axis([cal(1) cal(end)  xmin xmax]);
%     if iplot==nplot;iplot=0;end
% end   
