% read in data
load lenddata_b.asc; % TNxU data matrix, each column contains 1 variable, ordered by bank, by time
load caprat.asc;
%load asymlend.asc;
% label	date	si	lish	dum1	dum2	dum3	dumliq	dir	dp86	dyr	dlo	outdlo	disi	dilish	disili
nobs=35;
nbank=804;

caprat=reshape(caprat,nobs,nbank);
dlo=reshape(lenddata_b(:,12),nobs,nbank); %growth rate of loans
dlo_obs=dlo;
time = 1:nobs;
cend = 1999;
cal = [sort(cend-time/4)]';


%loading outlier due to merger and to statistical considerations
load dlo_merg.asc -ascii; 
dlo_out1=reshape(dlo_merg,size(dlo));
load dlo_sonst.asc -ascii;
dlo_out2=reshape(dlo_sonst,size(dlo));
dlo_out=1-(1-dlo_out1).*(1-dlo_out2);


Zbasis=zeros(nobs,6,nbank);
Zbasis(:,1,:)=reshape(lenddata_b(:,9),nobs,nbank)*100; % interest rate dir, first difference
Zbasis(:,2,:)=reshape(lenddata_b(:,3),nobs,nbank); %size si
Zbasis(:,3,:)=reshape(lenddata_b(:,4),nobs,nbank)*100; %liquidity lish
Zbasis(:,4,:)=reshape(lenddata_b(:,14),nobs,nbank)*100; % interaction of interest rate changes and size disi
Zbasis(:,5,:)=reshape(lenddata_b(:,15),nobs,nbank)*(100^2); %interaction of interest rate changes and liquidity dilish
Zbasis(:,6,:)=reshape(lenddata_b(:,16),nobs,nbank)*(100^2); %interaction of interest rate changes, size and liquidity disili


BLZ=reshape(lenddata_b(:,1),nobs,nbank); % bank label
BLZ=BLZ(1,:)';

Zdum=zeros(nobs,4,nbank);%dummies 1-3: saisonals 4: structural break in liquidity from 1995Q4 onwards
for i1=1:4;
   Zdum(:,i1,:)=reshape(lenddata_b(:,4+i1),nobs,nbank); 
end;clear i1;   

Zwirt=zeros(nobs,2,nbank); % macro data 1: dp86 (inflation) 2: dyr (gdp growth)
for i1=1:2;
   Zwirt(:,i1,:)=reshape(lenddata_b(:,9+i1),nobs,nbank)*100; 
end;clear i1;   
dyr=lenddata_b(1:nobs,9+2)*100;
c=ones(size(Zdum,1),1,size(Zdum,3)); % constant 


