 # delimit ;  
set more 1 ;  
local UNIX 0;
* this program generates moments for the bivariate distribution hospital nights and medical costs ;
if `UNIX' == 1 {;
	local saved  "~/hrs/merge/";
	local wave1d "~/hrs/wave1/";
	local wave2d "~/hrs/wave2/";
	local wave3d "~/hrs/wave3/";
	local wave4d "~/hrs/wave4/";
	local wave5d "`/hrs/wave5/";
	local healdn "`/hrs/healdn/";
	local healep "`/hrs/healep/";
};
else { 
	local saved  "d:\hrs\merge\";
	local wave1d "d:\hrs\wave1\";
	local wave2d "d:\hrs\wave2\";
	local wave3d "d:\hrs\wave3\";
	local wave4d "d:\hrs\wave4\";
	local wave5d "d:\hrs\wave5\";
	local healdn "d:\hrs\healdn\";
	local healep "d:\hrs\healep\";
};

log using `healdn'momentdm.log, replace ;
drop _all;
program drop _all;

* GENERATE OF COUPLE OF PROCEDURES BELOW;
*NOW GENERATE THE ELEMENTS OF THE COVARIANCE MATRIX (IE, MOMENT CONDITION CONTRIBUTIONS);
program define moments;
        version 3.1;
local i = 1 ; 
local k=1;
while `i' <=numyear { ;

replace icounter=`i';
replace jmax=numyear-icounter;
	local j=icounter;
		while `j'<=numyear {;
			gen momvec`k'=med`i'*med`j';
		local k=`k'+1;
	local j = `j' +1};
local i = `i'+1 } ;
end;

* generate matrix of demeaned variables used to generate variance-covariance matrix for the data;
program define mydata;
        version 3.1;
    local i = 1 ;
    while `i' <=nummom { ;
    	gen vec`i'=0;
    	replace vec`i'=momvec`i' if momvec`i'~=.;
	gen uthere`i'=0;
	replace uthere`i'=1 if (momvec`i'~=. & momvec`i'~=0);
local i = `i'+1 } ;
end;

* this program compresses all data about an individual onto one observation;
program define merged;
        version 3.1;
	sort indnum wave;
    local i = 1 ;
    while `i' <=5 { ;		
	replace med`i'=med`i'[_n-1] if med`i'==0 & indnum==indnum[_n-1];	
	replace medl`i'=medl`i'[_n-1] if medl`i'==. & indnum==indnum[_n-1];	
	replace doc`i'=doc`i'[_n-1] if doc`i'==0 & indnum==indnum[_n-1];	
	replace docl`i'=docl`i'[_n-1] if docl`i'==. & indnum==indnum[_n-1];
local i = `i'+1 } ;
sort indnum wave;
end;

program define merger;
  version 3.1;
  sort indnum wave;
    local i = 1 ;
    while `i' <=5 { ;
	gen med`i'=0;
	gen medl`i'=.;	
	gen doc`i'=0;
	gen docl`i'=.;		
	replace med`i'=med if wave==`i' & med~=.;
	replace medl`i'=med if wave==`i';

	replace doc`i'=doc if wave==`i' & doc~=.;
	replace docl`i'=doc if wave==`i';
local i = `i'+1 } ;
sort indnum wave;
end;

program define demean;
version 3.1;
replace insnone=1 if medcare==1;

gen medcost=med;

gen age2=age*age;
gen age65=0;
replace age65=1 if age>64;
gen epins65=0;
replace epins65=1 if age65==1 & epins==1;
gen insnone65=0;
replace insnone65=1 if age65==1 & insnone==1;
gen inspriv65=0;
replace inspriv65=1 if age65==1 & inspriv==1;
gen medicaid65=0;
replace medicaid65=1 if age65==1 & medicaid==1;
gen linc65=0;
replace linc65=linc if age65==1;


replace epins=0 if age>64;
replace insnone=0 if age>64;
replace inspriv=0 if age>64;
replace medicaid=0 if age>64;
sum medicaid65;

sum medcosth male married age age2 insnone 
epins inspriv medicaid
insnone65 epins65 inspriv65 medicaid65 drtimesh nursingh hosph faminc assets;

sort age65;
by age65: sum medcosth male married age age2 insnone 
epins inspriv medicaid
insnone65 epins65 inspriv65 medicaid65 drtimesh nursingh hosph faminc assets;


reg med 
wave3 wave4 wave5 
male married age age2  
epins inspriv medicaid
insnone65 epins65 inspriv65 medicaid65
linc;

pred medpred;
replace med=med-medpred;

sort indnum wave;
egen id=group(indnum);

keep
id medcost wave2 wave3 wave4 wave5 
male married age age2  
epins inspriv medicaid
insnone65 epins65 inspriv65 medicaid65
linc lassets med doc indnum wave;

order 
id medcost wave2 wave3 wave4 wave5 
male married age age2  
epins inspriv medicaid
insnone65 epins65 inspriv65 medicaid65
linc lassets med doc indnum wave;

summ;

outsheet using d:\gauss\healdn\yandx, nonames replace;

end;
set trace off ;

***************************************************;
* here I generate matrices that are fed into GAUSS ;
* I generate EXCEL tables which I convert to GAUSS datasets in DBMSCOPY;

use `healdn'healdn1;
drop if wave==1;
sort wave;
by wave: tab hrscoh;
by wave: sum medcosth;

gen temp=wave;
*replace temp=3 if wave==2 & (hrscoh==11|hrscoh==12); * change AHEAD wave 2 to wave 3;
* replace temp=2 if wave==1 & (hrscoh==11|hrscoh==12);
replace wave=temp;

sort wave;
by wave: tab hrscoh;
by wave: sum medcosth;

drop if wave>5;
drop if medcosth==.;
* drop if drtimesh==.;
sum medcosth;
* two possible bottom coding rules, shown below;
*drop if medcosth==0; * HSZ coding of data;
replace medcosth=250 if medcosth<250 & medcosth>-1 & medcosth~=.; * censor the distn -our preferred coding of the data;
gen med=ln(medcosth);
* should I log drtimes?;
replace drtimesh=1 if drtimesh<1 & drtimesh~=.;
gen doc=ln(drtimesh);


*egen meanmed=mean(med);
*replace med=med-meanmed;
egen meandoc=mean(doc);
replace doc=doc-meandoc;

* procedure below;
demean;

sum med;
sum med* doc*;

* procedure below;
merger;

sum med* doc*;

* procedure below;
merged;

drop if indnum==indnum[_n+1]; 
drop if medl1==. & medl2==. &  medl3==. & medl4==. &  medl5==. &
docl1==. & docl2==. &  docl3==. & docl4==. &  docl5==.;
sum med*;

*********************************************;
* WANT TO DELETE THESE LINES ASAP!!! ********;
*********************************************;
replace medl1=0;
replace docl1=0;

sum medl* docl*;

* have a look at the covariance matrix here;
* INTERESTING FINDING! -- NOTE THAT THIS COVARIANCE MATRIX IS FOR THE "BALANCED" PANEL - THE VARIANCES AND COVARIANCES ARE MUCH LARGER IN THE UNBALANCED PANEL;
corr medl1 medl2 medl3 medl4 medl5, covariance;
corr docl1 docl2 docl3 docl4 docl5, covariance;

corr medl1 medl2 medl3 medl4 medl5 docl1 docl2 docl3 docl4 docl5, covariance;
corr medl1 medl2 medl3 medl4 medl5 docl1 docl2 docl3 docl4 docl5;

gen icounter=0;
gen jmax=0;

save `healdn'moments, replace;
replace medl1=.;
sort indnum;
keep medl*;
gen uthere1=0;
replace uthere1=1 if medl1~=.; 
gen uthere2=0;
replace uthere2=1 if medl2~=.;
gen uthere3=0;
replace uthere3=1 if medl3~=.;
gen uthere4=0;
replace uthere4=1 if medl4~=.;
gen uthere5=0;
replace uthere5=1 if medl5~=.;
aorder; 
sum;
outsheet using d:\gauss\healdn\mydat, nonames replace;
drop _all;

****************************************************;
* what is below is just for medical costs **********;
****************************************************;
use `healdn'moments;
gen numyear=5;
gen nummom=15;
* couple of procedures below;
moments;
sum mom*;
mydata;
sum vec* momv* uthere*;
* KEEP THE VARIABLES I NEED;
keep vec* uthere* indnum;
sort indnum;
drop indnum;
aorder; *orders vec1-vec15 uthere1-uthere15;
summ;
outsheet using d:\gauss\healdn\momentm, nonames replace;
save d:\gauss\healdn\momentm, replace;
summ;
drop _all;


******************************************************;
* what is below is for medical costs and doctor visits;
******************************************************;
use `healdn'moments;
rename doc1 med6;
rename doc2 med7;
rename doc3 med8;
rename doc4 med9;
rename doc5 med10;

gen numyear=10;
gen nummom=55;
* couple of procedures below;
moments;
sum mom*;
mydata;
sum vec* momv* uthere*;
* KEEP THE VARIABLES I NEED;
keep vec* uthere* indnum;
sort indnum;
drop indnum;
aorder; *orders vec1-vec55 uthere1-uthere55;
outsheet using d:\gauss\healdn\momentdm, nonames replace;
summ;
drop _all;



******************************************************;
* what is below is for doctor visits;
******************************************************;
use `healdn'moments;
drop med*;
rename doc1 med1;
rename doc2 med2;
rename doc3 med3;
rename doc4 med4;
rename doc5 med5;

gen numyear=5;
gen nummom=15;
* couple of procedures below;
moments;
sum mom*;
mydata;
sum vec* momv* uthere*;
* KEEP THE VARIABLES I NEED;
keep vec* uthere* indnum;
sort indnum;
drop indnum;
aorder; *orders vec1-vec15 uthere1-uthere15;
save `healdn'moments, replace;
outsheet using d:\gauss\healdn\momentd, nonames replace;
summ;
drop _all;
log close;

