# delimit ; 
set more 1;  
local UNIX 0;
if `UNIX' == 1 {;
    local saved  "~/hrs/merge/";
    local wave1d "~/hrs/wave1/";
    local wave2d "~/hrs/wave2/";
    local wave3d "~/hrs/wave3/";
    local wave4d "~/hrs/wave4/";
    local wave5d "`/hrs/wave5/";
    local healep "`/hrs/healep/";
};
else { 
    local saved  "d:\hrs\merge\";
    local wave1d "d:\hrs\wave1\";
    local wave2d "d:\hrs\wave2\";
    local wave3d "d:\hrs\wave3\";
    local wave4d "d:\hrs\wave4\";
    local wave5d "d:\hrs\wave5\";
    local healep "d:\hrs\healep\";
};
log using `healep'healep12.log, replace;
set linesize 200;
set memory 100m;
drop _all;
program drop _all;

* take means of different variables, by health insurance;
program define takemean;
    version 6.0;
    drop if wave==1;
    drop if married==.;
    summ epins inspriv insnone medicaid medcare;
    summ ooph drugch ipremh medcosth nursingh hosph drtimesh outsurgh dentisth nodrugh married if epins==1;
* INSPRIV;
summ ooph drugch ipremh medcosth nursingh hosph drtimesh outsurgh dentisth nodrugh married if inspriv==1; 
* INSNONE;
summ ooph drugch ipremh medcosth nursingh hosph drtimesh outsurgh dentisth nodrugh married if insnone==1;
* MEDICAID;
summ ooph drugch ipremh medcosth nursingh hosph drtimesh outsurgh dentisth nodrugh married if medicaid==1;
* MEDCARE;
summ ooph drugch ipremh medcosth nursingh hosph drtimesh outsurgh dentisth nodrugh married if medcare==1;
    gen hitype = 0;
    replace hitype =1 if epins==1;
    replace hitype=2 if inspriv==1;
    replace hitype=3 if insnone==1;
    replace hitype=4 if medicaid==1;
    replace hitype=5 if medcare==1;
    drop if medcosth==.;
  * keep if medcosth>0; * Drop observations with 0 costs as misreports;
    replace medcosth=$minhc if medcosth<$minhc;
    keep medcosth hitype;
    sort hitype;
    by hitype: summ medcosth;
end;

program define newHIreps;
    version 6.0;
    replace epins = lepins;
    replace inspriv = linspriv;
    replace insnone = linsnone;
    replace medicaid = lmedicaid;
    replace medcare = lmedcare;
end;


use `healep'healdn1;
drop if wave==1;
drop if married==.;
gen lmedcost=.;
replace lmedcost=ln(medcosth) if medcosth>0;

global minhc = 250;
gen hc0=0;
replace hc0=1 if medcosth==0;
sort wave;
by wave: summ hc0;
sort indnum wave;
gen hc100=0;
replace hc100=1 if medcosth<100;
gen hc250=0;
replace hc250=1 if medcosth<250;
gen hc500=0;
replace hc500=1 if medcosth<500;

summ male married medcosth lmedcost epins inspriv insnone medicaid medcare wave* hc*;

*************************************************************************;
* summarize health cost and utilization variables, by health insurance type;
* and age group: age groups are 50-64, 65-79, 80+;
*************************************************************************;

drop if age>64; * LOOKING AT YOUNG PEOPLE;
takemean;
drop _all;

use `healep'healdn1;
drop if age<65|age>79; * LOOKING AT MIDDLE AGED PEOPLE;
takemean;
drop _all;

use `healep'healdn1;
drop if age<80; * LOOKING AT THE OLD;
takemean;
drop _all;

use `healep'healdn1;
drop if wave==1;
drop if married==.;
drop if medcosth==.;
keep if medcosth>0; * Drop observations with 0 costs as misreports;
*replace medcosth=$minhc if medcosth<$minhc;

*Now 'Center' logged health costs around the mean;

gen lmed = ln(medcosth);
gen agesq = age^2;
gen epinsy = epins*(age<65);
gen insprivy = inspriv*(age<65);
gen mcaidy = medicaid*(age<65);
gen mcareo = (insnone+medcare)*(age>=65);
gen epinso = epins*(age>=65);
gen insprivo = inspriv*(age>=65);
gen mcaido = medicaid*(age>=65);

summ lmed male married age agesq epinsy insprivy mcaidy mcareo epinso insprivo mcaido linc wave3 wave4 wave5;

regress lmed male married age agesq epinsy insprivy mcaidy mcareo epinso insprivo mcaido linc wave3 wave4 wave5;

predict lhccen, residuals;
egen mlhc = mean(lmed);
replace lhccen = lhccen+mlhc;
gen hccen = exp(lhccen);
summ lmed lhccen medcosth hccen;

keep indnum medcosth age married male wave epins inspriv insnone medicaid medcare linc hccen;
order indnum medcosth age married male wave epins inspriv insnone medicaid medcare linc hccen;
sort indnum wave;
summ;

outfile using `healep'hccosts3.txt, replace wide;

sort indnum wave;

keep indnum wave hccen;
save `healep'healdj1z, replace;

*Calculate "TRUE" autocovariances, using only observations for the same person;
by indnum: gen medclag1 = hccen[_n-1];
by indnum: gen medclag2 = hccen[_n-2];
summ medc*;
correlate hccen medclag1 medclag2;
correlate hccen medclag1 medclag2, covariance;

*Calculate autocovariances using all observations;
replace medclag1 = hccen[_n-1];
replace medclag2 = hccen[_n-2];
gen medclag3 = hccen[_n-3];
gen medclag4 = hccen[_n-4];
summ medc*;
correlate hccen medclag1 medclag2 medclag3 medclag4;
correlate hccen medclag1 medclag2 medclag3 medclag4, covariance;

centile hccen, centile(25,50,75,80,85,90,95,99,99.5);
cumul hccen, gen(medcdf);
gen utail=.;
replace utail = hccen if medcdf >= 0.90;
*Calculate autocovariances using all observations;
drop if utail ==.; 
gen utlag1 = utail[_n-1];
gen utlag2 = utail[_n-2];
gen utlag3 = utail[_n-3];
gen utlag4 = utail[_n-4];
summ ut*;
correlate utail utlag1 utlag2 utlag3 utlag4;
correlate utail utlag1 utlag2 utlag3 utlag4, covariance;
drop _all;


*Redo with a balanced panel;
use `healep'healdj1z;
sort indnum wave;
keep indnum wave hccen;
drop if wave==1;
gen long HHwave = indnum*10+wave;
drop if HHwave==HHwave[_n-1];
drop HHwave;
reshape wide hccen, i(indnum) j(wave);

summ;

gen gotw2 = 1;
replace gotw2 = 0 if hccen2 ==.;
gen gotw3 = 1;
replace gotw3 = 0 if hccen3 ==.;
gen gotw4 = 1;
replace gotw4 = 0 if hccen4 ==.;
gen gotw5 = 1;
replace gotw5 = 0 if hccen5 ==.;

replace hccen2 = 0 if hccen2 ==.;
replace hccen3 = 0 if hccen3 ==.;
replace hccen4 = 0 if hccen4 ==.;
replace hccen5 = 0 if hccen5 ==.;

summ;
order indnum hccen2 hccen3 hccen4 hccen5 gotw2 gotw3 gotw4 gotw5;
outfile using `healep'johndatz.txt, replace wide;
save `healep'healdj2z, replace;

drop if hccen2 ==.;
drop if hccen3 ==.;
drop if hccen4 ==.;
drop if hccen5 ==.;
summ;

correlate hccen2 hccen3 hccen4 hccen5;
correlate hccen2 hccen3 hccen4 hccen5, covariance;

replace hccen2 = . if hccen2 ==0;
replace hccen3 = . if hccen3 ==0;
replace hccen4 = . if hccen4 ==0;
replace hccen5 = . if hccen5 ==0;
drop gotw*;

reshape long hccen, i(indnum) j(wave);
summ;

*Calculate "TRUE" autocovariances, using only observations for the same person;
by indnum: gen medclag1 = hccen[_n-1];
by indnum: gen medclag2 = hccen[_n-2];
summ medc*;
correlate hccen medclag1 medclag2;
correlate hccen medclag1 medclag2, covariance;

*Calculate autocovariances using all observations;
replace medclag1 = hccen[_n-1];
replace medclag2 = hccen[_n-2];
gen medclag3 = hccen[_n-3];
gen medclag4 = hccen[_n-4];
summ medc*;
correlate hccen medclag1 medclag2 medclag3 medclag4;
correlate hccen medclag1 medclag2 medclag3 medclag4, covariance;

drop _all;
program drop _all;
log close ;
