/* Requires COINT 2.0 to run: specifically BASE.SRC and KERNELS.SRC */
proc opt(e,v) ;
     local eb, ef, ae, ee, se, ad, a1, a2, nobs;
     if VARGET("_aband") EQ 1;
         eb = trimr(lag(e,1),1,0) ;
         ef = trimr(e,1,0);
         ae = sumc(eb.*ef)./sumc(eb.^2);
         ee = ef - eb.*(ae');
         se = meanc(ee.^2);
         ad = sumc((se./((1-ae).^2)).^2);
         a1 = 4*sumc((ae.*se./(((1-ae).^3).*(1+ae))).^2)/ad;
         a2 = 4*sumc((ae.*se./((1-ae).^4)).^2)/ad;
         nobs = rows(e) ;
         if VARGET("_ker_fun") == &qs ;
             v = 1.3221*((a2*nobs)^.2)-1;
         elseif VARGET("_ker_fun") == &parzen;
             v = 2.6614*((a2*nobs)^.2)-1;
         elseif VARGET("_ker_fun") == &fejer ;
             v = 1.1447*((a1*nobs)^.333)-1;
         elseif VARGET("_ker_fun") == &tukham ;
             v = 1.7462*((a2*nobs)^.2)-1;
         endif ;
     endif ;
     if v LT 1 ; v = 0; endif ;
retp(v);
endp ;
proc lag(x,p);
     retp(shiftr(x', p, miss(0,0))');
endp;
proc calcrho(x);
     local xbar, varx, temp, x1, x2,j ;
     xbar = meanc(x);
     varx = sumc((x - xbar)^2);
     temp = zeros(rows(x)-1,1);
     x    = x - xbar;
     j = 1;
     do while (j < rows(x));
        x1 = trimr(x,j,0);
        x2 = trimr(lag(x,j),j,0);
        temp[j,1] = (x1'x2/varx)*(rows(x)/rows(x1));
        j = j + 1;
     endo ;
     retp(temp);
endp ;
proc ut(rho,k,t);
     local n, j, s, temp, xx, kk ;
     n = rows(rho);
     j = seqa(1,1,n);
     xx = sin(j*pi*t)./j;
     temp = xx[1:k].*rho[1:k].*weights[1:k];
     retp(sumc(temp)*(sqrt(2*(n+1))/pi));
endp;
proc sequt(x,k);
     local temp, j, rho, n, lrv, ff;
     n = rows(x)-1;
     temp = zeros(n,1);
     j = 1 ;
     rho = calcrho(x);
     k = opt(x,k);
     "Actual band-width = " k ;
     lrv = lrvar(x,k);
     "Long-run variance of the variable = " lrv ;
     ff = sumc((x - meanc(x))^2)/(rows(x)-1);  "Actual variance = " ff ;
     "Ratio of variance to long-run variance = " ff/lrv ;
     do while (j <= n);
        temp[j,1] = ut(rho,k,j/n);
        j = j + 1 ;
     endo ;
     retp(temp);
endp ;
proc (4)=ad(x,k,a);
     local zz,j, adx, adxx, t, zzd, n, n1 ;
     zz = sequt(x,k);
     adx = 0;
     adxx = 0;
     j = 1 ;
     n = rows(zz);
     n1 = rows(zz)/a;
     do while (j < n1);
        t = j/n;
        adx = adx + (zz[j,1]^2)/(t*(1-t));
        adxx = adxx + (zz[j,1]^2);
        j = j + 1;
     endo ;
     zz = trimr(zz,0,1);
     if a EQ 1; n1 = rows(zz); endif ;
retp(adx/n, adxx/n, maxc(abs(zz[1:n1])), abs(maxc(zz[1:n1])-minc(zz[1:n1])));
endp ;
output file=imf_jp.out reset ;
format 13, 8;
load x[762,5]=exc.asc ;
"Full-Period";
x = x[1:241,.] ;
zz = 0;
f = 1 ;
do while (zz LT cols(x));
   zz = zz + 1;
   if (zz EQ 5) ;
   z = packr(x[.,zz]);
   z = diff(ln(z),1);
  "Fixed bandWidth";
   _aband = 0;
   "Band-Width = 10";
   bw = 10;
   _ker_fun = &fejer ;
   "Fejer";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &parzen ;
   "Parzen";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &qs ;
   "Quadratic-Spectral";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &tukham ;
   "Tukey-Hanning";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
   "Band-Width = 25";
   bw = 25;
   _ker_fun = &fejer ;
   "Fejer";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &parzen ;
   "Parzen";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &qs ;
   "Quadratic-Spectral";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &tukham ;
   "Tukey-Hanning";
   {adx,cvm,ks,kt} = ad(z,bw,f); zz~bw~adx~cvm~ks~kt;
/*   "Band-Width = 150";
   bw = 150;
   _ker_fun = &fejer ;
   "Fejer";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &parzen ;
   "Parzen";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &qs ;
   "Quadratic-Spectral";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &tukham ;
   "Tukey-Hanning";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   "Band-Width = 200";
   bw = 200;
   _ker_fun = &fejer ;
   "Fejer";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &parzen ;
   "Parzen";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &qs ;
   "Quadratic-Spectral";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &tukham ;
   "Tukey-Hanning";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   "Automatic-BandWidth Runs";
   _aband = 1;
   bw = 50;
   _ker_fun = &fejer ;
   "Fejer";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &parzen ;
   "Parzen";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &qs ;
   "Quadratic-Spectral";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt;
   _ker_fun = &tukham ;
   "Tukey-Hanning";
   {adx,cvm,ks,kt} = ad(z,bw); zz~bw~adx~cvm~ks~kt; */
    endif;
endo ;
