drop _all
set memory 150000
use cx4853tab23.dta, clear

collapse reform , by(fk d53)
replace reform =1 if reform>0.9
replace reform =0 if reform<0.1
drop if reform>0 & reform<1
sort fk d53
by fk: gen reformmuni=reform[_N]
by fk: gen sw = reform-reform[_n-1]
count if sw<0
by fk: replace sw=sw[_N]
drop if d53==0
keep fk sw reformmuni
sort fk
save sw, replace


use cx4853tab23.dta, clear
sort year
merge year using cpi
drop _merge

sort fk
merge fk using sw
drop _merge 
gen lrealearn = lnearn - log(cpi)

drop if sw==.

collapse lrealearn, by(hife d53 sw reformmuni year)

save lrealearnbyfe, replace

* use  lrealearnbyfe, replace

label def coh 1 "1953 Cohort" 0 "1948 Cohort"
lab values d53 coh
label var d53 cohort


twoway (connected lrealearn year if sw==1 & hife==0 & reformmuni==1, msymbol(smtriangle) connect(ascending)) (connected lrealearn year if sw==0 & hife==0 & reformmuni==1, msymbol(smsquare) clpat(longdash_shortdash) clwidth(vthin) connect(ascending)) (connected lrealearn year if sw==0 & hife==0 & reformmuni==0, msymbol(circle_hollow) clpat(longdash_dot) clwidth(vthin) connect(ascending)), by(d53, legend(span)) ytitle(Average log real earnings) ylabel(1.6(0.1)2) ymlabel(1.625(0.025)2.025, ticks nolabels grid) xlabel(85(1)96) legend(order(1 "1948 cohort not treated/1953 cohort treated" 2 "Both 1948 and 1953 cohorts treated" 3 "Neither 1948 nor 1953 cohorts treated") size(small)) legend(subtitle(Average log earnings by cohort for individuals living in municipalities where:, size(small))) saving(difindiflowfe, replace)

