
****************************
/*GENERATE BASIC VARIABLES*/
****************************

** Global macros
global datasave "\\micro.intra\Projekt\P0992$\P0992_Gem\mydata\MPReplication"
global mydata "\\micro.intra\Projekt\P0992$\P0992_Gem\mydata"


/**Merge Education Variables from Census 1970**/

odbc load, exec("select * from dbo.tn_fob_1970")dsn("P0992") clear
tempfile FOB1970
save `FOB1970'
use "$datasave\BaseRepl.dta", clear

mmerge  P0992_LopNr_PersonNr  using `FOB1970', type(1:1) umatch(P0992_LopNr_PersonNr) ukeep(SkolUtbAlm YrkeUtbAlm)
drop if _merge==2
drop _merge

/**Merge Education Variables from Educational Registers**/
tempfile BASE
save `BASE'
odbc load, exec("select * from dbo.UREG1990")dsn("P0992") clear
tempfile EDU
save `EDU'
use  `BASE'

mmerge  P0992_LopNr_PersonNr  using `EDU', type(1:1) umatch(P0992_LopNr_PersonNr) ukeep(SUN2000Niva SUN2000Niva_Old)
drop if _merge==2
drop _merge

tempfile BASE
save `BASE'




/*   Generate Education Measures  */


destring SUN2000Niva, generate(educLISA)
destring SkolUtbAlm,  generate(utb70)
replace SUN2000Niva_Old="" if SUN2000Niva_Old=="*"
destring SUN2000Niva_Old, generate(educ_OLD)
/*NEW Years of Schooling based on FoB70*/

gen yrseducFOB=12 if  	utb70<99			/*Set everything to Gymn except without skolutbildining*/
replace yrseducFOB=7 if utb70==11				/*Replace 7Year Folkskola*/
replace yrseducFOB=8 if utb70==21				/*Replace 8Year Folkskola*/
replace yrseducFOB=9 if utb70==31				/*Replace 9Year Folkskola/Grundskola*/
replace yrseducFOB=9 if utb70==41				/*Replace Realskola*/
replace yrseducFOB=11 if utb70>=61 & utb70<70				/*11 Years Gymnasium if Ekonomisk lin. according to SUN2000*/
replace yrseducFOB=11 if utb70==62				/*11 Years Gymnasium if Ekonomisk lin. according to SUN2000*/
replace yrseducFOB=11 if utb70==65				/*11 Years Gymnasium if Ekonomisk lin. according to SUN2000*/
replace yrseducFOB=11 if utb70==67				/*11 Years Gymnasium if Ekonomisk lin. according to SUN2000*/
replace yrseducFOB=11 if utb70==69				/*11 Years Gymnasium if Ekonomisk lin. according to SUN2000*/
replace yrseducFOB=. if utb70==.
replace yrseducFOB=. if utb70==99
replace yrseducFOB=. if utb70==89
lab var yrseducFOB "Years of Education (FoB)"

gen postschooling=0 if educLISA<400
replace postschooling=1 if 	educLISA==317 | educLISA==313 | educLISA==310	/* One Year Vocational Training*/
replace postschooling=2 if 	educLISA==327 | educLISA==323 | educLISA==320	/* Two Year Vocational Training*/
replace postschooling=3 if 	educLISA==337 | educLISA==333 | educLISA==330	/* Two Year Vocational Training*/

replace postschooling=1 if 	educLISA>400 & educLISA<430							/* One Year Post Secondary Education*/
replace postschooling=2 if 	educLISA>=520 & educLISA<530										/* Two Years Post Secondary Education*/
replace postschooling=3 if 	educLISA>=530 & educLISA<540											/* Three Years Post Secondary Education*/
replace postschooling=4 if 	educLISA>=540 & educLISA<550											/* Four Years Post Secondary Education*/
replace postschooling=5 if 	educLISA>=550 & educLISA<560											/* Five Years Post Secondary Education*/
replace postschooling=7 if 	educLISA>=600 & educLISA<640						/* Lic. university education */
replace postschooling=9 if 	educLISA==640										/* PhD university education */

cap drop  yearseduc_FOB
gen yearseduc_FOB=yrseducFOB
replace yearseduc_FOB=yrseducFOB+postschooling if postschooling!=.
lab var yearseduc_FOB "Years of education"


/*Generate Education Variables*/

gen yrseduc5=.
replace yrseduc5=7 if  	educLISA<200						/* (old) primary school */
replace yrseduc5=9 if 	educLISA==206 							/* (new) primary school */
replace yrseduc5=9.5 if educLISA==204 | educLISA==200 /* (old) secondary school */
replace yrseduc5=11 if 	educLISA>300 & educLISA<330		/* short high school */
replace yrseduc5=12 if 	educLISA>=330 & educLISA<400			/* long high school */
replace yrseduc5=14 if 	educLISA>400 & educLISA<530			/* short university */
replace yrseduc5=15.5 if educLISA>=530 & educLISA<600			/* long university */
replace yrseduc5=19 if 	educLISA>=600 & educLISA<=640			/* PhD university education */
lab var yrseduc5 "Years of Education (Proper coding Helena Holmlund)"

* yrseduc6 is coded as per yrseduc5 but more detailed
gen yrseduc6=.
replace yrseduc6=7 if  	educLISA<200							/* (old) primary school */
replace yrseduc6=9 if 	educLISA==206 							/* (new) primary school */
replace yrseduc6=9.5 if educLISA==204 | educLISA==200 	/* (old) secondary school */
replace yrseduc6=10 if 	educLISA>300 & educLISA<320 	/* very short high school */
replace yrseduc6=11 if 	educLISA>=320 & educLISA<330	/* short high school */
replace yrseduc6=12 if 	educLISA>=330 & educLISA<400	/* long high school */
replace yrseduc6=14 if 	educLISA>400 & educLISA<530		/* short university */
replace yrseduc6=15.5 if educLISA>=530 & educLISA<600	/* long university */
replace yrseduc6=19 if 	educLISA>=600 & educLISA<640		/* PhD university education */
replace yrseduc6=21 if 	educLISA==640	
lab var yrseduc6 "Years of Education (Proper coding Helena Holmlund)"

/*Generate Education Variables*/

gen yrseducMP=.
replace yrseducMP=7 if  	educ_OLD<2						/* (old) primary school */
replace yrseducMP=9 if 		educ_OLD==2 							/* (new) primary school */
replace yrseducMP=11.5 if 	educ_OLD==3		/* short high school */
replace yrseducMP=13 if 	educ_OLD==4			/* long high school */
replace yrseducMP=15 if 	educ_OLD==5			/* short university */
replace yrseducMP=17 if 	educ_OLD==6			/* long university */
replace yrseducMP=21 if 	educ_OLD==7			/* PhD university education */
lab var yrseducMP "Years of Education (MP 2005)"



cap drop yrseduc_MP
gen yrseduc_MP=.
replace yrseduc_MP=7.33 if yrseduc6==7
replace yrseduc_MP=9.62 if yrseduc6>=9 & yrseduc6<10
replace yrseduc_MP=10.39 if yrseduc6>=10 & yrseduc6<12
replace yrseduc_MP=12.19 if yrseduc6==12
replace yrseduc_MP=13.87 if yrseduc6==14
replace yrseduc_MP=16.77 if yrseduc6==15.5
replace yrseduc_MP=19.57 if yrseduc6>=19 & yrseduc6<22


/*Merge Reform Information*/


/*Note:
 		Cohorts 1943-1954	: Use own Municip. Residence from FoB 1960 
 
*/

/*Adjust for Parish Changes*/

/* Note: 
		We use for birth cohorts > 1948 the parish in 1965. 
		The data forsam6065.dta has all changes between parishes between 1960 and 1965.
		
	-> In order to balance the municip and parishes over time, we replace the 1965 codes with the corresponding 
	1960 codes in case a change occured.
*/
 
cap drop _merge
merge m:1 parish_65 using $mydata\forsam6065.dta, keepusing(parish_60b)
drop if _m==2
drop _m

gen ind=(parish_60b==parish_65)
replace parish_65=parish_60b if parish_60b!="" & byear>1948
replace muni_65=substr(parish_60b,1,4) if parish_60b!="" & byear>1948
 
 
gen muniid = muni_60 if byear>=1943
*replace muniid=MOR_Kommun if byear<1943
*replace muniid=FAR_Kommun if byear<1943 & parloc==2
replace muniid = muni_65 if byear>1948

gen parishid = parish_60 if byear>=1943
*replace parishid=MOR_Forsamling if byear<1943
*replace parishid=FAR_Forsamling if byear<1943 & parloc==2
replace parishid = parish_65 if byear>1948

cap drop _merge
/* muni_birth missing */
*gen muni_birth=substr(birthparish,1,4)

 
*************************************************
********		Merge reform data 		**********
*************************************************

destring muniid, force replace ig("")
rename byear cohort
 
  /*Merge MP reform kommuner*/
 
 mmerge RS6MUN cohort using "\$mydata\districtsMP.dta", type(n:1) umatch(fk cohort) missing(nomatch) uname(MP_) 
rename _m sampMP
 
*****************************
	/*9 year reform*/
*****************************
gen kommun60=muniid
merge m:1 kommun60 using $mydata\slutgiltiga_reformkommuner_fob60.dta.
drop if _merge==2
drop _merge

cap drop treat9
gen treat9=.
replace treat9=1 if (cohort>=firstcohort60 & firstcohort60<.)					/*Treated if cohort chosen for reform or after*/
replace treat9=0 if ((cohort)<firstcohort60) & firstcohort60<.					/*Zero otherwise*/

 

/* from Helena 2015 */
destring parishid, replace ig("")
rename parishid parish60
*rename kommun60 muniid
replace treat9=. if parish60==18017 /*hägersten*/
replace treat9=. if parish60==18018 /*brännkyrka*/
replace treat9=. if parish60==18019 /*vantör*/
replace treat9=. if parish60==18020 /*enskede*/
replace treat9=. if parish60==18021 /*skarpnäck*/
replace treat9=. if parish60==18022 /*farsta*/
replace treat9=. if muniid==281 /*södertälje*/
replace treat9=. if muniid==283 /*sundbyberg*/
replace treat9=. if muniid==580 /*linköping*/
replace treat9=. if muniid==680 /*jönköping*/
replace treat9=. if parish60==128007 /*limhamn*/
replace treat9=. if muniid==1283 /*hälsingborg*/
replace treat9=. if parish60==148016 /*örgryte*/
replace treat9=. if parish60==148017 /*lundby*/
replace treat9=. if parish60==148019 /*brämaregården*/
replace treat9=. if parish60==148003 /*gamlestads=st pauli*/
replace treat9=. if parish60==148006 /*härlanda*/
replace treat9=. if muniid==2482 /*skellefteå*/

*replace treat9=. if muniid==231 /*Östertajle Part of södertälje in 1965*/
*replace treat9=. if parish60==18032 /*hägersten in 1965*/
*replace treat9=. if parish60==18033 /*hägersten in 1965*/
 
 cap drop treat9b
gen treat9b=.
replace treat9b=1 if (cohort>=firstcohort60 & firstcohort60<.)					/*Treated if cohort chosen for reform or after*/
replace treat9b=0 if ((cohort)<firstcohort60) & firstcohort60<.					/*Zero otherwise*/

 lab var treat9 "Treatment Comprehensive (with corrections)"
 lab var treat9b "Treatment Comprehensive (without corrections)"

  gen fe_treat9=muniid 
 gen fe_treat9b=muniid 
 
*****************************
	/*9 year reform - UGU place of residence in 6th grade*/
*****************************

mmerge RS6MUN using "\$mydata\slutgiltiga_reformkommuner_fob60.dta", type(n:1) umatch(kommun60 ) missing(nomatch) uname(UGU_)

drop if _merge==2
drop _merge



 cap drop treat9c
gen treat9c=.
replace treat9c=1 if (cohort>=UGU_firstcohort60 & UGU_firstcohort60<.)					/*Treated if cohort chosen for reform or after*/
replace treat9c=0 if ((cohort)<UGU_firstcohort60) & UGU_firstcohort60<.					/*Zero otherwise*/

 

 gen fe_treat9c=RS6MUN 

*****************************
	/*9 year reform - Parish of Birth*/
*****************************

mmerge fkommun60  using "\$mydata\slutgiltiga_reformkommuner_fob60.dta", type(n:1) umatch(kommun60 ) missing(nomatch) uname(fkb_)

drop if _merge==2
drop _merge



 cap drop treat9d
gen treat9d=.
replace treat9d=1 if (cohort>=fkb_firstcohort60 & fkb_firstcohort60<.)					/*Treated if cohort chosen for reform or after*/
replace treat9d=0 if ((cohort)<fkb_firstcohort60) & fkb_firstcohort60<.					/*Zero otherwise*/


 gen fe_treat9d=fkommun60 

 

 /*Years of Education as In Palme 2005*/

 

 destring Kon, gen(sex2)
 recode sex2 (2=0)
 tab sex2

  gen female=sex2
  recode female (1=0) (0=1)
 
  gen hife_MP=(inrange(RFEDUC,2,4)) if RFEDUC<.
 
  
  
gen less9=( yrseduc_MP<9) if  yrseduc_MP<.
gen  exact9=(yrseduc_MP>=9 & yrseduc_MP<10) if yrseduc_MP<.
gen more9=(yrseduc_MP>10) if yrseduc_MP<.
 
 
lab var less9 "less than 9 years of schooling"
lab var exact9 "9 years of schooling"
lab var  more9 "More than 9 years of schooling"
lab var TS6IVOTP	 "Verbal IQ"  
lab var TS6ISTP	 "Spatial IQ"  
lab var TS6IITP	 "Mathematical IQ"  
lab var female	 "Female \%"  
lab var hife	 "Father's education more than compulsory \% (FoB, 1970)"  
lab var hife_MP	 "Father's education more than compulsory \% (UGU)"  
lab var yrseduc_MP	 "Years of Education (MP, AER)"  
lab var yearseduc_FOB	 "Years of Education (EP)"  

 lab var treat9 "Reform (FoB60/65 with corrections)"
 lab var treat9b "Reform (FoB60/65 without corrections)"
 lab var treat9c "Reform (UGU municipality)"
 lab var treat9d "Reform (Birth municipality)"

  
cap drop dif9_full
 gen dif9_full=cohort-firstcohort60+100
tab dif9_full treat9


 
 /*Sample Restriction*/
 
 ** Drop if missing value on all test
 cap drop miss
 egen miss=rowmiss(TS6IVOTP TS6ISTP TS6IITP TS6STP TS6SESP TS6SSRTP TS6SSWTP TS6SMSP)
 tab miss
 *drop if miss==8													
 
 tab sampMP , mis
 
 cap drop noeduc
 gen noeduc=(educLISA!=.)
 
 tab sampMP noeduc, mis
unique RS6MUN if noeduc==1 & sampMP==3
 
 ** Drop if no education variable in UREG
*drop if educLISA==.
 
cap drop test 
 gen test= RS8SCHT if cohort==1948
 
 forvalues i=6(1)7 {
 	
	replace test=RS`i'SCHT if test==. & cohort==1948
 }
 
 
 cap drop test 
 gen test= RS8SCHT if cohort==1948
 
 forvalues j=1(1)2 {
 	local i=8-`j'
	replace test=RS`i'SCHT if test==. & cohort==1948
 }
 
 
 replace test= RS6SCHT if cohort==1953
 
 tab test
 
 
 
 /*Reform Coding Meghir and Palme (2005)*/
 
 cap drop reformMP2
 gen reformMP2=0  
  replace reformMP2=1 if  (RS6CLASS==1 & cohort==1948) | (RS6CLASS==5 & cohort==1948)   
  replace reformMP2=1 if   (RS6CLASS==0 & cohort==1953) | (RS6CLASS==2 & cohort==1953)  | (RS6CLASS==4 & cohort==1953) 
  
 tab reformMP cohort if miss<8
  tab reformMP2 cohort if miss<8

 keep if (muni_60!="" & cohort==1948) | (muni_65!="" & cohort==1953) 			/*Keep   if  in Sweden at Census */
 
 destring  FAR60_Yrke, gen(focc)
 cap drop focc10
 gen focc10=floor(focc/100)
 
    gen fe_reformMP=fe_treat9c 
   gen fe_reformMP2=fe_treat9c 
 
 save $datasave\anaMP.dta, replace
  

/*Labor Earnings Samples*/
 
 
use  $datasave\anaMP.dta, clear			

 merge 1:m P0992_LopNr_PersonNr using $datasave\income_labor.dta, keepusing(cpi year   inc_earn inc_self)

drop if _m==2
drop _m

 
  gen age=year-cohort
 
 
	gen lninc=ln(inc_earn)
	lab var lninc "Log Inc Tjänst"


  /*Merge MP reform kommuner*/
 
 mmerge RS6MUN cohort using "\$mydata\districtsMP_earn.dta", type(n:1) umatch(fk cohort) missing(nomatch) uname(MPearn_) 
rename _m sampMPearn
 
  cap drop lnearn_MP_INTJ
 gen lnearn_MP_INTJ=lninc if inc_self==0
 
 
 save $datasave\ana_earn_fullMP.dta, replace
 

 
   
