
****************************
/*GENERATE LABOUR EARNINGS */
****************************

** Global macros
global datasave "\\micro.intra\Projekt\P0992$\P0992_Gem\mydata\MPReplication"
global mydata "\\micro.intra\Projekt\P0992$\P0992_Gem\mydata\"
 

use P0992_LopNr_PersonNr  using $datasave\BaseRepl.dta, clear				/*Get Baseample ID */
tempfile BASE
generate year=.
save `BASE'

forvalues i=1980(1)1989{

odbc load, exec("select * from dbo.TN_IoT_`i'")dsn("P0992") clear

tempfile INC
save `INC', replace
use P0992_LopNr_PersonNr  using $datasave\BaseRepl.dta, clear				/*Get Baseample ID */
mmerge  P0992_LopNr_PersonNr  using `INC', type(1:1) umatch(P0992_LopNr_PersonNr) ukeep(Arbink Intj Inro Dagpe Kas)
rename Inro Innrv
drop if _merge==2
drop _merge
gen year=`i'
save `INC', replace

use `BASE', clear
append using `INC'
save `BASE', replace
}
tempfile BASE
save `BASE', replace
forvalues i=1990(1)1992{

odbc load, exec("select * from dbo.IoT`i'")dsn("P0992") clear
rename ARBINK Arbink
rename INTJ Intj
rename INSROR Innrv
tempfile INC
rename KAS Kas 
rename DAGPARB Dagpe
save `INC', replace
use P0992_LopNr_PersonNr  using $datasave\BaseRepl.dta, clear				/*Get Baseample ID */
mmerge  P0992_LopNr_PersonNr  using `INC', type(1:n) umatch(P0992_LopNr_PersonNr) ukeep(Arbink Intj Innrv Kas)
drop if _merge==2
drop _merge
gen year=`i'
bysort P0992_LopNr_PersonNr year: gen counter=_n
keep if counter==1
drop counter
save `INC', replace

use `BASE', clear
append using `INC'
save `BASE', replace

}
tempfile BASE
save `BASE', replace
odbc load, exec("select * from dbo.IoT1994")dsn("P0992") clear
*odbc load, exec("select * from dbo.IoT2005")dsn("P0992") clear

forvalues i=1993(1)1996{
odbc load, exec("select * from dbo.IoT`i'")dsn("P0992") clear
rename CARB Arbink
rename TTJ Intj
rename NRV Innrv
rename TKASSA_TKAS Kas
tempfile INC
save `INC', replace
use P0992_LopNr_PersonNr  using $datasave\BaseRepl.dta, clear				/*Get Baseample ID */
mmerge  P0992_LopNr_PersonNr  using `INC', type(1:n) umatch(P0992_LopNr_PersonNr) ukeep(Arbink Intj Innrv Kas)
drop if _merge==2
drop _merge
gen year=`i'
bysort P0992_LopNr_PersonNr year: gen counter=_n
keep if counter==1
drop counter
save `INC', replace

use `BASE', clear
append using `INC'
save `BASE', replace
}

save $datasave\income_labor.dta, replace
use $datasave\income_labor.dta, clear



drop if year==.
tab year
rename Arbink inc_labor
rename Intj inc_earn
rename Innrv inc_self
rename Kas inc_unempl

 
replace inc_unempl=inc_unempl/100 if  year<1978 
replace inc_unempl=inc_unempl/100 if  year>1993   
 
replace inc_labor=inc_labor/100 if  year<1978 
replace inc_labor=inc_labor/100 if  year>1993  
 
replace inc_earn=inc_earn/100 if  year<1978 
replace inc_earn=inc_earn/100 if  year>1993 

 replace inc_self=inc_self/100 if  year<1978 
replace inc_self=inc_self/100 if  year>1993 
 
/*Check for outliers  /*(GH: looks good up to 2008, then they start being pensioners)*/

bysort year: egen meaninc=mean(inc_labor)
bysort year (inc_labor): gen first=1 if _n==1
*bysort year (cpi): gen cpifirst=1 if _n==1

scatter meaninc year if first==1
*scatter cpi year if cpifirst==1 & year<1990
*drop meaninc first cpifirst
*/

/*Merge Consumer Price Index to deflate earnigns*/

merge m:1 year using $mydata\cpi.dta, gen(mcpi) keepusing(AnnualAver)
tab year if mcpi==2
drop if mcpi==2
drop mcpi
rename AnnualAver cpi

sum cpi if year==2011
sca cpi2011=r(mean)
replace cpi=cpi/cpi2011
 
 
save $datasave\income_labor.dta, replace

