
*************************
/*Balancing Regressions*/
*************************

cd $output\tables					/*Change Folder to Export Tables*/
dir



use $datasave\BaseNewSIP.dta, clear
tempfile data
save `data'

use $anadata\anaMP_NS, clear


* hie (70FOB) blue white (occ) agebirth (cohort *need parent cohort) parent noparent


/*Merge Age at Birth*/
capture drop _m
merge 1:1 id using $datasave\BaseNewSIP.dta, keepusing(bdate)
keep if _m==3
drop _m
mmerge  Lopnr_Mor using `data', type(n:1) umatch(id) uname(MOR_) missing(nomatch) ukeep(bdate)
drop if _m==2
drop _m
mmerge  Lopnr_Far using `data', type(n:1) umatch(id) uname(FAR_) missing(nomatch) ukeep(bdate)
drop if _m==2
drop _m

gen  MOR_agebirth=(bdate-MOR_bdate)/365.25
lab var MOR_agebirth "Age at Birth (Mother)"
gen  FAR_agebirth=(bdate-FAR_bdate)/365.25
lab var FAR_agebirth "Age at Birth (Father)"

gen MOR_miss=(Lopnr_Mor<.)
gen FAR_miss=(Lopnr_Far<.)


* high parent education
gen FAR_hie=(inrange(FAR_utb70,41,89)) if FAR_utb70<.
gen MOR_hie=(inrange(MOR_utb70,41,89)) if MOR_utb70<.

* Parent occupation
destring MOR60_SEI, gen(modses60)

 cap drop  whitecSes1_50
gen whitecSes1_50= modses60 ==6 if modses60 <.	//(arbetsledare - managers) 

gen MOR_white=whitecSes1_50
replace MOR_white=modses60==5 if MOR_white==0 &   modses60 <. //(add middle management - f򲥴agsledare (anst孬da)) 
 
gen MOR_blue=(modses60 >=7 & modses60<9) if modses60 <.		//(Arbetare  - Anst孬da inom serviceyrken) 
 
lab var MOR_blue 	"Blue Collar"
lab var MOR_white	"White Collar"

drop modses60 whitecSes1_50

destring FAR60_SEI, gen(modses60)

 cap drop  whitecSes1_50
gen whitecSes1_50= modses60 ==6 if modses60 <.	//(arbetsledare - managers) 

gen FAR_white=whitecSes1_50
replace FAR_white=modses60==5 if FAR_white==0 &   modses60 <. //(add middle management - f򲥴agsledare (anst孬da)) 
 
gen FAR_blue=(modses60 >=7 & modses60<9) if modses60 <.		//(Arbetare  - Anst孬da inom serviceyrken) 
 
lab var FAR_blue 	"Blue Collar"
lab var FAR_white	"White Collar"


 set more off
/*Set Cluster Fixed Effects (School District)*/ 
 
global regopt1 "vce(cluster muniid)"
global regopt2 "absorb(muniid)  cluster(muniid)"
 
 lab var MOR_hie "High Education" 
 lab var MOR_yrseducFOB "Years of Education" 
 lab var MOR_blue "Blue Collar" 
 lab var MOR_white "White Collar" 
 lab var MOR_agebirth "Age at Birth" 
 lab var MOR_miss "Missing"
 
 lab var FAR_hie "High Education" 
 lab var FAR_yrseducFOB "Years of Education" 
 lab var FAR_blue "Blue Collar" 
 lab var FAR_white "White Collar" 
 lab var FAR_agebirth "Age at Birth" 
 lab var FAR_miss "Missing"

 ***********
 /*PARENTS*/
 ***********
 
 

global x1 "i.cohort sex"
 
 	global y1  MOR_yrseducFOB MOR_hie MOR_white MOR_blue MOR_agebirth MOR_miss
 	global y2  FAR_yrseducFOB FAR_hie FAR_white FAR_blue FAR_agebirth FAR_miss
	global y  yrseducFOB hie white blue agebirth miss
**********************
/*7/8->9-Year Reform*/
**********************
 
**Balancing for Full Sample**
global samp "inrange(cohort,1938,1954) & inrange(dif9_full,95,104)"		/*5-Year Window (HHL)*/
*global samp "inrange(cohort,1938,1954)"		


/*Set Cluster Fixed Effects (School District)*/ 
 
global regopt1 "vce(cluster muniid)"
global regopt2 "absorb(muniid)  cluster(muniid)"
   
 
  
foreach var of varlist $y1 {	
 
/*Mothers*/
 
reg  `var' $x1 $treat if $samp   , $regopt1
est sto regm`var'
_regress  `var' $x1 $treat if  $samp  , $regopt2
est sto regFEm`var'
} 
  
foreach var of varlist $y2 {
/*Fathers*/

reg  `var' $x1 $treat if $samp   , $regopt1
est sto regf`var'
_regress   `var' $x1 $treat if $samp   , $regopt2
est sto regFEf`var'
 
}

 
	global y  yrseducFOB hie white blue agebirth miss

	cap erase bal9PALME_full.tex
foreach var in   $y {	
	local vtext : variable label MOR_`var'
	#delimit ;
	estout      regfFAR_`var' regFEfFAR_`var'   regmMOR_`var'  regFEmMOR_`var'    using bal9PALME_full.tex,    
	 	style(tex)  
		rename($treat treat1 1.treat9 treat1) 	keep(treat1) cells(b(star fmt(3)) se(par fmt(3)))
		starlevels(* 0.10 ** 0.05 *** 0.01) 
		mlabels(,none) collabels(,none) eqlabels(,none) varlabel(treat1 "\rule{0pt}{2ex} `vtext'")  label unstack 
		
		append
		;
	#delimit cr 
} 
 

 
 
**Balancing for Palme Sub Sample**
 

global samp "(cohort==1948) | (cohort==1953)"

  
 
  
foreach var of varlist $y1 {	
 
/*Mothers*/
 
reg  `var' $x1 $treat if $samp   , $regopt1
est sto regm`var'
_regress  `var' $x1 $treat if  $samp  , $regopt2
est sto regFEm`var'
} 
  
foreach var of varlist $y2 {
/*Fathers*/

reg  `var' $x1 $treat if $samp   , $regopt1
est sto regf`var'
_regress   `var' $x1 $treat if $samp   , $regopt2
est sto regFEf`var'
 
}

 

cap erase bal9PALME.tex

foreach var in   $y {	
	local vtext : variable label MOR_`var'	
	#delimit ;
	estout      regfFAR_`var' regFEfFAR_`var'   regmMOR_`var'  regFEmMOR_`var'    using bal9PALME.tex,    
	 	style(tex)  
		rename($treat treat1 1.treat9 treat1) 	keep(treat1) cells(b(star fmt(3)) se(par fmt(3)))
		starlevels(* 0.10 ** 0.05 *** 0.01) 
		mlabels(,none) collabels(,none) eqlabels(,none) varlabel(treat1 "\rule{0pt}{2ex} `vtext'")  label unstack 
		
		append
		;
	#delimit cr 

}


*exit


