
**Figure 1 - Fathers Education**

  set more off
/*Set Cluster Fixed Effects (School District)*/ 

global regopt1 "vce(cluster muniid)"
global regopt2 "absorb(muniid)  cluster(muniid)"

 
use $anadata\anaMP_NS, clear

global samp "(cohort==1948) | (cohort==1953)"
keep if $samp

cap drop fed*
gen fed1=(FAR_yrseducFOB==.)
gen fed2=( FAR_yrseducFOB<9 & FAR_utb70<=31)
gen fed3=( FAR_yrseducFOB==9 & FAR_utb70==41  )	
gen fed4=(FAR_yrseducFOB>=10 & FAR_yrseducFOB<.)	

lab var fed1 "Father Education Missing"
lab var fed2 "Father Education Only Primary"
lab var fed3 "Fathers Education Lower Secondary"
lab var fed4 "Fathers Education Higher Secondary"
		
global dependent "fed1 fed2 fed3 fed4"		
 		

		cd $outfiles
 
	
		foreach i of global dependent {
		_regress `i'  i.cohort##sex $treat if $samp   , $regopt2
		parmest, format(estimate min95 max95) saving(`i'_alt.dta, replace )
	}

/*Descriptive Table*/  
  
    global y "fed1 fed2 fed3 fed4"
  
  estpost su $y   if $samp 
	est sto F1
 
 cd $output\tables\
 
    #delimit ;
 estout F1 using   fatherEDUC.tex , cells(mean(fmt(3))) style(tex)	
				mlabels(,none) collabels(,none) eqlabels(,none) label unstack replace
 	   ;
  #delimit cr
  
/*Plot Effects on Father Education*/

  
 /*Without Helena Correction*/
 
 
cd $outfiles
 

use  fed1_alt.dta, clear
append using  fed2_alt.dta
append using  fed3_alt.dta
append using  fed4_alt.dta
 
 keep if parm=="$treat"
 gen counter2=_n
 
 
 #delimit ;
 
 graph tw (rcap min95 max95 counter2 , color(gray)) (scatter estimate counter2),
 		xtitle("")
		ytitle("Reform Effect", $size)
		legend(off)
 		graphregion(color(white) lwidth(large))
		bgcolor(white)
						xscale( range(.5 4.5) )
						xlab(1 "Missing" 2 "Only Compulsory" 3 "Secondary" 4 "Higher Secondary", angle(45)    $ls)
						yscale(range(-.06, .08)  noex  )
						ylab(-.06(.02).08 , nogrid $ls )
		yline(0)
		aspect(.75)
  ;
 #delimit cr
 
 graph save $output\Figures\fathereduc_full_alt.gph, replace
 graph export $output\Figures\fathereduc_full_alt.pdf, replace
 