********************************
/*BASE DATA: All COHORTS; REFORMS*/
********************************
/* list revisions here, who did them, and what they were */
* Version 2020-10-21: Gawain. First build


**********************************************

set more off
global datasave  "\\micro.intra\projekt\P0524$\P0524_Gem\TN_MK_MF_School_reform_health_SES\mydata\NewSIPBaseData"		/*Save own Data*/

global reformdata "\\micro.intra\projekt\P0524$\P0524_Gem\TN_MK_MF_School_reform_health_SES\mydata\Reform data"

/* STEPS:
			1.) include all cohorts 1930-1985, plus parents 
			2.) Match with Information from the parents
			3.) Match information from the Census to parents
*/

/*Variables

	id = Personal Identification Number (some few duplicates)
	bmonth = Month of Birth
	sex = Sex
	dyear = Year of Death
	birthcountry = Country of Birth
*/



odbc load, exec("select * from dbo.GrundUppg") dsn("P0524_LU_Arbetslivet") clear
rename LopNr_P* id

gen bmonth = substr(FodelseArMan, 5, 2)
destring bmonth, replace
destring FodelseArMan, replace force
gen byear = int(FodelseArMan/100)

gen bdate_error = (bmonth==0 | bmonth>12)
replace bmonth = . if bmonth==0 | bmonth>12

gen bdate = mdy(bmonth, 15, byear)
format bdate %td

tab bmonth

destring Kon, gen(male)
recode male (2=0) 

drop if FelPersonNr==1 /* FelPersonNr==1 have no info in any of the registers, so drop them (these have the birthdate errors*/
drop FelPersonNr bdate_error
drop if AterAnv==1 /*have to drop these as they can be two people in the dataset and we have no idea which is which - get different death dates for e.g */

keep id bmonth byear bdate male

label define sexlbl 1 "Male" 0 "Female"
label values male sexlbl

save "$datasave\INDIV_TCCny.dta", replace

odbc load, exec("select * from dbo.Fodelselandnamn") dsn("P0524_LU_Arbetslivet") clear
rename LopNr_P* id
rename fodel* birthcountry
duplicates drop id, force //drops 1 observation
merge 1:1 id using "$datasave\INDIV_TCCny.dta"
drop if _merge==1 
drop _merge
save "$datasave\INDIV_TCCny.dta", replace
odbc load, exec("select * from dbo.Fodelseforsamling") dsn("P0524_LU_Arbetslivet") clear
rename LopNr id
*rename Fodelseforskod birthparish
*rename FodelseLan birthcounty
bysort id: gen temp = _N
drop if SenPnr==0 & temp==2
drop temp
keep id Fodelse*
merge 1:1 id using "$datasave\INDIV_TCCny.dta"
drop if _merge==1 
drop _merge
save "$datasave\INDIV_TCCny.dta", replace

clear
cd "$datasave\"
unicode analyze INDIV_TCCny.dta
unicode encoding set ISO-8859-1
unicode retranslate INDIV_TCCny.dta


odbc load, exec("select * from dbo.doda") dsn("P0524_LU_Arbetslivet") clear
rename LopNr_PersonNr id
bysort id: gen temp = _N
drop if  temp==2
drop temp
merge 1:1 id using "$datasave\INDIV_TCCny.dta"
drop _merge
gen dyear = int(DodDatum/10000)

tostring DodDatum, gen(deathdate)
gen ddate=date(deathdate,"YMD")
format ddate %td
drop deathdate
gen age_deathm=ddate-bdate


save "$datasave\INDIV_TCCny.dta", replace

/****************************************/
/*** Base sample selection **************/
/****************************************/


use $datasave\INDIV_TCCny  , clear


encode birthcountry, gen(corigin)		
drop 		birthcountry 

/****************************************/
/*** Recode place of birth **************/
/****************************************/
 
merge m:1 byear FodelseForsNamn FodelseLan using "$reformdata\pbcomb_kommun4853.dta"
drop if _merge==2
drop _m*
rename byear cohort
rename kommun60 fkommun60
rename kommun53 fkommun53



 
****************************
/*Match Parents ID to KIDS*/
****************************
save $datasave\BaseNewSIP.dta, replace
odbc load, exec("select * from dbo.KopplingBioAdForaldrar") dsn("P0524_LU_Arbetslivet") clear
bysort LopNr_PersonNr: gen counter=_N
drop if counter==2
drop counter
tempfile parentID
save `parentID'

use  $datasave\BaseNewSIP.dta, clear
mmerge  id  using `parentID', type(1:1) umatch(LopNr_PersonNr)
drop if _merge==2
drop _merge


******************
/*Own and parents residence in 1960*/
******************

/* 
	1.) First sample own residence variables in 1960
	1.) second sample parents residence and SES variables in 1960
*/

save $datasave\BaseNewSIP.dta, replace
odbc load, exec("select * from dbo.FoB60") dsn("P0524_LU_Arbetslivet") clear
bysort LopNr_PersonNr: gen counter=_N
drop if counter!=1		/* 34,257 obs dropped, which is what was done in old SIP. These are likely due to manual coding in the 60s (thinks SCB) */ 
drop counter
rename Forsamling parish
rename Kommun municipality
tempfile FOB60
save `FOB60'

use $datasave\BaseNewSIP.dta, clear
mmerge  id  using `FOB60', type(1:1) umatch(LopNr_PersonNr) ukeep(parish municipality) uname(F60_)
drop if _merge==2
drop _merge

mmerge  Lopnr_Mor  using `FOB60', type(n:1) umatch(LopNr_PersonNr) uname(MOR60_) missing(nomatch)
drop if _merge==2
drop _merge

mmerge  Lopnr_Far  using `FOB60', type(n:1) umatch(LopNr_PersonNr) uname(FAR60_) missing(nomatch)
drop if _merge==2
drop _merge


******************
/*Own residence in 1965*/
******************


save $datasave\BaseNewSIP.dta, replace
odbc load, exec("select * from dbo.FoB65") dsn("P0524_LU_Arbetslivet") clear
bysort LopNr_PersonNr: gen counter=_N
drop if counter!=1 		/* 11,714 obs dropped */
drop counter
rename Forsamling parish
rename Kommun municipality
tempfile FOB65
save `FOB65'

use $datasave\BaseNewSIP.dta, clear
mmerge  id  using `FOB65', type(1:1) umatch(LopNr_PersonNr) ukeep(parish municipality) uname(F65_)
drop if _merge==2
drop _merge

save $datasave\BaseNewSIP.dta, replace




******************
/* 9 year reform data */
******************

/*Note:
 		Cohorts 1943-1954	: Use own Municip. Residence from FoB 1960 
 
*/

/*Adjust for Parish Changes*/

/* Note: 
		We use for birth cohorts > 1948 the parish in 1965. 
		The data forsam6065.dta has all changes between parishes between 1960 and 1965.
		
	-> In order to balance the municip and parishes over time, we replace the 1965 codes with the corresponding 
	1960 codes in case a change occured.
*/



use $datasave\BaseNewSIP.dta, clear
cd $datasave
rename F65_parish parish_65
merge m:1 parish_65 using "forsam6065.dta", keepusing(parish_60b)
drop if _m==2
drop _m

gen ind=(parish_60b==parish_65)
replace parish_65=parish_60b if parish_60b!="" & cohort>1948
replace F65_municipality=substr(parish_60b,1,4) if parish_60b!="" & cohort>1948
rename  parish_65 F65_parish

gen parsame=(MOR60_municipality==FAR60_municipality)
gen parloc=0 if FAR60_municipality=="" & MOR60_municipality=="" 						/*No info on parents location in 1960*/
replace parloc=1 if MOR60_municipality!="" & FAR60_municipality=="" 					/*Only Mothers in FoB1960*/
replace parloc=2 if MOR60_municipality=="" & FAR60_municipality!=""						/*Only Fathers in FoB1960*/ 	
replace parloc=3 if FAR60_municipality!="" & MOR60_municipality!="" & parsame==0		/*Both are included but different place or residence*/
replace parloc=4 if FAR60_municipality!="" & MOR60_municipality!="" & parsame==1		/*Both are included and same place of residence*/


#delimit ;
label define parloc
 		0 "No Info on parents"
		1 "Only Mothers in FoB1960"
		2 "Only Fathers in FoB1960"
		3 "Both in FoB1960, but different place"
		4 "Both in FoB1960, same place"
;
#delimit cr
lab val parloc parloc
lab var parloc "Information Municipality of Residence Parents FoB60"

drop ind 
drop parsame
/*Merge Reform Information*/
 
gen muniid = F60_municipality if cohort>=1943
replace muniid=MOR60_municipality if cohort<1943
replace muniid=FAR60_municipality if cohort<1943 & parloc==2
replace muniid = F65_municipality if cohort>1948

gen parishid = F60_parish if cohort>=1943
replace parishid=MOR60_parish if cohort<1943
replace parishid=FAR60_parish if cohort<1943 & parloc==2
replace parishid = F65_parish if cohort>1948



/* muni_birth missing */
*gen muni_birth=substr(birthparish,1,4)



*************************************************
********		Merge reform data 		**********
*************************************************

destring muniid, force replace ig("")
destring parishid, force replace ig("")



*****************************
	/*9 year reform*/
*****************************
gen kommun60=muniid
merge m:1 kommun60 using "$reformdata\slutgiltiga_reformkommuner_fob60.dta"
drop if _merge==2
drop _merge

cap drop treat9
gen treat9=.
replace treat9=1 if (cohort>=firstcohort60 & firstcohort60<.)					/*Treated if cohort chosen for reform or after*/
replace treat9=0 if ((cohort)<firstcohort60) & firstcohort60<.					/*Zero otherwise*/

 

/* from Helena 2015 */
*destring parishid, replace ig("")
*rename parishid parish60
*rename kommun60 muniid
replace treat9=. if parish60==18017 /*hägersten*/
replace treat9=. if parish60==18018 /*brännkyrka*/
replace treat9=. if parish60==18019 /*vantör*/
replace treat9=. if parish60==18020 /*enskede*/
replace treat9=. if parish60==18021 /*skarpnäck*/
replace treat9=. if parish60==18022 /*farsta*/
replace treat9=. if muniid==281 /*södertälje*/
replace treat9=. if muniid==283 /*sundbyberg*/
replace treat9=. if muniid==580 /*linköping*/
replace treat9=. if muniid==680 /*jönköping*/
replace treat9=. if parish60==128007 /*limhamn*/
replace treat9=. if muniid==1283 /*hälsingborg*/
replace treat9=. if parish60==148016 /*örgryte*/
replace treat9=. if parish60==148017 /*lundby*/
replace treat9=. if parish60==148019 /*brämaregården*/
replace treat9=. if parish60==148003 /*gamlestads=st pauli*/
replace treat9=. if parish60==148006 /*härlanda*/
replace treat9=. if muniid==2482 /*skellefteå*/

*replace treat9=. if muniid==231 /*Östertajle Part of södertälje in 1965*/
*replace treat9=. if parish60==18032 /*hägersten in 1965*/
*replace treat9=. if parish60==18033 /*hägersten in 1965*/
 
 cap drop treat9b
gen treat9b=.
replace treat9b=1 if (cohort>=firstcohort60 & firstcohort60<.)					/*Treated if cohort chosen for reform or after*/
replace treat9b=0 if ((cohort)<firstcohort60) & firstcohort60<.					/*Zero otherwise*/

 lab var treat9 "Treatment Comprehensive (with corrections)"
 lab var treat9b "Treatment Comprehensive (without corrections)"

 
*****************************
	/*9 year reform -  place of birth */
*****************************

cd "$reformdata\"
mmerge fkommun60  using "slutgiltiga_reformkommuner_fob60.dta", type(n:1) umatch(kommun60 ) missing(nomatch) uname(fkb_)

drop if _merge==2
drop _merge



 cap drop treat9d
gen treat9d=.
replace treat9d=1 if (cohort>=fkb_firstcohort60 & fkb_firstcohort60<.)					/*Treated if cohort chosen for reform or after*/
replace treat9d=0 if ((cohort)<fkb_firstcohort60) & fkb_firstcohort60<.					/*Zero otherwise*/

 lab var treat9d "Treatment Comprehensive (Place of Birth)"

compress
save $datasave\ReformsNewSIP.dta, replace


