 
/*IV RESULTS, Sample Cohorts Meghir & Palme (2005)*/

**Cohort: 1948, 1953
**Earnings: 1985-1996
 
********************** 
/*Regression Results*/ 
********************** 

*keep if inrange(muniid,200,400)
use "$data\cx4853tab23.dta", clear					

 set more off
 
 global x1 "i.cohort##sex  i.year"

  gen kommun60=fk
 
 merge m:1 kommun60 using "$reformdata\slutgiltiga_reformkommuner_fob60.dta"
 
 
set more off

rename reform treat9
rename fk muniid
rename female sex
rename lnearn lnearn_MP_INTJ 

gen cohort=1948 if d53==0
replace cohort=1953 if d53==1

recode sex (1=0) (0=1)
 
/*Treatment based on Holmlund Reform Assignment (2008)*/ 
 
 cap drop treat9c
 gen treat9c=(cohort>=firstcohort60) if firstcohort60<.
   tab treat9c cohort
   tab treat9c treat9
 
 
**Reduced Form Earnings
  
global y  "lnearn_MP_INTJ"
global samp "inrange(year,85,96)"

gen treat9FE=muniid
gen treat9cFE=muniid

 lab var treat9 "Reform (10\% Sample, AER)" 
 global treat "treat9 treat9c"


/*Both*/
foreach i of varlist $treat {
foreach var of varlist  $y {	


		global sex "sex<=1" 
		parmby "reghdfe `var'  `i'     if  $samp &  $sex , cl(`i'FE )   absorb(`i'FE  $x1) ",  saving("$results\AER_`var'_`i'_all.dta", replace)

		parmby "reghdfe `var'   `i'      if  $samp &  $sex & hife==0, cl(`i'FE )   absorb(`i'FE  $x1) ",  saving("$results\AER_`var'_`i'_all_lfeMP.dta", replace)	
		
		parmby "reghdfe `var'   `i'      if  $samp &  $sex & hife==1, cl(`i'FE )   absorb(`i'FE  $x1) ",  saving("$results\AER_`var'_`i'_all_hfeMP.dta", replace)	

 
}
}
 
 