 
/*Graphics Setting*/
set scheme s1mono
graph set window fontface "Times New Roman"

global size size(large)
global ls labsize(medium)
global legs size(medium) 

 

	use "$results\results_JAE.dta", clear
 

*br
/*REsults from MP 2005, AER*/
 gen mp=0.014 if ses==1
gen mp_uci=0.014+1.96*0.0089	 if ses==1		/*Upper CI*/
gen mp_lci=0.014-1.96*0.0089	 if ses==1		/*Lower CI*/

replace mp=0.036 if ses==2
replace mp_uci=0.036+1.96*0.0091	 if ses==2		/*Upper CI*/
replace mp_lci=0.036-1.96*0.0091	 if ses==2		/*Lower CI*/

replace mp=-0.059 if ses==3
replace mp_uci=-0.059+1.96*0.0188	 if ses==3		/*Upper CI*/
replace mp_lci=-0.059-1.96*0.0188	 if ses==3		/*Lower CI*/
  
  global space "titlegap(2)"

  global ses "ses==1"


*keep if parmseq==1
sort ses parm outcome 
cap drop estno
cap drop estlab
bys sample ses (parm type outcome): gen estno=_n
bys sample ses parm   (type outcome): gen estlab=_n

 *br outcome sample  parm ses type estno estlab
 

replace estno=estno+3 if sample!="SAMPLE_AER" & $ses
replace estno=estno+5 if sample=="SIP" & $ses

replace estno=estno+1 if parm=="treat9b"&sample=="SAMPLE_UGU"
replace estno=estno-1 if parm=="treat9c"&sample=="SAMPLE_UGU"
replace estno=estno if parm=="treat9d"&sample=="SAMPLE_UGU"
replace estno=estno if parm=="reformMP2"&sample=="SAMPLE_UGU"

replace estno=0.9 if estno==1
replace estno=2.1 if estno==2

replace estno=3.8 if estno==4
replace estno=4.9 if estno==5
replace estno=6.1 if estno==6
replace estno=7.2 if estno==7

replace estno=8.9 if estno==9
replace estno=10.1 if estno==10



sum mp if ses==1
local a=`r(mean)'
sum mp_uci if ses==1
local b=r(mean)
sum mp_lci if ses==1
local c=r(mean)

global ystart "-.15"
global ydif ".05"
global yend	".15"
 
 #delimit ;
 graph twoway 	

				(scatter estimate estno if ses==1 & parm=="reformMP",  msymbol(Oh)    mlabangle(45)  mlabsize(medium))
				(rspike min95 max95 estno if ses==1 & parm=="reformMP", lc(gs3)  )	 
				(scatter estimate estno if ses==1 & parm=="reformMP2",  msymbol(Oh)    mlabangle(45)  mlabsize(medium))
				(rspike min95 max95 estno if ses==1 & parm=="reformMP2", lc(gs3)  )	 
 				(scatter estimate estno if ses==1 & parm=="treat9c",  msymbol(Dh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if ses==1 & parm=="treat9c", lc(gs3)  )
				(scatter estimate estno if ses==1 & parm=="treat9b",  msymbol(Th)     mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if ses==1 & parm=="treat9b", lc(gs3))
 				(scatter estimate estno if ses==1 & parm=="treat9d",  msymbol(Sh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if ses==1 & parm=="treat9d", lc(gs3)  )				
				,				title("", $size pos(11) ring(0) )
				ytitle("Reform Effect", $size ) 
				xtitle("", $size) 
			yscale(  range( $ystart  $yend) $space  ) 
				ylab(   $ystart ($ydif) $yend  ,  format(%5.3f) angle(0)  $ls)  				
				graphregion(color(white ))   bgcolor(white)
				xlab(0.9  `" "MP" "2005" "'   2.1 `" "UGU" "Muni" "' 3.8 `" "MP" "2005" "' 6.1 `" "FoB" "60/65" "'  4.9 `" "UGU" "Muni" "' 7.2 `" "Place of" "Birth" "'  8.9 `" "FoB" "60/65" "'  10.1 `" "Place of" "Birth" "' , nogrid $ls) 
				xscale( range(0.2 10.8)  )
				yline(`a', lc(cranberry))
				yline(`b' `c', lc(cranberry) lp(dash))				
				legend(order(1 "MP 2005"  3 "UGU munic." 5 "FoB 60/65" 7 "Birthplace") $legs col(4) position(6) off  title("Specification / Reform Assignment")   region(col(white)))
				xline(3 8, lp(dash))
  text(0.14 1.5 "AER Sample", place(c) $legs)
  text(0.14 5.4 "UGU Sample", place(c) $legs)
  text(0.14 9.6 "Full Population", place(c) $legs)
  text(-0.178 0.3 "Reform" "Assignment", place(w) justification(right) $legs)
  
 ;
#delimit cr

 tab parm

graph export "$graphs\pooled.pdf", replace
 
sort ses parm outcome 
cap drop estno
cap drop estlab
bys sample ses type (parm  outcome): gen estno=_n
bys sample ses  type parm   ( outcome): gen estlab=_n

  global ses "ses==2"
  *br outcome sample  parm ses type estno estlab if ses==2

replace estno=estno+3 if sample!="SAMPLE_AER" & $ses
replace estno=estno+5 if sample=="SIP" & $ses

replace estno=estno+1 if parm=="treat9b"&sample=="SAMPLE_UGU"
replace estno=estno-1 if parm=="treat9c"&sample=="SAMPLE_UGU"


replace estno=0.9 if estno==1
replace estno=2.1 if estno==2

replace estno=3.4 if estno==4
replace estno=4.6 if estno==5
replace estno=5.8 if estno==6
replace estno=7 if estno==7

replace estno=8.5 if estno==9
replace estno=9.7 if estno==10


 
 replace estno=estno   if type=="EDUSURV" & $ses
 replace estno=estno +.2 if type=="EDU70" & $ses
 replace estno=estno +.4 if type=="OCC60" & $ses


 
sum mp if $ses
local a=`r(mean)'
sum mp_uci if $ses
local b=r(mean)
sum mp_lci if $ses
local c=r(mean)

global ystart "-.15"
global ydif ".05"
global yend	".15"
 
 #delimit ;
 graph twoway 	

  				(line estimate estno if ses==10 & parm=="treat9d",  lc(gs3) lwidth(thick))
 				(line estimate estno if ses==10 & parm=="treat9d",  lc(blue*.7) lwidth(thick))
 				(line estimate estno if ses==10 & parm=="treat9d",  lc(green*.7)   lwidth(thick))

 
				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="reformMP",  msymbol(Oh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="reformMP", lc(gs3)  )	 
				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="reformMP2",  msymbol(Oh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="reformMP2", lc(gs3)  )	 
 				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="treat9c",  msymbol(Dh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="treat9c", lc(gs3)  )
				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="treat9b",  msymbol(Th)     mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="treat9b", lc(gs3))
 				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="treat9d",  msymbol(Sh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="treat9d", lc(gs3)  )	
				

				(scatter estimate estno if type=="EDU70" & $ses & parm=="reformMP",  msymbol(Oh) mc(blue)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="reformMP", lc(blue*.7)  )	 
				(scatter estimate estno if type=="EDU70" & $ses & parm=="reformMP2",  msymbol(Oh) mc(blue)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="reformMP2", lc(blue*.7)  )	 
 				(scatter estimate estno if type=="EDU70" & $ses & parm=="treat9c",  msymbol(Dh) mc(blue)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="treat9c", lc(blue*.7)  )
				(scatter estimate estno if type=="EDU70" & $ses & parm=="treat9b",  msymbol(Th)  mc(blue)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="treat9b", lc(blue*.7))
 				(scatter estimate estno if type=="EDU70" & $ses & parm=="treat9d",  msymbol(Sh) mc(blue)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="treat9d", lc(blue*.7)  )	
				
				(scatter estimate estno if type=="OCC60" & $ses & parm=="reformMP",  msymbol(Oh) mc(green)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="reformMP", lc(green*.7)  )	 
				(scatter estimate estno if type=="OCC60" & $ses & parm=="reformMP2",  msymbol(Oh) mc(green)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="reformMP2", lc(green*.7)  )	 
 				(scatter estimate estno if type=="OCC60" & $ses & parm=="treat9c",  msymbol(Dh) mc(green)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="treat9c", lc(green*.7)  )
				(scatter estimate estno if type=="OCC60" & $ses & parm=="treat9b",  msymbol(Th)  mc(green)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="treat9b", lc(green*.7))
 				(scatter estimate estno if type=="OCC60" & $ses & parm=="treat9d",  msymbol(Sh) mc(green)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="treat9d", lc(green*.7)  )									
 ,				title("", $size pos(11) ring(0) )
				ytitle("Reform Effect", $size ) 
				xtitle("", $size) 
	yscale(  range( $ystart  $yend) $space  ) 
 
				ylab(   $ystart ($ydif) $yend  ,    format(%5.3f) angle(0)  $ls)  				
				graphregion(color(white ))   bgcolor(white)
 				xlab(0.9  `" "MP" "2005" "'   2.1 `" "UGU" "Muni" "' 3.6  `" "MP" "2005" "'  6 `" "FoB" "60/65" "'  4.8 `" "UGU" "Muni" "' 7.2 `" "Place of" "Birth" "'  8.8 `" "FoB" "60/65" "'  10 `" "Place of" "Birth" "' , nogrid $ls) 
				xscale( range(.3 10.7)  )
				yline(`a', lc(cranberry))
				yline(`b' `c', lc(cranberry) lp(dash))				
				legend(order(1 "Edu Survey" 2 "Edu FoB70" 3 "SES FoB60") $legs col(3) ring(1) position(6)   color(black) title("Father SES from")  /* region(col(white))*/)
				xline(2.7 8, lp(dash))
		 text(0.14 1.4 "AER Sample", place(c) $legs)
  text(0.14 5.4 "UGU Sample", place(c) $legs)
  text(0.14 9.4 "Full Population", place(c) $legs)
  text(-0.186 0.37 "Reform" "Assignment", place(w) justification(right) $legs)
 ;
#delimit cr
 


 
  graph export "$graphs\lowSES.pdf", replace

 
  sort ses parm outcome 
cap drop estno
cap drop estlab
bys sample ses type (parm  outcome): gen estno=_n
bys sample ses  type parm   ( outcome): gen estlab=_n

  global ses "ses==3"
  *br outcome sample  parm ses type estno estlab if ses==2

replace estno=estno+3 if sample!="SAMPLE_AER" & $ses
replace estno=estno+5 if sample=="SIP" & $ses

 replace estno=estno+1 if parm=="treat9b"&sample=="SAMPLE_UGU"
 replace estno=estno-1 if parm=="treat9c"&sample=="SAMPLE_UGU"


replace estno=0.9 if estno==1
replace estno=2.1 if estno==2

replace estno=3.4 if estno==4
replace estno=4.6 if estno==5
replace estno=5.8 if estno==6
replace estno=7 if estno==7

replace estno=8.5 if estno==9
replace estno=9.7 if estno==10


 replace estno=estno   if type=="EDUSURV" & $ses
 replace estno=estno +.2 if type=="EDU70" & $ses
 replace estno=estno +.4 if type=="OCC60" & $ses

 
sum mp if $ses
local a=`r(mean)'
sum mp_uci if $ses
local b=r(mean)
sum mp_lci if $ses
local c=r(mean)

global ystart "-.15"
global ydif ".05"
global yend	".15"
 
 #delimit ;
 graph twoway 	
 
   				(line estimate estno if ses==10 & parm=="treat9d",  lc(gs3) lwidth(thick))
 				(line estimate estno if ses==10 & parm=="treat9d",  lc(blue*.7) lwidth(thick))
 				(line estimate estno if ses==10 & parm=="treat9d",  lc(green*.7)   lwidth(thick))



				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="reformMP",  msymbol(Oh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="reformMP", lc(gs3)  )	 
				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="reformMP2",  msymbol(Oh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="reformMP2", lc(gs3)  )	 
 				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="treat9c",  msymbol(Dh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="treat9c", lc(gs3)  )
				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="treat9b",  msymbol(Th)     mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="treat9b", lc(gs3))
 				(scatter estimate estno if type=="EDUSURV" & $ses & parm=="treat9d",  msymbol(Sh)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDUSURV" & $ses & parm=="treat9d", lc(gs3)  )	
				
				

				(scatter estimate estno if type=="EDU70" & $ses & parm=="reformMP",  msymbol(Oh) mc(blue)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="reformMP", lc(blue*.7)  )	 
				(scatter estimate estno if type=="EDU70" & $ses & parm=="reformMP2",  msymbol(Oh) mc(blue)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="reformMP2", lc(blue*.7)  )	 
 				(scatter estimate estno if type=="EDU70" & $ses & parm=="treat9c",  msymbol(Dh) mc(blue)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="treat9c", lc(blue*.7)  )
				(scatter estimate estno if type=="EDU70" & $ses & parm=="treat9b",  msymbol(Th)  mc(blue)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="treat9b", lc(blue*.7))
 				(scatter estimate estno if type=="EDU70" & $ses & parm=="treat9d",  msymbol(Sh) mc(blue)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="EDU70" & $ses & parm=="treat9d", lc(blue*.7)  )	
				
				(scatter estimate estno if type=="OCC60" & $ses & parm=="reformMP",  msymbol(Oh) mc(green)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="reformMP", lc(green*.7)  )	 
				(scatter estimate estno if type=="OCC60" & $ses & parm=="reformMP2",  msymbol(Oh) mc(green)   mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="reformMP2", lc(green*.7)  )	 
 				(scatter estimate estno if type=="OCC60" & $ses & parm=="treat9c",  msymbol(Dh) mc(green)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="treat9c", lc(green*.7)  )
				(scatter estimate estno if type=="OCC60" & $ses & parm=="treat9b",  msymbol(Th)  mc(green)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="treat9b", lc(green*.7))
 				(scatter estimate estno if type=="OCC60" & $ses & parm=="treat9d",  msymbol(Sh) mc(green)    mlabangle(45)  mlabsize(medium) )
				(rspike min95 max95 estno if type=="OCC60" & $ses & parm=="treat9d", lc(green*.7)  )	
								
 ,				title("", $size pos(11) ring(0) )
				ytitle("Reform Effect", $size  ) 
				xtitle("", $size) 
				yscale(  range( $ystart  $yend) $space  ) 
 
				ylab(   $ystart ($ydif) $yend  ,   format(%5.3f) angle(0)  $ls)  				
 				xlab(0.9  `" "MP" "2005" "'   2.1 `" "UGU" "Muni" "' 3.6  `" "MP" "2005" "'  6 `" "FoB" "60/65" "'  4.8 `" "UGU" "Muni" "' 7.2 `" "Place of" "Birth" "'  8.8 `" "FoB" "60/65" "'  10 `" "Place of" "Birth" "' , nogrid $ls) 
				xscale( range(.3 10.7)  )
				yline(`a', lc(cranberry))
				yline(`b' `c', lc(cranberry) lp(dash))				
				legend(order(1 "Edu Survey" 2 "Edu FoB70" 3 "SES FoB60") $legs col(3) ring(1) position(6)   color(black) title("Father SES from")  /* region(col(white))*/)
				xline(2.7 8, lp(dash))
		 text(0.14 1.4 "AER Sample", place(c) $legs)
  text(0.14 5.4 "UGU Sample", place(c) $legs)
  text(0.14 9.4 "Full Population", place(c) $legs)
  text(-0.204 0.37 "Reform" "Assignment", place(w) justification(right) $legs)

		 
 ;
#delimit cr
 

  graph export "$graphs\highSES.pdf", replace
 
 
 
 exit
 
