#delimit;


/****************************************************/
/* permanent parental income */
/****************************************************/

/* This file takes a measure of permanent parental income as constructed
by J. Taylor at IFS. The derived variable is in log. */

cap drop YTPIFS_F;
ge YTPIFS_F=exp(p_faminc);


/* deflate to January 2001 prices */

cap drop rpiyr; qui ge rpiyr=n2358+1900; /* deflate to Jan 2001 prices */
qui su n2358, detail; qui replace rpiyr=`r(p50)'+1900 if inrange(n2358,74,75)!=1;
cap drop rpimth; qui ge rpimth=n2356;
qui su n2356, detail; qui replace rpimth=`r(p50)' if inrange(n2356,1,12)!=1;

cap drop *merge;
sort rpiyr rpimth;
merge rpiyr rpimth using price_ind.dta, keep(rpi) update replace;
keep if inlist(_merge,1,3);

qui replace YTPIFS_F=YTPIFS_F/rpi;
cap drop rpi *merge;
su YTPIFS_F;
