/* This do file derives parental income at the age of 16, 11 and 7, using observed parental income
at age 16, and time varying characteristics at the age of 7, 11 and 16. */

#delimit;

tempvar Fage7 ; qui ge `Fage7 '=n494+7;
tempvar Mage7 ; qui ge `Mage7 '=n553+7;
tempvar Fage11; qui ge `Fage11'=n494+11;
tempvar Mage11; qui ge `Mage11'=n553+11;
tempvar Fage16; qui ge `Fage16'=n494+16;
tempvar Mage16; qui ge `Mage16'=n553+16;

xi, prefix(Drg0) i.reg0_F; /* create dummy region in 1965 */
xi, prefix(Drg1) i.reg1_F; /* create dummy region in 1969 */
xi, prefix(Drg2) i.reg2_F; /* create dummy region in 1974 */

xi, prefix(Dsc0) i.WF00_F; /* create dummy social class in 1965 */
xi, prefix(Dsc1) i.WF11_F; /* create dummy social class in 1969 */
xi, prefix(Dsc2) i.WF22_F; /* create dummy social class in 1974 */

global x7  = "Dsc0* `Fage7 '  `Mage7 '  Drg0* wrkM0_F";
global x11 = "Dsc1* `Fage11 ' `Mage11 ' Drg1* wrkM1_F";   
global x16 = "Dsc2* `Fage16 ' `Mage16 ' Drg2* wrkM2_F";           

/* compute age 16 regression coeffs */
reg YT_F $x16;
matrix mat=e(b);
*predict new if YT_F!=., xb;

/* compute predicted */
cap drop YT0_F;
qui ge YT0_F=0 if YT_F!=.; 
label var YT0_F "predicted income in 1965";
local i=1;
foreach var of varlist $x7{;
qui replace YT0_F=YT0_F+mat[1,`i']*`var';
local i=`i'+1;
};
qui replace YT0_F=YT0_F+mat[1,`i'];

cap drop YT1_F;
qui ge YT1_F=0 if YT_F!=.;
label var YT1_F "predicted income in 1969";
local i=1;
foreach var of varlist $x11{;
qui replace YT1_F=YT1_F+mat[1,`i']*`var';
local i=`i'+1;
};
qui replace YT1_F=YT1_F+mat[1,`i'];

cap drop YT2_F;
qui ge YT2_F=0 if YT_F!=.;
label var YT2_F "predicted income in 1974";
local i=1;
foreach var of varlist $x16{;
qui replace YT2_F=YT2_F+mat[1,`i']*`var';
local i=`i'+1;
};
tempvar YT2; qui ge `YT2'=YT2_F; /* to be used in computing permanent income (no constant) */
qui replace YT2_F=YT2_F+mat[1,`i'];

cap drop YTP_F;
qui ge YTP_F=0 if YT_F!=.;
label var YTP_F "predicted permanent income";
qui replace YTP_F=YT_F-`YT2';

su YT_F YT2_F YT1_F YT0_F YTP_F if YT_F!=.; 
